/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DBAccess;
import org.snaker.engine.IManagerService;
import org.snaker.engine.IOrderService;
import org.snaker.engine.IProcessService;
import org.snaker.engine.IQueryService;
import org.snaker.engine.ITaskService;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.transaction.TransactionInterceptor;
import org.snaker.engine.cache.CacheManager;
import org.snaker.engine.cache.CacheManagerAware;
import org.snaker.engine.cache.memory.MemoryCacheManager;
import org.snaker.engine.cfg.Configuration;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.core.Execution;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.DateHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.NodeModel;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.model.StartModel;
import org.snaker.engine.model.TaskModel;
import org.snaker.engine.model.TransitionModel;

public class SnakerEngineImpl
implements SnakerEngine {
    private static final Logger log = LoggerFactory.getLogger(SnakerEngineImpl.class);
    protected Configuration configuration;
    protected IProcessService processService;
    protected IOrderService orderService;
    protected ITaskService taskService;
    protected IQueryService queryService;
    protected IManagerService managerService;

    @Override
    public SnakerEngine configure(Configuration config) {
        CacheManager cacheManager;
        this.configuration = config;
        this.processService = ServiceContext.find(IProcessService.class);
        this.queryService = ServiceContext.find(IQueryService.class);
        this.orderService = ServiceContext.find(IOrderService.class);
        this.taskService = ServiceContext.find(ITaskService.class);
        this.managerService = ServiceContext.find(IManagerService.class);
        if (!this.configuration.isCMB()) {
            DBAccess access = ServiceContext.find(DBAccess.class);
            AssertHelper.notNull(access);
            TransactionInterceptor interceptor = ServiceContext.find(TransactionInterceptor.class);
            Object accessObject = this.configuration.getAccessDBObject();
            if (accessObject != null) {
                if (interceptor != null) {
                    interceptor.initialize(accessObject);
                }
                access.initialize(accessObject);
            }
            this.setDBAccess(access);
            access.runScript();
        }
        if ((cacheManager = ServiceContext.find(CacheManager.class)) == null) {
            cacheManager = new MemoryCacheManager();
        }
        List<CacheManagerAware> cacheServices = ServiceContext.findList(CacheManagerAware.class);
        for (CacheManagerAware cacheService : cacheServices) {
            cacheService.setCacheManager(cacheManager);
        }
        return this;
    }

    protected void setDBAccess(DBAccess access) {
        List<AccessService> services = ServiceContext.findList(AccessService.class);
        for (AccessService service : services) {
            service.setAccess(access);
        }
    }

    @Override
    public IProcessService process() {
        AssertHelper.notNull(this.processService);
        return this.processService;
    }

    @Override
    public IQueryService query() {
        AssertHelper.notNull(this.queryService);
        return this.queryService;
    }

    @Override
    public IOrderService order() {
        AssertHelper.notNull(this.orderService);
        return this.orderService;
    }

    @Override
    public ITaskService task() {
        AssertHelper.notNull(this.taskService);
        return this.taskService;
    }

    @Override
    public IManagerService manager() {
        AssertHelper.notNull(this.managerService);
        return this.managerService;
    }

    @Override
    public Order startInstanceById(String id) {
        return this.startInstanceById(id, null, null);
    }

    @Override
    public Order startInstanceById(String id, String operator) {
        return this.startInstanceById(id, operator, null);
    }

    @Override
    public Order startInstanceById(String id, String operator, Map<String, Object> args) {
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        Process process = this.process().getProcessById(id);
        this.process().check(process, id);
        return this.startProcess(process, operator, args);
    }

    @Override
    public Order startInstanceByName(String name) {
        return this.startInstanceByName(name, null, null, null);
    }

    @Override
    public Order startInstanceByName(String name, Integer version) {
        return this.startInstanceByName(name, version, null, null);
    }

    @Override
    public Order startInstanceByName(String name, Integer version, String operator) {
        return this.startInstanceByName(name, version, operator, null);
    }

    @Override
    public Order startInstanceByName(String name, Integer version, String operator, Map<String, Object> args) {
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        Process process = this.process().getProcessByVersion(name, version);
        this.process().check(process, name);
        return this.startProcess(process, operator, args);
    }

    private Order startProcess(Process process, String operator, Map<String, Object> args) {
        Execution execution = this.execute(process, operator, args, null, null);
        if (process.getModel() != null) {
            StartModel start = process.getModel().getStart();
            AssertHelper.notNull(start, "\u6d41\u7a0b\u5b9a\u4e49[name=" + process.getName() + ", version=" + process.getVersion() + "]\u6ca1\u6709\u5f00\u59cb\u8282\u70b9");
            start.execute(execution);
        }
        return execution.getOrder();
    }

    @Override
    public Order startInstanceByExecution(Execution execution) {
        Process process = execution.getProcess();
        StartModel start = process.getModel().getStart();
        AssertHelper.notNull(start, "\u6d41\u7a0b\u5b9a\u4e49[id=" + process.getId() + "]\u6ca1\u6709\u5f00\u59cb\u8282\u70b9");
        Execution current = this.execute(process, execution.getOperator(), execution.getArgs(), execution.getParentOrder().getId(), execution.getParentNodeName());
        start.execute(current);
        return current.getOrder();
    }

    private Execution execute(Process process, String operator, Map<String, Object> args, String parentId, String parentNodeName) {
        Order order = this.order().createOrder(process, operator, args, parentId, parentNodeName);
        if (log.isDebugEnabled()) {
            log.debug("\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61:" + order);
        }
        Execution current = new Execution(this, process, order, args);
        current.setOperator(operator);
        return current;
    }

    @Override
    public List<Task> executeTask(String taskId) throws SnakerException {
        return this.executeTask(taskId, null);
    }

    @Override
    public List<Task> executeTask(String taskId, String operator) throws SnakerException {
        return this.executeTask(taskId, operator, null);
    }

    @Override
    public List<Task> executeTask(String taskId, String operator, Map<String, Object> args) throws SnakerException {
        Execution execution = this.execute(taskId, operator, args);
        if (execution == null) {
            return Collections.emptyList();
        }
        ProcessModel model = execution.getProcess().getModel();
        if (model != null) {
            NodeModel nodeModel = model.getNode(execution.getTask().getTaskName());
            nodeModel.execute(execution);
        }
        return execution.getTasks();
    }

    @Override
    public List<Task> executeTask(String taskId, String operator, List<String> outputNames, Map<String, Object> args) throws SnakerException {
        ProcessModel model;
        Execution execution = this.execute(taskId, operator, args);
        if (execution == null) {
            return Collections.emptyList();
        }
        if (outputNames != null && outputNames.size() > 0) {
            execution.setOutputNames(outputNames);
        }
        if ((model = execution.getProcess().getModel()) != null) {
            NodeModel nodeModel = model.getNode(execution.getTask().getTaskName());
            nodeModel.execute(execution);
        }
        return execution.getTasks();
    }

    @Override
    public List<Task> executeTask(String taskId, String operator, List<String> outputNames, Map<String, Object> nextOperators, Map<String, Object> args) throws SnakerException {
        ProcessModel model;
        Execution execution = this.execute(taskId, operator, args);
        if (execution == null) {
            return Collections.emptyList();
        }
        if (outputNames != null && outputNames.size() > 0) {
            execution.setOutputNames(outputNames);
        }
        if (nextOperators != null && nextOperators.size() > 0) {
            execution.setNextOperaters(nextOperators);
        }
        if ((model = execution.getProcess().getModel()) != null) {
            NodeModel nodeModel = model.getNode(execution.getTask().getTaskName());
            nodeModel.execute(execution);
        }
        return execution.getTasks();
    }

    @Override
    public List<Task> executeAndJumpTask(String taskId, String operator, Map<String, Object> args, String nodeName) {
        Execution execution = this.execute(taskId, operator, args);
        if (execution == null) {
            return Collections.emptyList();
        }
        ProcessModel model = execution.getProcess().getModel();
        AssertHelper.notNull(model, "\u5f53\u524d\u4efb\u52a1\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578b");
        if (StringHelper.isEmpty(nodeName)) {
            Task newTask = this.task().rejectTask(model, execution.getTask());
            execution.addTask(newTask);
        } else {
            NodeModel nodeModel = model.getNode(nodeName);
            AssertHelper.notNull(nodeModel, "\u6839\u636e\u8282\u70b9\u540d\u79f0[" + nodeName + "]\u65e0\u6cd5\u627e\u5230\u8282\u70b9\u6a21\u578b");
            TransitionModel tm = new TransitionModel();
            tm.setTarget(nodeModel);
            tm.setEnabled(true);
            tm.execute(execution);
        }
        return execution.getTasks();
    }

    @Override
    public List<Task> executeAndJumpTask(String taskId, String operator, Map<String, Object> nextOperators, Map<String, Object> args, String nodeName) {
        Execution execution = this.execute(taskId, operator, args);
        if (execution == null) {
            return Collections.emptyList();
        }
        ProcessModel model = execution.getProcess().getModel();
        AssertHelper.notNull(model, "\u5f53\u524d\u4efb\u52a1\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49\u6a21\u578b");
        if (StringHelper.isEmpty(nodeName)) {
            Task newTask = this.task().rejectTask(model, execution.getTask());
            execution.addTask(newTask);
        } else {
            if (nextOperators != null && nextOperators.size() > 0) {
                execution.setNextOperaters(nextOperators);
            }
            NodeModel nodeModel = model.getNode(nodeName);
            AssertHelper.notNull(nodeModel, "\u6839\u636e\u8282\u70b9\u540d\u79f0[" + nodeName + "]\u65e0\u6cd5\u627e\u5230\u8282\u70b9\u6a21\u578b");
            TransitionModel tm = new TransitionModel();
            tm.setTarget(nodeModel);
            tm.setEnabled(true);
            tm.execute(execution);
        }
        return execution.getTasks();
    }

    @Override
    public List<Task> createFreeTask(String orderId, String operator, Map<String, Object> args, TaskModel model) {
        Order order = this.query().getOrder(orderId);
        AssertHelper.notNull(order, "\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8b[id=" + orderId + "]\u5df2\u5b8c\u6210\u6216\u4e0d\u5b58\u5728");
        order.setLastUpdator(operator);
        order.setLastUpdateTime(DateHelper.getTime());
        Process process = this.process().getProcessById(order.getProcessId());
        Execution execution = new Execution(this, process, order, args);
        execution.setOperator(operator);
        return this.task().createTask(model, execution);
    }

    private Execution execute(String taskId, String operator, Map<String, Object> args) throws SnakerException {
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        Task task = this.task().complete(taskId, operator, args);
        if (log.isDebugEnabled()) {
            log.debug("\u4efb\u52a1[taskId=" + taskId + "]\u5df2\u5b8c\u6210");
        }
        Order order = this.query().getOrder(task.getOrderId());
        AssertHelper.notNull(order, "\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8b[id=" + task.getOrderId() + "]\u5df2\u5b8c\u6210\u6216\u4e0d\u5b58\u5728");
        order.setLastUpdator(operator);
        order.setLastUpdateTime(DateHelper.getTime());
        this.order().updateOrder(order);
        if (!task.isMajor()) {
            return null;
        }
        Map<String, Object> orderMaps = order.getVariableMap();
        if (orderMaps != null) {
            for (Map.Entry<String, Object> entry : orderMaps.entrySet()) {
                if (args.containsKey(entry.getKey())) continue;
                args.put(entry.getKey(), entry.getValue());
            }
        }
        Process process = this.process().getProcessById(order.getProcessId());
        Execution execution = new Execution(this, process, order, args);
        execution.setOperator(operator);
        execution.setTask(task);
        return execution;
    }

    public void setProcessService(IProcessService processService) {
        this.processService = processService;
    }

    public void setOrderService(IOrderService orderService) {
        this.orderService = orderService;
    }

    public void setTaskService(ITaskService taskService) {
        this.taskService = taskService;
    }

    public void setQueryService(IQueryService queryService) {
        this.queryService = queryService;
    }

    public void setManagerService(IManagerService managerService) {
        this.managerService = managerService;
    }
}

