/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.Context;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.helper.AssertHelper;

public abstract class ServiceContext {
    private static final Logger log = LoggerFactory.getLogger(ServiceContext.class);
    private static Context context;
    private static SnakerEngine engine;

    public static Context getContext() {
        return context;
    }

    public static void setContext(Context context) {
        ServiceContext.context = context;
    }

    public static SnakerEngine getEngine() {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        if (engine == null) {
            engine = context.find(SnakerEngine.class);
        }
        return engine;
    }

    public static void put(String name, Object object) {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        if (log.isInfoEnabled()) {
            log.info("put new instance[name=" + name + "][object=" + object + "]");
        }
        context.put(name, object);
    }

    public static void put(String name, Class<?> clazz) {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        if (log.isInfoEnabled()) {
            log.info("put new instance[name=" + name + "][clazz=" + clazz.getName() + "]");
        }
        context.put(name, clazz);
    }

    public static boolean exist(String name) {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        return context.exist(name);
    }

    public static <T> T find(Class<T> clazz) {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        return context.find(clazz);
    }

    public static <T> List<T> findList(Class<T> clazz) {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        return context.findList(clazz);
    }

    public static <T> T findByName(String name, Class<T> clazz) {
        AssertHelper.notNull(context, "\u672a\u6ce8\u518c\u670d\u52a1\u4e0a\u4e0b\u6587");
        return context.findByName(name, clazz);
    }
}

