/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.IProcessService;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.Page;
import org.snaker.engine.access.QueryFilter;
import org.snaker.engine.cache.Cache;
import org.snaker.engine.cache.CacheManager;
import org.snaker.engine.cache.CacheManagerAware;
import org.snaker.engine.core.AccessService;
import org.snaker.engine.core.ServiceContext;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.Process;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.DateHelper;
import org.snaker.engine.helper.StreamHelper;
import org.snaker.engine.helper.StringHelper;
import org.snaker.engine.model.ProcessModel;
import org.snaker.engine.parser.ModelParser;

public class ProcessService
extends AccessService
implements IProcessService,
CacheManagerAware {
    private static final Logger log = LoggerFactory.getLogger(ProcessService.class);
    private static final String DEFAULT_SEPARATOR = ".";
    private static final String CACHE_ENTITY = "snaker.process.entity";
    private static final String CACHE_NAME = "snaker.process.name";
    private CacheManager cacheManager;
    private Cache<String, Process> entityCache;
    private Cache<String, String> nameCache;

    @Override
    public void check(Process process, String idOrName) throws IllegalArgumentException {
        AssertHelper.notNull(process, "\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9a\u4e49[id/name=" + idOrName + "]\u4e0d\u5b58\u5728");
        if (process.getState() != null && process.getState() == 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9a\u4e49[id/name=" + idOrName + ",version=" + process.getVersion() + "]\u4e3a\u975e\u6d3b\u52a8\u72b6\u6001");
        }
    }

    @Override
    public void saveProcess(Process process) {
        this.access().saveProcess(process);
    }

    @Override
    public void updateType(String id, String type) {
        Process entity = this.getProcessById(id);
        entity.setType(type);
        this.access().updateProcessType(id, type);
        this.cache(entity);
    }

    @Override
    public Process getProcessById(String id) {
        String processName;
        AssertHelper.notEmpty(id);
        Process entity = null;
        Cache<String, String> nameCache = this.ensureAvailableNameCache();
        Cache<String, Process> entityCache = this.ensureAvailableEntityCache();
        if (nameCache != null && entityCache != null && StringHelper.isNotEmpty(processName = nameCache.get(id))) {
            entity = entityCache.get(processName);
        }
        if (entity != null) {
            if (log.isDebugEnabled()) {
                log.debug("obtain process[id={}] from cache.", (Object)id);
            }
            return entity;
        }
        entity = this.access().getProcess(id);
        if (entity != null) {
            if (log.isDebugEnabled()) {
                log.debug("obtain process[id={}] from database.", (Object)id);
            }
            this.cache(entity);
        }
        return entity;
    }

    @Override
    public Process getProcessByName(String name) {
        return this.getProcessByVersion(name, null);
    }

    @Override
    public Process getProcessByVersion(String name, Integer version) {
        AssertHelper.notEmpty(name);
        if (version == null) {
            version = this.access().getLatestProcessVersion(name);
        }
        if (version == null) {
            version = 0;
        }
        Process entity = null;
        String processName = String.valueOf(name) + DEFAULT_SEPARATOR + version;
        Cache<String, Process> entityCache = this.ensureAvailableEntityCache();
        if (entityCache != null) {
            entity = entityCache.get(processName);
        }
        if (entity != null) {
            if (log.isDebugEnabled()) {
                log.debug("obtain process[name={}] from cache.", (Object)processName);
            }
            return entity;
        }
        List<Process> processs = this.access().getProcesss(null, new QueryFilter().setName(name).setVersion(version));
        if (processs != null && !processs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("obtain process[name={}] from database.", (Object)processName);
            }
            entity = processs.get(0);
            this.cache(entity);
        }
        return entity;
    }

    @Override
    public String deploy(InputStream input) {
        return this.deploy(input, null);
    }

    @Override
    public String deploy(InputStream input, String creator) {
        AssertHelper.notNull(input);
        try {
            byte[] bytes = StreamHelper.readBytes(input);
            ProcessModel model = ModelParser.parse(bytes);
            Integer version = this.access().getLatestProcessVersion(model.getName());
            Process entity = new Process();
            entity.setId(StringHelper.getPrimaryKey());
            if (version == null || version < 0) {
                entity.setVersion(0);
            } else {
                entity.setVersion(version + 1);
            }
            entity.setState(STATE_ACTIVE);
            entity.setModel(model);
            entity.setBytes(bytes);
            entity.setCreateTime(DateHelper.getTime());
            entity.setCreator(creator);
            this.saveProcess(entity);
            this.cache(entity);
            return entity.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw new SnakerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void redeploy(String id, InputStream input) {
        AssertHelper.notNull(input);
        Process entity = this.access().getProcess(id);
        AssertHelper.notNull(entity);
        try {
            Cache<String, Process> entityCache;
            byte[] bytes = StreamHelper.readBytes(input);
            ProcessModel model = ModelParser.parse(bytes);
            String oldProcessName = entity.getName();
            entity.setModel(model);
            entity.setBytes(bytes);
            this.access().updateProcess(entity);
            if (!oldProcessName.equalsIgnoreCase(entity.getName()) && (entityCache = this.ensureAvailableEntityCache()) != null) {
                entityCache.remove(String.valueOf(oldProcessName) + DEFAULT_SEPARATOR + entity.getVersion());
            }
            this.cache(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw new SnakerException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void undeploy(String id) {
        Process entity = this.access().getProcess(id);
        entity.setState(STATE_FINISH);
        this.access().updateProcess(entity);
        this.cache(entity);
    }

    @Override
    public void cascadeRemove(String id) {
        Process entity = this.access().getProcess(id);
        List<HistoryOrder> historyOrders = this.access().getHistoryOrders(null, new QueryFilter().setProcessId(id));
        for (HistoryOrder historyOrder : historyOrders) {
            ServiceContext.getEngine().order().cascadeRemove(historyOrder.getId());
        }
        this.access().deleteProcess(entity);
        this.clear(entity);
    }

    @Override
    public List<Process> getProcesss(QueryFilter filter) {
        if (filter == null) {
            filter = new QueryFilter();
        }
        return this.access().getProcesss(null, filter);
    }

    @Override
    public List<Process> getProcesss(Page<Process> page, QueryFilter filter) {
        AssertHelper.notNull(filter);
        return this.access().getProcesss(page, filter);
    }

    private void cache(Process entity) {
        Cache<String, String> nameCache = this.ensureAvailableNameCache();
        Cache<String, Process> entityCache = this.ensureAvailableEntityCache();
        if (entity.getModel() == null && entity.getDBContent() != null) {
            entity.setModel(ModelParser.parse(entity.getDBContent()));
        }
        String processName = String.valueOf(entity.getName()) + DEFAULT_SEPARATOR + entity.getVersion();
        if (nameCache != null && entityCache != null) {
            if (log.isDebugEnabled()) {
                log.debug("cache process id is[{}],name is[{}]", (Object)entity.getId(), (Object)processName);
            }
            entityCache.put(processName, entity);
            nameCache.put(entity.getId(), processName);
        } else if (log.isDebugEnabled()) {
            log.debug("no cache implementation class");
        }
    }

    private void clear(Process entity) {
        Cache<String, String> nameCache = this.ensureAvailableNameCache();
        Cache<String, Process> entityCache = this.ensureAvailableEntityCache();
        String processName = String.valueOf(entity.getName()) + DEFAULT_SEPARATOR + entity.getVersion();
        if (nameCache != null && entityCache != null) {
            nameCache.remove(entity.getId());
            entityCache.remove(processName);
        }
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    private Cache<String, Process> ensureAvailableEntityCache() {
        Cache<String, Process> entityCache = this.ensureEntityCache();
        if (entityCache == null && this.cacheManager != null) {
            entityCache = this.cacheManager.getCache(CACHE_ENTITY);
        }
        return entityCache;
    }

    private Cache<String, String> ensureAvailableNameCache() {
        Cache<String, String> nameCache = this.ensureNameCache();
        if (nameCache == null && this.cacheManager != null) {
            nameCache = this.cacheManager.getCache(CACHE_NAME);
        }
        return nameCache;
    }

    public Cache<String, Process> ensureEntityCache() {
        return this.entityCache;
    }

    public void setEntityCache(Cache<String, Process> entityCache) {
        this.entityCache = entityCache;
    }

    public Cache<String, String> ensureNameCache() {
        return this.nameCache;
    }

    public void setNameCache(Cache<String, String> nameCache) {
        this.nameCache = nameCache;
    }
}

