/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.snaker.engine.SnakerEngine;
import org.snaker.engine.SnakerException;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Task;
import org.snaker.engine.model.ProcessModel;

public class Execution
implements Serializable {
    private static final long serialVersionUID = 3730741790729624400L;
    private SnakerEngine engine;
    private Process process;
    private Order order;
    private Order parentOrder;
    private String parentNodeName;
    private String childOrderId;
    private Map<String, Object> args;
    private String operator;
    private Task task;
    private List<Task> tasks = new ArrayList<Task>();
    private boolean isMerged = false;
    private List<String> outputNames;
    private Map<String, Object> nextOperaters;

    Execution(Execution execution, Process process, String parentNodeName) {
        if (execution == null || process == null || parentNodeName == null) {
            throw new SnakerException("\u6784\u9020Execution\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5execution\u3001process\u3001parentNodeName\u662f\u5426\u4e3a\u7a7a");
        }
        this.engine = execution.getEngine();
        this.process = process;
        this.args = execution.getArgs();
        this.parentOrder = execution.getOrder();
        this.parentNodeName = parentNodeName;
        this.operator = execution.getOperator();
    }

    public Execution(SnakerEngine engine, Process process, Order order, Map<String, Object> args) {
        if (process == null || order == null) {
            throw new SnakerException("\u6784\u9020Execution\u5bf9\u8c61\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5process\u3001order\u662f\u5426\u4e3a\u7a7a");
        }
        this.engine = engine;
        this.process = process;
        this.order = order;
        this.args = args;
    }

    public Execution createSubExecution(Execution execution, Process process, String parentNodeName) {
        return new Execution(execution, process, parentNodeName);
    }

    public Process getProcess() {
        return this.process;
    }

    public ProcessModel getModel() {
        return this.process.getModel();
    }

    public Order getOrder() {
        return this.order;
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void addTasks(List<Task> tasks) {
        this.tasks.addAll(tasks);
    }

    public void addTask(Task task) {
        this.tasks.add(task);
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public boolean isMerged() {
        return this.isMerged;
    }

    public void setMerged(boolean isMerged) {
        this.isMerged = isMerged;
    }

    public SnakerEngine getEngine() {
        return this.engine;
    }

    public Order getParentOrder() {
        return this.parentOrder;
    }

    public String getParentNodeName() {
        return this.parentNodeName;
    }

    public String getChildOrderId() {
        return this.childOrderId;
    }

    public void setChildOrderId(String childOrderId) {
        this.childOrderId = childOrderId;
    }

    public List<String> getOutputNames() {
        return this.outputNames;
    }

    public void setOutputNames(List<String> outputNames) {
        this.outputNames = outputNames;
    }

    public Map<String, Object> getNextOperaters() {
        return this.nextOperaters;
    }

    public void setNextOperaters(Map<String, Object> nextOperaters) {
        this.nextOperaters = nextOperaters;
    }
}

