/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.cache.memory;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.snaker.engine.cache.Cache;
import org.snaker.engine.cache.CacheException;
import org.snaker.engine.cache.CacheManager;
import org.snaker.engine.cache.memory.MemoryCache;
import org.snaker.engine.helper.StringHelper;

public class MemoryCacheManager
implements CacheManager {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();

    @Override
    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        Cache existing;
        if (StringHelper.isEmpty(name)) {
            throw new IllegalArgumentException("Cache\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a.");
        }
        Cache cache = (MemoryCache)this.caches.get(name);
        if (cache == null && (existing = (Cache)this.caches.putIfAbsent(name, cache = new MemoryCache(new ConcurrentHashMap()))) != null) {
            cache = existing;
        }
        return cache;
    }

    @Override
    public void destroy() throws CacheException {
        while (!this.caches.isEmpty()) {
            this.caches.clear();
        }
    }
}

