/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.transaction;

import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.transaction.JtaTransactionHelper;
import org.snaker.engine.access.transaction.TransactionInterceptor;
import org.snaker.engine.access.transaction.TransactionStatus;

public class JtaTransactionInterceptor
extends TransactionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JtaTransactionInterceptor.class);

    @Override
    public void initialize(Object accessObject) {
    }

    @Override
    protected TransactionStatus getTransaction() {
        UserTransaction userTransaction = JtaTransactionHelper.lookupJeeUserTransaction();
        int status = JtaTransactionHelper.getUserTransactionStatus(userTransaction);
        if (log.isInfoEnabled()) {
            log.info("begin transaction=" + status);
        }
        if (status == 0) {
            return new TransactionStatus(null, false);
        }
        if (status != 6 && status != 3 && status != 4) {
            throw new SnakerException("\u65e0\u6548\u7684\u4e8b\u52a1\u72b6\u6001:" + status);
        }
        Transaction suspendedTransaction = null;
        if (status == 0 || status == 3 || status == 4) {
            suspendedTransaction = JtaTransactionHelper.suspend();
        }
        try {
            JtaTransactionHelper.begin();
            TransactionStatus transactionStatus = new TransactionStatus(null, true);
            return transactionStatus;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (suspendedTransaction != null) {
                JtaTransactionHelper.resume(suspendedTransaction);
            }
        }
    }

    @Override
    protected void commit(TransactionStatus status) {
        if (log.isInfoEnabled()) {
            log.info("commit transaction=");
        }
        JtaTransactionHelper.commit();
    }

    @Override
    protected void rollback(TransactionStatus status) {
        UserTransaction userTransaction = JtaTransactionHelper.lookupJeeUserTransaction();
        int txStatus = JtaTransactionHelper.getUserTransactionStatus(userTransaction);
        if (log.isInfoEnabled()) {
            log.info("rollback transaction=" + txStatus);
        }
        if (txStatus != 6 && txStatus != 3 && txStatus != 4) {
            JtaTransactionHelper.rollback();
        }
    }
}

