/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.jdbc.JdbcHelper;
import org.snaker.engine.access.transaction.TransactionInterceptor;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.access.transaction.TransactionStatus;
import org.snaker.engine.helper.AssertHelper;

public class DataSourceTransactionInterceptor
extends TransactionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DataSourceTransactionInterceptor.class);
    private DataSource dataSource;

    @Override
    public void initialize(Object accessObject) {
        if (accessObject == null) {
            return;
        }
        if (accessObject instanceof DataSource) {
            this.dataSource = (DataSource)accessObject;
        }
    }

    @Override
    protected TransactionStatus getTransaction() {
        try {
            boolean isExistingTransaction = TransactionObjectHolder.isExistingTransaction();
            if (isExistingTransaction) {
                return new TransactionStatus(TransactionObjectHolder.get(), false);
            }
            Connection conn = JdbcHelper.getConnection(this.dataSource);
            conn.setAutoCommit(false);
            if (log.isInfoEnabled()) {
                log.info("begin transaction=" + conn.hashCode());
            }
            TransactionObjectHolder.bind(conn);
            return new TransactionStatus(conn, true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void commit(TransactionStatus status) {
        AssertHelper.isTrue(status.isNewTransaction());
        Connection conn = (Connection)status.getTransaction();
        if (conn != null) {
            try {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("commit transaction=" + conn.hashCode());
                    }
                    conn.commit();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            finally {
                try {
                    JdbcHelper.close(conn);
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
                TransactionObjectHolder.unbind();
            }
        }
    }

    @Override
    protected void rollback(TransactionStatus status) {
        Connection conn = (Connection)status.getTransaction();
        if (conn != null) {
            try {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("rollback transaction=" + conn.hashCode());
                    }
                    if (!conn.isClosed()) {
                        conn.rollback();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e.getCause());
                }
            }
            finally {
                try {
                    JdbcHelper.close(conn);
                }
                catch (SQLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
                TransactionObjectHolder.unbind();
            }
        }
    }
}

