/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.hibernate4;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.Session;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.Work;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.snaker.engine.DBAccess;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.ScriptRunner;
import org.snaker.engine.access.hibernate.HibernateAccess;
import org.snaker.engine.access.jdbc.JdbcHelper;

public class Hibernate4Access
extends HibernateAccess
implements DBAccess {
    @Override
    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    protected Connection getConnection() throws SQLException {
        SessionFactoryImpl sessionFactoryImpl;
        ConnectionProvider provider;
        if (this.sessionFactory instanceof SessionFactoryImpl && (provider = (ConnectionProvider)(sessionFactoryImpl = (SessionFactoryImpl)this.sessionFactory).getServiceRegistry().getService(ConnectionProvider.class)) != null) {
            return provider.getConnection();
        }
        return null;
    }

    @Override
    public Blob createBlob(byte[] bytes) {
        return this.getSession().getLobHelper().createBlob(bytes);
    }

    @Override
    public void runScript() {
        this.getSession().doWork(new Work(){

            public void execute(Connection conn) throws SQLException {
                if (JdbcHelper.isExec(conn)) {
                    return;
                }
                try {
                    String databaseType = JdbcHelper.getDatabaseType(conn);
                    String schema = "db/core/schema-" + databaseType + ".sql";
                    ScriptRunner runner = new ScriptRunner(conn, true);
                    runner.runScript(schema);
                }
                catch (Exception e) {
                    throw new SnakerException(e);
                }
            }
        });
    }
}

