/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.hibernate;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.hibernate.HibernateHelper;
import org.snaker.engine.access.transaction.TransactionInterceptor;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.access.transaction.TransactionStatus;
import org.snaker.engine.helper.AssertHelper;

public class HibernateTransactionInterceptor
extends TransactionInterceptor {
    private static final Logger log = LoggerFactory.getLogger(HibernateTransactionInterceptor.class);
    private SessionFactory sessionFactory;

    @Override
    public void initialize(Object accessObject) {
        if (accessObject == null) {
            return;
        }
        if (accessObject instanceof SessionFactory) {
            this.sessionFactory = (SessionFactory)accessObject;
        }
    }

    @Override
    protected TransactionStatus getTransaction() {
        try {
            boolean isExistingTransaction = TransactionObjectHolder.isExistingTransaction();
            if (isExistingTransaction) {
                return new TransactionStatus(TransactionObjectHolder.get(), false);
            }
            Session session = HibernateHelper.getSession(this.sessionFactory);
            session.getTransaction().begin();
            if (log.isInfoEnabled()) {
                log.info("begin transaction=" + session.hashCode());
            }
            TransactionObjectHolder.bind(session);
            return new TransactionStatus(session, true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    protected void commit(TransactionStatus status) {
        AssertHelper.isTrue(status.isNewTransaction());
        Session session = (Session)status.getTransaction();
        if (session != null) {
            try {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("commit transaction=" + session.hashCode());
                    }
                    session.getTransaction().commit();
                    session.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            finally {
                TransactionObjectHolder.unbind();
            }
        }
    }

    @Override
    protected void rollback(TransactionStatus status) {
        Session session = (Session)status.getTransaction();
        if (session != null) {
            try {
                try {
                    if (log.isInfoEnabled()) {
                        log.info("rollback transaction=" + session.hashCode());
                    }
                    if (session.isOpen()) {
                        session.getTransaction().rollback();
                        session.close();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            finally {
                TransactionObjectHolder.unbind();
            }
        }
    }
}

