/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.hibernate;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.helper.AssertHelper;
import org.snaker.engine.helper.ConfigHelper;
import org.snaker.engine.helper.StringHelper;

public abstract class HibernateHelper {
    private static final Logger log = LoggerFactory.getLogger(HibernateHelper.class);
    private static SessionFactory sessionFactory;

    private static void initialize() {
        String driver = ConfigHelper.getProperty("jdbc.driver");
        String url = ConfigHelper.getProperty("jdbc.url");
        String username = ConfigHelper.getProperty("jdbc.username");
        String password = ConfigHelper.getProperty("jdbc.password");
        String dialect = ConfigHelper.getProperty("hibernate.dialect");
        AssertHelper.notNull(driver);
        AssertHelper.notNull(url);
        AssertHelper.notNull(username);
        AssertHelper.notNull(password);
        AssertHelper.notNull(dialect);
        String formatSql = ConfigHelper.getProperty("hibernate.format_sql");
        String showSql = ConfigHelper.getProperty("hibernate.show_sql");
        Configuration configuration = new Configuration();
        if (StringHelper.isNotEmpty(driver)) {
            configuration.setProperty("hibernate.connection.driver_class", driver);
        }
        if (StringHelper.isNotEmpty(url)) {
            configuration.setProperty("hibernate.connection.url", url);
        }
        if (StringHelper.isNotEmpty(username)) {
            configuration.setProperty("hibernate.connection.username", username);
        }
        if (StringHelper.isNotEmpty(password)) {
            configuration.setProperty("hibernate.connection.password", password);
        }
        if (StringHelper.isNotEmpty(dialect)) {
            configuration.setProperty("hibernate.dialect", dialect);
        }
        if (StringHelper.isNotEmpty(formatSql)) {
            configuration.setProperty("hibernate.format_sql", formatSql);
        }
        if (StringHelper.isNotEmpty(showSql)) {
            configuration.setProperty("hibernate.show_sql", showSql);
        }
        sessionFactory = configuration.configure().buildSessionFactory();
    }

    public static Session getSession(SessionFactory sf) {
        Session session = (Session)TransactionObjectHolder.get();
        if (session == null) {
            if (sf != null) {
                return sf.getCurrentSession();
            }
            if (log.isDebugEnabled()) {
                log.debug("could not found sessionFactory.");
            }
            return HibernateHelper.getSessionFactory().openSession();
        }
        if (log.isDebugEnabled()) {
            log.debug("found thread-bound session=" + session.hashCode());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionFactory getSessionFactory() {
        if (sessionFactory != null) return sessionFactory;
        Class<HibernateHelper> clazz = HibernateHelper.class;
        synchronized (HibernateHelper.class) {
            HibernateHelper.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sessionFactory;
        }
    }
}

