/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.hibernate;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.DBAccess;
import org.snaker.engine.SnakerException;
import org.snaker.engine.access.AbstractDBAccess;
import org.snaker.engine.access.hibernate.HibernateHelper;
import org.snaker.engine.entity.CCOrder;
import org.snaker.engine.entity.HistoryOrder;
import org.snaker.engine.entity.HistoryTask;
import org.snaker.engine.entity.HistoryTaskActor;
import org.snaker.engine.entity.Order;
import org.snaker.engine.entity.Process;
import org.snaker.engine.entity.Surrogate;
import org.snaker.engine.entity.Task;
import org.snaker.engine.entity.TaskActor;
import org.snaker.engine.helper.ClassHelper;
import org.snaker.engine.helper.DateHelper;

public abstract class HibernateAccess
extends AbstractDBAccess
implements DBAccess {
    private static final Logger log = LoggerFactory.getLogger(HibernateAccess.class);
    protected SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void initialize(Object accessObject) {
        if (accessObject == null) {
            return;
        }
        if (accessObject instanceof SessionFactory) {
            this.sessionFactory = (SessionFactory)accessObject;
        }
    }

    public Session getSession() {
        return HibernateHelper.getSession(this.sessionFactory);
    }

    @Override
    protected Connection getConnection() throws SQLException {
        return null;
    }

    @Override
    public void updateProcess(Process process) {
        try {
            if (process.getBytes() != null) {
                Blob blob = this.createBlob(process.getBytes());
                process.setContent(blob);
            }
        }
        catch (Exception e) {
            throw new SnakerException(e.getMessage(), e.getCause());
        }
        this.getSession().saveOrUpdate((Object)process);
    }

    @Override
    public void saveProcess(Process process) {
        try {
            if (process.getBytes() != null) {
                Blob blob = this.createBlob(process.getBytes());
                process.setContent(blob);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SnakerException(e.getMessage(), e.getCause());
        }
        this.getSession().saveOrUpdate((Object)process);
    }

    @Override
    public void deleteProcess(Process process) {
        this.getSession().delete((Object)process);
    }

    @Override
    public void deleteTask(Task task) {
        List<TaskActor> actors = this.getTaskActorsByTaskId(task.getId());
        for (TaskActor actor : actors) {
            this.getSession().delete((Object)actor);
        }
        this.getSession().delete((Object)task);
    }

    @Override
    public void deleteOrder(Order order) {
        this.getSession().delete((Object)order);
    }

    @Override
    public void deleteHistoryOrder(HistoryOrder historyOrder) {
        this.getSession().delete((Object)historyOrder);
    }

    @Override
    public void deleteHistoryTask(HistoryTask historyTask) {
        List<HistoryTaskActor> actors = this.getHistTaskActorsByTaskId(historyTask.getId());
        for (HistoryTaskActor actor : actors) {
            this.getSession().delete((Object)actor);
        }
        this.getSession().delete((Object)historyTask);
    }

    @Override
    public void deleteSurrogate(Surrogate surrogate) {
        this.getSession().delete((Object)surrogate);
    }

    @Override
    public void deleteCCOrder(CCOrder ccorder) {
        this.getSession().delete((Object)ccorder);
    }

    @Override
    public void removeTaskActor(String taskId, String ... actors) {
        String[] stringArray = actors;
        int n = actors.length;
        int n2 = 0;
        while (n2 < n) {
            String actorId = stringArray[n2];
            TaskActor ta = new TaskActor();
            ta.setTaskId(taskId);
            ta.setActorId(actorId);
            this.getSession().delete((Object)ta);
            ++n2;
        }
    }

    @Override
    public void updateTaskActor(String taskId, String actor) {
        TaskActor ta = new TaskActor();
        ta.setTaskId(taskId);
        Session session = this.getSession();
        SQLQuery query = session.createSQLQuery("delete from t_wf_task_actor where task_Id = ?");
        query.setParameter(0, (Object)taskId);
        query.executeUpdate();
        ta.setTaskId(taskId);
        ta.setActorId(actor);
        session.save((Object)ta);
        Task task = this.getTask(taskId);
        task.setTakeTime(DateHelper.getTime());
        session.update((Object)task);
    }

    @Override
    public boolean isORM() {
        return true;
    }

    @Override
    public void saveOrUpdate(Map<String, Object> map) {
        this.getSession().saveOrUpdate(map.get("ENTITY"));
    }

    @Override
    public Integer getLatestProcessVersion(String name) {
        SQLQuery query = this.getSession().createSQLQuery("select max(version) from t_wf_process  where name = ?");
        query.setParameter(0, (Object)name);
        Object result = query.uniqueResult();
        return new Long(ClassHelper.castLong(result)).intValue();
    }

    @Override
    public <T> T queryObject(Class<T> T, String sql, Object ... args) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.addEntity(T);
        int i = 0;
        while (i < args.length) {
            query.setParameter(i, args[i]);
            ++i;
        }
        return (T)query.uniqueResult();
    }

    @Override
    public <T> List<T> queryList(Class<T> clazz, String sql, Object ... args) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        query.addEntity(clazz);
        int i = 0;
        while (i < args.length) {
            query.setParameter(i, args[i]);
            ++i;
        }
        return query.list();
    }

    @Override
    public Object queryCount(String sql, Object ... args) {
        SQLQuery countQuery = this.getSession().createSQLQuery(sql);
        if (args.length > 0) {
            int i = 0;
            while (i < args.length) {
                countQuery.setParameter(i, args[i]);
                ++i;
            }
        }
        return countQuery.uniqueResult();
    }

    public abstract Blob createBlob(byte[] var1);
}

