/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.event.demo.mic;

import org.comet4j.event.Event;
import org.comet4j.event.Listener;
import org.comet4j.event.Observable;

public class Test {
    public static void main(String[] args) {
        new Test().run();
    }

    public void run() {
        Person person = new Person();
        person.addListener(SpeakEvent.class, new SpeakListener(this){

            @Override
            public boolean handleEvent(SpeakEvent anEvent) {
                System.out.println("One person want to say:" + anEvent.words);
                return true;
            }
        });
        person.addListener(GoEvent.class, new GoListener(this){

            @Override
            public boolean handleEvent(GoEvent anEvent) {
                System.out.println("One person want to go:" + anEvent.where);
                return true;
            }
        });
        person.say("Hello world!");
        person.go("Home!");
    }

    public class GoEvent
    extends Event<Person> {
        public String where;

        public GoEvent(Person target, String where) {
            super(target);
            this.where = "";
            this.where = where;
        }
    }

    public abstract class GoListener
    extends Listener<GoEvent> {
    }

    public class Person
    extends Observable {
        public Person() {
            this.addEvent(SpeakEvent.class);
            this.addEvent(GoEvent.class);
        }

        public void say(String aWords) {
            SpeakEvent e = new SpeakEvent(this, aWords);
            if (!this.fireEvent(e)) {
                return;
            }
            System.out.println("say:" + aWords);
        }

        public void go(String anPlace) {
            GoEvent e = new GoEvent(this, anPlace);
            if (!this.fireEvent(e)) {
                return;
            }
            System.out.println("go:" + anPlace);
        }
    }

    public class SpeakEvent
    extends Event<Person> {
        public String words;

        public SpeakEvent(Person target, String aWords) {
            super(target);
            this.words = "";
            this.words = aWords;
        }
    }

    public abstract class SpeakListener
    extends Listener<SpeakEvent> {
    }
}

