/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.event.demo.mac;

import org.comet4j.event.Event;
import org.comet4j.event.Listener;
import org.comet4j.event.Observable;
import org.comet4j.event.demo.mac.PersonEventSubType;
import org.comet4j.event.demo.mac.SubEventType;

public class Test {
    public static void main(String[] args) {
        new Test().run();
    }

    public void run() {
        Person person = new Person();
        person.addListener(PersonEvent.class, new PersonListener1());
        person.addListener(PersonEvent.class, new PersonListener(this){

            @Override
            public boolean onBeforeSay(PersonEvent pe) {
                System.out.println("2:One person want to say:" + pe.sayWords);
                return true;
            }

            @Override
            public boolean onBeforeGo(PersonEvent pe) {
                pe.stopEvent();
                System.out.println("2:One person want to go:" + pe.goWhere);
                return true;
            }
        });
        person.say("Hello world!");
        person.go("Home");
    }

    public class Person
    extends Observable<PersonEvent, PersonListener> {
        public Person() {
            this.addEvent(PersonEvent.class);
        }

        public void say(String aWords) {
            PersonEvent e = new PersonEvent(this, PersonEventSubType.BEFORESAY);
            e.sayWords = aWords;
            if (!this.fireEvent(e)) {
                return;
            }
            System.out.println("say:" + aWords);
        }

        public void go(String where) {
            PersonEvent e = new PersonEvent(this, PersonEventSubType.BEFOREGO);
            e.goWhere = where;
            if (!this.fireEvent(e)) {
                return;
            }
            System.out.println("go:" + where);
        }
    }

    public class PersonEvent
    extends Event<Person> {
        private SubEventType subType;
        public String sayWords;
        public String goWhere;

        public PersonEvent(Person target) {
            super(target);
            this.sayWords = "";
            this.goWhere = "";
        }

        public PersonEvent(Person target, SubEventType subtype) {
            super(target);
            this.sayWords = "";
            this.goWhere = "";
            this.subType = subtype;
        }

        public SubEventType getSubType() {
            return this.subType;
        }
    }

    public abstract class PersonListener
    extends Listener<PersonEvent> {
        @Override
        public boolean handleEvent(PersonEvent pe) {
            if (PersonEventSubType.BEFORESAY == pe.getSubType()) {
                return this.onBeforeSay(pe);
            }
            if (PersonEventSubType.BEFOREGO == pe.getSubType()) {
                return this.onBeforeGo(pe);
            }
            return true;
        }

        public abstract boolean onBeforeSay(PersonEvent var1);

        public abstract boolean onBeforeGo(PersonEvent var1);
    }

    public class PersonListener1
    extends PersonListener {
        @Override
        public boolean onBeforeSay(PersonEvent pe) {
            System.out.println("1:One person want to say:" + pe.sayWords);
            return true;
        }

        @Override
        public boolean onBeforeGo(PersonEvent pe) {
            System.out.println("1:One person want to go:" + pe.goWhere);
            return true;
        }
    }
}

