/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.comet4j.event.Event;
import org.comet4j.event.EventSource;
import org.comet4j.event.InterceptorInterface;
import org.comet4j.event.ListenerInterface;

public class Observable<E extends Event, L extends ListenerInterface<E>> {
    private Map<Class<E>, EventSource<E, L>> eventSources = new HashMap<Class<E>, EventSource<E, L>>();
    private List<InterceptorInterface<E>> interceptors = new ArrayList<InterceptorInterface<E>>(0);
    private boolean suspend = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventInterceptor(InterceptorInterface anInterceptor) {
        List<InterceptorInterface<E>> list = this.interceptors;
        synchronized (list) {
            this.interceptors.add(anInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventInterceptor(L anInterceptor) {
        List<InterceptorInterface<E>> list = this.interceptors;
        synchronized (list) {
            this.interceptors.remove(anInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllEventInterceptor() {
        List<InterceptorInterface<E>> list = this.interceptors;
        synchronized (list) {
            this.interceptors.clear();
        }
    }

    public boolean eventIntercept(E anEvent) {
        return true;
    }

    public void suspendEvents() {
        this.suspend = true;
    }

    public void resumeEvents() {
        this.suspend = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fireEvent(E anEvent) {
        if (!this.eventIntercept(anEvent)) {
            return false;
        }
        if (this.interceptors.size() > 0) {
            int i = this.interceptors.size() - 1;
            while (i >= 0) {
                InterceptorInterface<E> interceptor = this.interceptors.get(i);
                if (!interceptor.intercept(anEvent)) {
                    return false;
                }
                --i;
            }
        }
        if (!this.suspend) {
            EventSource<E, L> es = null;
            Map<Class<E>, EventSource<E, L>> map = this.eventSources;
            synchronized (map) {
                es = this.eventSources.get(anEvent.getClass());
            }
            if (es != null) {
                return es.fire(anEvent);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(Class<E> clazz) {
        EventSource<E, L> es = this.eventSources.get(clazz);
        if (es == null) {
            Map<Class<E>, EventSource<E, L>> map = this.eventSources;
            synchronized (map) {
                this.eventSources.put(clazz, new EventSource());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEvent(Class<E> clazz) {
        Map<Class<E>, EventSource<E, L>> map = this.eventSources;
        synchronized (map) {
            EventSource<E, L> es = this.eventSources.get(clazz);
            if (es != null) {
                es.removeAllListeners();
            }
            this.eventSources.remove(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllEvent() {
        Map<Class<E>, EventSource<E, L>> map = this.eventSources;
        synchronized (map) {
            for (Class<E> esn : this.eventSources.keySet()) {
                EventSource<E, L> es = this.eventSources.get(esn);
                if (es == null) continue;
                es.removeAllListeners();
            }
            this.eventSources.clear();
        }
    }

    public void addListener(Class<E> clazz, L aListener) {
        EventSource<E, L> es = this.eventSources.get(clazz);
        if (es != null) {
            es.addListener(aListener);
        }
    }

    public void removeListener(Class<E> clazz, L aListener) {
        EventSource<E, L> es = this.eventSources.get(clazz);
        if (es != null) {
            es.removeListener(aListener);
        }
    }

    public void removeListener(Class<E> clazz) {
        EventSource<E, L> es = this.eventSources.get(clazz);
        if (es != null) {
            es.removeAllListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListener() {
        Map<Class<E>, EventSource<E, L>> map = this.eventSources;
        synchronized (map) {
            for (Class<E> esn : this.eventSources.keySet()) {
                EventSource<E, L> es = this.eventSources.get(esn);
                if (es == null) continue;
                es.removeAllListeners();
            }
        }
    }

    public List<L> getListeners(Class<E> clazz) {
        EventSource<E, L> es = this.eventSources.get(clazz);
        if (es != null) {
            return es.getListeners();
        }
        return new ArrayList(0);
    }

    public EventSource<E, L> getEventSource(Class<E> clazz) {
        return this.eventSources.get(clazz);
    }

    public List<EventSource<E, L>> getAllEventSource() {
        ArrayList<EventSource<EventSource<E, L>, L>> result = new ArrayList<EventSource<EventSource<E, L>, L>>();
        for (Class<E> esn : this.eventSources.keySet()) {
            EventSource<E, L> es = this.eventSources.get(esn);
            result.add(es);
        }
        return result;
    }

    public void destroy() {
        this.removeAllEvent();
        this.eventSources = null;
        this.interceptors.clear();
        this.interceptors = null;
    }
}

