/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.event;

import java.util.ArrayList;
import java.util.List;
import org.comet4j.event.Event;
import org.comet4j.event.ListenerInterface;

public class EventSource<E extends Event, L extends ListenerInterface<E>> {
    protected List<L> listeners = new ArrayList<L>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean fire(E anEvent) {
        List<L> list = this.listeners;
        synchronized (list) {
            int i = this.listeners.size() - 1;
            while (i >= 0) {
                ListenerInterface listener = (ListenerInterface)this.listeners.get(i);
                if (((Event)anEvent).hasStoped()) {
                    return false;
                }
                if (((Event)anEvent).hasPreventDefault()) break;
                if (!listener.handleEvent(anEvent)) {
                    return false;
                }
                --i;
            }
        }
        if (!((Event)anEvent).hasStoped()) return true;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(L aListener) {
        List<L> list = this.listeners;
        synchronized (list) {
            this.listeners.add(aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(L aListener) {
        List<L> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(aListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        List<L> list = this.listeners;
        synchronized (list) {
            this.listeners.clear();
        }
    }

    public L getListener(L aListener) {
        for (ListenerInterface l : this.listeners) {
            if (l != aListener) continue;
            return (L)l;
        }
        return null;
    }

    public List<L> getListeners() {
        return this.listeners;
    }

    public void destroy() {
        this.removeAllListeners();
        this.listeners = null;
    }
}

