/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DelayTask {
    private final int cpuCoreNumber = Runtime.getRuntime().availableProcessors();
    private final ScheduledExecutorService scheduler;
    private final Map<String, ScheduledFuture<Runnable>> taskHandles = new ConcurrentHashMap<String, ScheduledFuture<Runnable>>();

    public DelayTask() {
        this.scheduler = Executors.newScheduledThreadPool(this.cpuCoreNumber);
    }

    public DelayTask(int cpuCoreNumber) {
        this.scheduler = Executors.newScheduledThreadPool(cpuCoreNumber);
    }

    public void delay(String taskId, Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<Runnable> taskHandle = this.taskHandles.get(taskId);
        if (taskHandle == null || taskHandle.isDone()) {
            taskHandle = this.scheduler.schedule(task, delay, unit);
        } else {
            taskHandle.cancel(true);
            taskHandle = this.scheduler.schedule(task, delay, unit);
        }
        this.taskHandles.put(taskId, taskHandle);
    }

    public void cancel(String taskId) {
        ScheduledFuture<Runnable> taskHandle = this.taskHandles.get(taskId);
        if (taskHandle != null && !taskHandle.isDone()) {
            taskHandle.cancel(true);
        }
    }

    public void cancelAllTask() {
        for (String taskId : this.taskHandles.keySet()) {
            ScheduledFuture<Runnable> taskHandle = this.taskHandles.get(taskId);
            if (taskHandle == null || taskHandle.isDone()) continue;
            taskHandle.cancel(true);
        }
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }
}

