/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CharacterEncodingFilter
implements Filter {
    protected String encoding = null;
    protected FilterConfig filterConfig = null;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpreq = (HttpServletRequest)request;
        if (httpreq.getMethod().equals("POST")) {
            request.setCharacterEncoding(this.encoding);
        } else {
            request = new Request(httpreq);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
    }

    class Request
    extends HttpServletRequestWrapper {
        public Request(HttpServletRequest request) {
            super(request);
        }

        public String toChi(String input) {
            try {
                byte[] bytes = input.getBytes("ISO-8859-1");
                return new String(bytes, CharacterEncodingFilter.this.encoding);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private HttpServletRequest getHttpServletRequest() {
            return (HttpServletRequest)super.getRequest();
        }

        public String getParameter(String name) {
            return this.toChi(this.getHttpServletRequest().getParameter(name));
        }

        public String[] getParameterValues(String name) {
            String[] values = this.getHttpServletRequest().getParameterValues(name);
            if (values != null) {
                int i = 0;
                while (i < values.length) {
                    values[i] = this.toChi(values[i]);
                    ++i;
                }
            }
            return values;
        }
    }
}

