/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core.temp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;

public class StreamingXHRServlet
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = 1L;
    protected ArrayList<HttpServletResponse> connections = new ArrayList();
    protected MessageSender messageSender = null;
    protected Boolean debug = false;

    public void init() throws ServletException {
        this.messageSender = new MessageSender();
        Thread messageSenderThread = new Thread((Runnable)this.messageSender, "MessageSender[" + this.getServletContext().getContextPath() + "]");
        messageSenderThread.setDaemon(true);
        messageSenderThread.start();
        Thread timeSenderThread = new Thread(new TimeSender());
        timeSenderThread.setDaemon(true);
        timeSenderThread.start();
    }

    public void destroy() {
        this.connections.clear();
        this.messageSender.stop();
        this.messageSender = null;
        this.debug = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            this.log("-->begin");
            ArrayList<HttpServletResponse> arrayList = this.connections;
            synchronized (arrayList) {
                this.connections.add(response);
            }
            event.setTimeout(6000);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.log("-->error");
            ArrayList<HttpServletResponse> arrayList = this.connections;
            synchronized (arrayList) {
                this.connections.remove(response);
            }
            if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                response.setStatus(408);
            }
            response.getWriter().close();
            event.close();
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.log("-->end");
            ArrayList<HttpServletResponse> arrayList = this.connections;
            synchronized (arrayList) {
                this.connections.remove(response);
            }
            response.getWriter().close();
            event.close();
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.log("-->read");
        }
    }

    public class MessageSender
    implements Runnable {
        protected boolean running = true;
        protected ArrayList<String> messages = new ArrayList();

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(String user, String message) {
            ArrayList<String> arrayList = this.messages;
            synchronized (arrayList) {
                this.messages.add("[" + user + "]: " + message);
                this.messages.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                ArrayList<String> arrayList;
                if (this.messages.size() == 0) {
                    try {
                        arrayList = this.messages;
                        synchronized (arrayList) {
                            this.messages.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                arrayList = StreamingXHRServlet.this.connections;
                synchronized (arrayList) {
                    String[] pendingMessages = null;
                    ArrayList<String> arrayList2 = this.messages;
                    synchronized (arrayList2) {
                        pendingMessages = this.messages.toArray(new String[0]);
                        this.messages.clear();
                    }
                    int i = 0;
                    while (i < StreamingXHRServlet.this.connections.size()) {
                        try {
                            PrintWriter writer = StreamingXHRServlet.this.connections.get(i).getWriter();
                            int j = 0;
                            while (j < pendingMessages.length) {
                                writer.println(String.valueOf(pendingMessages[j]) + "<br>");
                                ++j;
                            }
                            writer.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
            }
        }
    }

    class TimeSender
    implements Runnable {
        TimeSender() {
        }

        @Override
        public void run() {
            while (true) {
                StreamingXHRServlet.this.messageSender.send("System", new Date().toLocaleString());
                StreamingXHRServlet.this.log("send" + new Date().toLocaleString());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

