/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core.temp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.StringTokenizer;
import org.comet4j.core.temp.Bytes;
import org.comet4j.core.temp.IMonitorService;
import org.comet4j.core.temp.MonitorInfoBean;

public class MonitorServiceImpl
implements IMonitorService {
    private static final int CPUTIME = 30;
    private static final int PERCENT = 100;
    private static final int FAULTLENGTH = 10;
    private static String linuxVersion = null;

    @Override
    public MonitorInfoBean getMonitorInfoBean() throws Exception {
        int kb = 1024;
        long totalMemory = Runtime.getRuntime().totalMemory() / (long)kb;
        long freeMemory = Runtime.getRuntime().freeMemory() / (long)kb;
        long maxMemory = Runtime.getRuntime().maxMemory() / (long)kb;
        OperatingSystemMXBean osmxb = ManagementFactory.getOperatingSystemMXBean();
        String osName = System.getProperty("os.name");
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        int totalThread = parentThread.activeCount();
        double cpuRatio = 0.0;
        cpuRatio = osName.toLowerCase().startsWith("windows") ? this.getCpuRatioForWindows() : MonitorServiceImpl.getCpuRateForLinux();
        MonitorInfoBean infoBean = new MonitorInfoBean();
        infoBean.setFreeMemory(freeMemory);
        infoBean.setMaxMemory(maxMemory);
        infoBean.setOsName(osName);
        infoBean.setTotalMemory(totalMemory);
        infoBean.setTotalThread(totalThread);
        infoBean.setCpuRatio(cpuRatio);
        return infoBean;
    }

    private static double getCpuRateForLinux() {
        double d;
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader brStat = null;
        StringTokenizer tokenStat = null;
        try {
            System.out.println("Get usage rate of CUP , linux version: " + linuxVersion);
            Process process = Runtime.getRuntime().exec("top -b -n 1");
            is = process.getInputStream();
            isr = new InputStreamReader(is);
            brStat = new BufferedReader(isr);
            if (linuxVersion.equals("2.4")) {
                brStat.readLine();
                brStat.readLine();
                brStat.readLine();
                brStat.readLine();
                tokenStat = new StringTokenizer(brStat.readLine());
                tokenStat.nextToken();
                tokenStat.nextToken();
                String user = tokenStat.nextToken();
                tokenStat.nextToken();
                String system = tokenStat.nextToken();
                tokenStat.nextToken();
                String nice = tokenStat.nextToken();
                System.out.println(String.valueOf(user) + " , " + system + " , " + nice);
                user = user.substring(0, user.indexOf("%"));
                system = system.substring(0, system.indexOf("%"));
                nice = nice.substring(0, nice.indexOf("%"));
                float userUsage = new Float(user).floatValue();
                float systemUsage = new Float(system).floatValue();
                float niceUsage = new Float(nice).floatValue();
                double d2 = (userUsage + systemUsage + niceUsage) / 100.0f;
                MonitorServiceImpl.freeResource(is, isr, brStat);
                return d2;
            }
            brStat.readLine();
            brStat.readLine();
            tokenStat = new StringTokenizer(brStat.readLine());
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            tokenStat.nextToken();
            String cpuUsage = tokenStat.nextToken();
            System.out.println("CPU idle : " + cpuUsage);
            Float usage = new Float(cpuUsage.substring(0, cpuUsage.indexOf("%")));
            d = 1.0f - usage.floatValue() / 100.0f;
            MonitorServiceImpl.freeResource(is, isr, brStat);
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            MonitorServiceImpl.freeResource(is, isr, brStat);
            return 1.0;
        }
        finally {
            MonitorServiceImpl.freeResource(is, isr, brStat);
        }
        return d;
    }

    private static void freeResource(InputStream is, InputStreamReader isr, BufferedReader br) {
        try {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
    }

    private double getCpuRatioForWindows() {
        try {
            String procCmd = String.valueOf(System.getenv("windir")) + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine," + "KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
            long[] c0 = this.readCpu(Runtime.getRuntime().exec(procCmd));
            Thread.sleep(30L);
            long[] c1 = this.readCpu(Runtime.getRuntime().exec(procCmd));
            if (c0 != null && c1 != null) {
                long idletime = c1[0] - c0[0];
                long busytime = c1[1] - c0[1];
                return 100L * busytime / (busytime + idletime);
            }
            return 0.0;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0.0;
        }
    }

    private long[] readCpu(Process proc) {
        long[] retn = new long[2];
        try {
            proc.getOutputStream().close();
            InputStreamReader ir = new InputStreamReader(proc.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            String line = input.readLine();
            if (line == null || line.length() < 10) {
                return null;
            }
            int capidx = line.indexOf("Caption");
            int cmdidx = line.indexOf("CommandLine");
            int rocidx = line.indexOf("ReadOperationCount");
            int umtidx = line.indexOf("UserModeTime");
            int kmtidx = line.indexOf("KernelModeTime");
            int wocidx = line.indexOf("WriteOperationCount");
            long idletime = 0L;
            long kneltime = 0L;
            long usertime = 0L;
            while ((line = input.readLine()) != null) {
                if (line.length() < wocidx) continue;
                String caption = Bytes.substring(line, capidx, cmdidx - 1).trim();
                String cmd = Bytes.substring(line, cmdidx, kmtidx - 1).trim();
                if (cmd.indexOf("wmic.exe") >= 0) continue;
                if (caption.equals("System Idle Process") || caption.equals("System")) {
                    idletime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                    idletime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
                    continue;
                }
                kneltime += Long.valueOf(Bytes.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                usertime += Long.valueOf(Bytes.substring(line, umtidx, wocidx - 1).trim()).longValue();
            }
            retn[0] = idletime;
            retn[1] = kneltime + usertime;
            long[] lArray = retn;
            return lArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                proc.getInputStream().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        MonitorServiceImpl service = new MonitorServiceImpl();
        MonitorInfoBean monitorInfo = service.getMonitorInfoBean();
        System.out.println("cpu\u5360\u6709\u7387=" + monitorInfo.getCpuRatio());
        System.out.println("\u53ef\u4f7f\u7528\u5185\u5b58=" + monitorInfo.getTotalMemory());
        System.out.println("\u5269\u4f59\u5185\u5b58=" + monitorInfo.getFreeMemory());
        System.out.println("\u6700\u5927\u53ef\u4f7f\u7528\u5185\u5b58=" + monitorInfo.getMaxMemory());
        System.out.println("\u64cd\u4f5c\u7cfb\u7edf=" + monitorInfo.getOsName());
        System.out.println("\u603b\u7684\u7269\u7406\u5185\u5b58=" + monitorInfo.getTotalMemorySize() + "kb");
        System.out.println("\u5269\u4f59\u7684\u7269\u7406\u5185\u5b58=" + monitorInfo.getFreeMemory() + "kb");
        System.out.println("\u5df2\u4f7f\u7528\u7684\u7269\u7406\u5185\u5b58=" + monitorInfo.getUsedMemory() + "kb");
        System.out.println("\u7ebf\u7a0b\u603b\u6570=" + monitorInfo.getTotalThread() + "kb");
    }
}

