/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core.temp;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.apache.catalina.CometProcessor;
import org.comet4j.core.util.ExplorerUtil;

public class MixServlet
extends HttpServlet
implements CometProcessor {
    private static final long serialVersionUID = 1L;
    protected Map<HttpServletResponse, Boolean> connections = new ConcurrentHashMap<HttpServletResponse, Boolean>(0);
    protected MessageSender messageSender = null;
    protected Boolean debug = false;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.messageSender = new MessageSender();
        Thread messageSenderThread = new Thread((Runnable)this.messageSender, "MessageSender[" + this.getServletContext().getContextPath() + "]");
        messageSenderThread.setDaemon(true);
        messageSenderThread.start();
        Thread timeSenderThread = new Thread(new TimeSender());
        timeSenderThread.setDaemon(true);
    }

    public void destroy() {
        this.connections.clear();
        this.messageSender.stop();
        this.messageSender = null;
        this.debug = null;
    }

    public void event(CometEvent event) throws IOException, ServletException {
        HttpServletRequest request = event.getHttpServletRequest();
        HttpServletResponse response = event.getHttpServletResponse();
        if (event.getEventType() == CometEvent.EventType.BEGIN) {
            this.log("-->begin:canStreaming:" + ExplorerUtil.canStreamingXHR(request));
            this.connections.put(response, ExplorerUtil.canStreamingXHR(request));
            event.setTimeout(6000);
        } else if (event.getEventType() == CometEvent.EventType.ERROR) {
            this.connections.remove(response);
            if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                this.log("-->timeout");
                response.setStatus(408);
            }
            response.getWriter().close();
        } else if (event.getEventType() == CometEvent.EventType.END) {
            this.log("-->end");
            this.connections.remove(response);
            response.getWriter().close();
            event.close();
        } else if (event.getEventType() == CometEvent.EventType.READ) {
            this.log("-->read");
        }
    }

    public class MessageSender
    implements Runnable {
        protected boolean running = true;
        protected ArrayList<String> messages = new ArrayList();

        public void stop() {
            this.running = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(String user, String message) {
            ArrayList<String> arrayList = this.messages;
            synchronized (arrayList) {
                this.messages.add("[" + user + "]: " + message);
                this.messages.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.running) {
                if (this.messages.size() == 0) {
                    try {
                        ArrayList<String> arrayList = this.messages;
                        synchronized (arrayList) {
                            this.messages.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                String[] pendingMessages = null;
                ArrayList<String> arrayList = this.messages;
                synchronized (arrayList) {
                    pendingMessages = this.messages.toArray(new String[0]);
                    this.messages.clear();
                }
                for (Map.Entry<HttpServletResponse, Boolean> entry : MixServlet.this.connections.entrySet()) {
                    HttpServletResponse connection = entry.getKey();
                    Boolean isStreaming = entry.getValue();
                    MixServlet.this.log("isStreaming:" + isStreaming.toString());
                    try {
                        PrintWriter writer = connection.getWriter();
                        int j = 0;
                        while (j < pendingMessages.length) {
                            writer.println(String.valueOf(pendingMessages[j]) + "<br>");
                            ++j;
                        }
                        writer.flush();
                        if (isStreaming.booleanValue()) continue;
                        writer.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class TimeSender
    implements Runnable {
        TimeSender() {
        }

        @Override
        public void run() {
            while (true) {
                MixServlet.this.messageSender.send("System", new Date().toLocaleString());
                MixServlet.this.log("send" + new Date().toLocaleString());
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

