/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core.temp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class AjaxHttpRequest {
    public static final int STATE_UNINITIALIZED = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_LOADED = 2;
    public static final int STATE_INTERACTIVE = 3;
    public static final int STATE_COMPLETE = 4;
    public static final String DEFAULT_USERAGENT = "Mozilla/4.0 (compatible; MSIE 6.0;) JavaAjax/1.0";
    public static final String DEFAULT_AJAX_CHARSET = "UTF-8";
    public static final String DEFAULT_HTTP_CHARSET = "ISO-8859-1";
    public static final String DEFAULT_REQUEST_METHOD = "POST";
    private int readyState;
    private int status;
    private String statusText;
    private String responseHeaders;
    private byte[] responseBytes;
    private Map responseHeadersMap;
    private final Map requestHeadersMap = new LinkedHashMap();
    private ReadyStateChangeListener readyStateChangeListener;
    private boolean async;
    private boolean sent;
    private URLConnection connection;
    private String userAgent = "Mozilla/4.0 (compatible; MSIE 6.0;) JavaAjax/1.0";
    private String postCharset = "UTF-8";
    private Proxy proxy;
    private URL requestURL;
    protected String requestMethod;
    protected String requestUserName;
    protected String requestPassword;

    public AjaxHttpRequest() {
        this.setRequestHeader("X-Requested-With", "XMLHttpRequest");
        this.setRequestHeader("Accept", "text/javascript, text/html, application/xml, application/json, text/xml, */*");
    }

    public synchronized int getReadyState() {
        return this.readyState;
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized String getStatusText() {
        return this.statusText;
    }

    public void setRequestHeader(String key, String value) {
        this.requestHeadersMap.put(key, value);
    }

    public void open(String method, String url, boolean async, String userName, String password) throws IOException {
        URL urlObj = AjaxHttpRequest.createURL(null, url);
        this.open(method, urlObj, async, userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(String method, URL url, boolean async, String userName, String password) throws IOException {
        this.abort();
        Proxy proxy = this.proxy;
        URLConnection c = proxy == null || proxy == Proxy.NO_PROXY ? url.openConnection() : url.openConnection(proxy);
        AjaxHttpRequest ajaxHttpRequest = this;
        synchronized (ajaxHttpRequest) {
            this.connection = c;
            this.async = async;
            this.requestMethod = method;
            this.requestURL = url;
            this.requestUserName = userName;
            this.requestPassword = password;
        }
        this.changeState(1, 0, null, null);
    }

    public void open(String url, boolean async) throws IOException {
        this.open(DEFAULT_REQUEST_METHOD, url, async, null, null);
    }

    public void open(String method, String url, boolean async) throws IOException {
        this.open(method, url, async, null, null);
    }

    public void send(Map parameters) throws IOException {
        Iterator keyItr = parameters.keySet().iterator();
        StringBuffer strb = new StringBuffer();
        while (keyItr.hasNext()) {
            Object key = keyItr.next();
            String keyStr = this.encode(key);
            String valueStr = this.encode(parameters.get(key));
            strb.append(keyStr).append("=").append(valueStr);
            strb.append("&");
        }
        this.send(strb.toString());
    }

    public void send(final String content) throws IOException {
        final URL url = this.requestURL;
        if (url == null) {
            throw new IOException("No URL has been provided.");
        }
        if (this.isAsync()) {
            new Thread("AjaxHttpRequest-" + url.getHost()){

                @Override
                public void run() {
                    try {
                        AjaxHttpRequest.this.sendSync(content);
                    }
                    catch (Throwable thrown) {
                        AjaxHttpRequest.log(Level.WARNING, "send(): Error in asynchronous request on " + url, thrown);
                    }
                }
            }.start();
        } else {
            this.sendSync(content);
        }
    }

    public synchronized String getResponseHeader(String headerName) {
        return this.responseHeadersMap == null ? null : (String)this.responseHeadersMap.get(headerName);
    }

    public synchronized String getAllResponseHeaders() {
        return this.responseHeaders;
    }

    public synchronized String getResponseText() {
        byte[] bytes = this.responseBytes;
        String encoding = AjaxHttpRequest.getCharset(this.connection);
        if (encoding == null) {
            encoding = this.getPostCharset();
        }
        if (encoding == null) {
            encoding = DEFAULT_HTTP_CHARSET;
        }
        try {
            return bytes == null ? null : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException uee) {
            AjaxHttpRequest.log(Level.WARNING, "getResponseText(): Charset '" + encoding + "' did not work. Retrying with " + DEFAULT_HTTP_CHARSET + ".", uee);
            try {
                return new String(bytes, DEFAULT_HTTP_CHARSET);
            }
            catch (UnsupportedEncodingException uee2) {
                return null;
            }
        }
    }

    @Deprecated
    public synchronized byte[] getResponseBody() {
        return this.getResponseBytes();
    }

    public synchronized byte[] getResponseBytes() {
        return this.responseBytes;
    }

    public void setReadyStateChangeListener(ReadyStateChangeListener listener) {
        this.readyStateChangeListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        URLConnection c = null;
        AjaxHttpRequest ajaxHttpRequest = this;
        synchronized (ajaxHttpRequest) {
            c = this.getConnection();
        }
        if (c instanceof HttpURLConnection) {
            ((HttpURLConnection)c).disconnect();
        } else if (c != null) {
            try {
                c.getInputStream().close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public boolean hasSent() {
        return this.sent;
    }

    protected void setSent(boolean sent) {
        this.sent = sent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getPostCharset() {
        return this.postCharset;
    }

    public void setPostCharset(String postCharset) {
        this.postCharset = postCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendSync(String content) throws IOException {
        InputStream err;
        String istatusText;
        int istatus;
        Object hc;
        URLConnection c;
        block25: {
            AjaxHttpRequest ajaxHttpRequest;
            if (this.hasSent()) {
                AjaxHttpRequest.log(Level.WARNING, "This AjaxHttpRequest Object has sent", null);
                return;
            }
            try {
                AjaxHttpRequest ajaxHttpRequest2 = this;
                synchronized (ajaxHttpRequest2) {
                    c = this.connection;
                }
                if (c != null) break block25;
                AjaxHttpRequest.log(Level.WARNING, "Please open AjaxHttpRequest first.", null);
                ajaxHttpRequest = this;
            }
            catch (Throwable throwable) {
                AjaxHttpRequest ajaxHttpRequest3 = this;
                synchronized (ajaxHttpRequest3) {
                    this.connection = null;
                    this.setSent(false);
                }
                throw throwable;
            }
            synchronized (ajaxHttpRequest) {
                this.connection = null;
                this.setSent(false);
            }
            return;
        }
        this.setSent(true);
        this.initConnectionRequestHeader(c);
        if (c instanceof HttpURLConnection) {
            hc = (HttpURLConnection)c;
            String method = this.requestMethod == null ? DEFAULT_REQUEST_METHOD : this.requestMethod;
            method = method.toUpperCase();
            ((HttpURLConnection)hc).setRequestMethod(method);
            if (DEFAULT_REQUEST_METHOD.equals(method) && content != null) {
                ((URLConnection)hc).setDoOutput(true);
                byte[] contentBytes = content.getBytes(this.getPostCharset());
                ((HttpURLConnection)hc).setFixedLengthStreamingMode(contentBytes.length);
                OutputStream out = ((URLConnection)hc).getOutputStream();
                try {
                    out.write(contentBytes);
                }
                finally {
                    out.flush();
                }
            }
            istatus = ((HttpURLConnection)hc).getResponseCode();
            istatusText = ((HttpURLConnection)hc).getResponseMessage();
            err = ((HttpURLConnection)hc).getErrorStream();
        } else {
            istatus = 0;
            istatusText = "";
            err = null;
        }
        hc = this;
        synchronized (hc) {
            this.responseHeaders = AjaxHttpRequest.getConnectionResponseHeaders(c);
            this.responseHeadersMap = c.getHeaderFields();
        }
        this.changeState(2, istatus, istatusText, null);
        InputStream in = err == null ? c.getInputStream() : err;
        int contentLength = c.getContentLength();
        this.changeState(3, istatus, istatusText, null);
        byte[] bytes = AjaxHttpRequest.loadStream(in, contentLength == -1 ? 4096 : contentLength);
        this.changeState(4, istatus, istatusText, bytes);
        AjaxHttpRequest ajaxHttpRequest = this;
        synchronized (ajaxHttpRequest) {
            this.connection = null;
            this.setSent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(int readyState, int status, String statusMessage, byte[] bytes) {
        AjaxHttpRequest ajaxHttpRequest = this;
        synchronized (ajaxHttpRequest) {
            this.readyState = readyState;
            this.status = status;
            this.statusText = statusMessage;
            this.responseBytes = bytes;
        }
        if (this.readyStateChangeListener != null) {
            this.readyStateChangeListener.onReadyStateChange();
        }
    }

    protected String encode(Object str) {
        try {
            return URLEncoder.encode(String.valueOf(str), this.getPostCharset());
        }
        catch (UnsupportedEncodingException e) {
            return String.valueOf(str);
        }
    }

    protected void initConnectionRequestHeader(URLConnection c) {
        c.setRequestProperty("User-Agent", this.getUserAgent());
        for (String key : this.requestHeadersMap.keySet()) {
            String value = (String)this.requestHeadersMap.get(key);
            c.setRequestProperty(key, value);
        }
    }

    public String getRequestHeader(String key) {
        return (String)this.requestHeadersMap.get(key);
    }

    public String removeRequestHeader(String key) {
        return (String)this.requestHeadersMap.remove(key);
    }

    public void removeAllRequestHeaders() {
        this.requestHeadersMap.clear();
    }

    public Map getAllRequestHeaders() {
        return this.requestHeadersMap;
    }

    public URLConnection getConnection() {
        return this.connection;
    }

    public void setConnection(URLConnection connection) {
        this.connection = connection;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public static void log(Level level, String msg, Throwable thrown) {
        System.out.println(String.valueOf(level.getName()) + " : " + thrown.getMessage() + " ----- " + msg);
    }

    public static String getConnectionResponseHeaders(URLConnection c) {
        String value;
        int idx = 0;
        StringBuffer buf = new StringBuffer();
        while ((value = c.getHeaderField(idx)) != null) {
            String key = c.getHeaderFieldKey(idx);
            buf.append(key);
            buf.append(": ");
            buf.append(value);
            ++idx;
        }
        return buf.toString();
    }

    public static String getCharset(URLConnection connection) {
        StringTokenizer tok;
        String contentType;
        String string = contentType = connection == null ? null : connection.getContentType();
        if (contentType != null && (tok = new StringTokenizer(contentType, ";")).hasMoreTokens()) {
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                String varName;
                String assignment = tok.nextToken().trim();
                int eqIdx = assignment.indexOf(61);
                if (eqIdx == -1 || !"charset".equalsIgnoreCase(varName = assignment.substring(0, eqIdx).trim())) continue;
                String varValue = assignment.substring(eqIdx + 1);
                return AjaxHttpRequest.unquote(varValue.trim());
            }
        }
        return null;
    }

    public static String unquote(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 2);
        }
        return text;
    }

    protected static URL createURL(URL baseUrl, String relativeUrl) throws MalformedURLException {
        return new URL(baseUrl, relativeUrl);
    }

    protected static byte[] loadStream(InputStream in, int initialBufferSize) throws IOException {
        if (initialBufferSize == 0) {
            initialBufferSize = 1;
        }
        byte[] buffer = new byte[initialBufferSize];
        int offset = 0;
        while (true) {
            int numRead;
            int remain;
            if ((remain = buffer.length - offset) <= 0) {
                int newSize = buffer.length * 2;
                byte[] newBuffer = new byte[newSize];
                System.arraycopy(buffer, 0, newBuffer, 0, offset);
                buffer = newBuffer;
                remain = buffer.length - offset;
            }
            if ((numRead = in.read(buffer, offset, remain)) == -1) break;
            offset += numRead;
        }
        if (offset < buffer.length) {
            byte[] newBuffer = new byte[offset];
            System.arraycopy(buffer, 0, newBuffer, 0, offset);
            buffer = newBuffer;
        }
        return buffer;
    }

    public static void testGoogleTranslate(String words, boolean async) throws IOException {
        HashMap params = new HashMap();
        String url = "http://localhost:8080/long";
        AjaxHttpRequest ajax = new AjaxHttpRequest();
        ajax.setReadyStateChangeListener(new ReadyStateChangeListener(){

            @Override
            public void onReadyStateChange() {
                int readyState = AjaxHttpRequest.this.getReadyState();
                System.out.println(AjaxHttpRequest.this.getStatus());
                System.out.println(AjaxHttpRequest.this.getReadyState());
                if (readyState == 4) {
                    System.out.println(AjaxHttpRequest.this.getResponseText());
                }
            }
        });
        ajax.open(DEFAULT_REQUEST_METHOD, url, true);
        ajax.send(params);
    }

    public static void main(String[] args) throws IOException {
        AjaxHttpRequest.testGoogleTranslate("Hello world!", false);
    }

    public static abstract class ReadyStateChangeListener {
        public abstract void onReadyStateChange();
    }
}

