/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import org.comet4j.core.CometContext;

public class Language {
    private static String cnLanguageFile = "/language-cn.xml";
    private static String enLanguageFile = "/language-en.xml";
    private static Properties prop;

    private static void beforeGet() {
        if (prop == null) {
            InputStream in;
            Locale locale = CometContext.getInstance().getLocale();
            if (Locale.ENGLISH == locale) {
                in = Language.class.getResourceAsStream(enLanguageFile);
                prop = new Properties();
                try {
                    prop.loadFromXML(in);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (Locale.CHINESE == locale) {
                in = Language.class.getResourceAsStream(cnLanguageFile);
                prop = new Properties();
                try {
                    prop.loadFromXML(in);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String get(String key) {
        Language.beforeGet();
        return prop.getProperty(key);
    }

    public static String getConnectSuccess() {
        Language.beforeGet();
        return prop.getProperty("ConnectSuccess");
    }

    public static String getConnectFailure() {
        Language.beforeGet();
        return prop.getProperty("ConnectFailure");
    }

    public void destroy() {
        prop = null;
    }
}

