/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.comet4j.core.CometConnection;
import org.comet4j.core.CometContext;
import org.comet4j.core.CometMessage;

public class ExpiresCache {
    private final long timespan;
    private final long frequency;
    boolean init = true;
    private long size = 0L;
    private final Map<CometConnection, List<CometMessage>> cache = Collections.synchronizedMap(new WeakHashMap());

    public ExpiresCache(long aTimespan, long aFrequency) {
        this.frequency = aFrequency;
        this.timespan = aTimespan;
        Thread cleanerThread = new Thread((Runnable)new CacheCleaner(), "Comet4J-MessageCleaner");
        cleanerThread.setDaemon(true);
        cleanerThread.start();
    }

    public synchronized void push(CometConnection c, CometMessage e) {
        if (c == null) {
            return;
        }
        List<CometMessage> list = this.cache.get(c);
        if (list == null) {
            list = new ArrayList<CometMessage>();
            this.cache.put(c, list);
        }
        list.add(e);
    }

    public synchronized void push(CometConnection c, List<CometMessage> e) {
        if (c == null) {
            return;
        }
        List<CometMessage> list = this.cache.get(c);
        if (list == null) {
            list = new ArrayList<CometMessage>();
            this.cache.put(c, list);
        }
        list.addAll(e);
    }

    public synchronized List<CometMessage> get(CometConnection c) {
        List<CometMessage> list = this.cache.get(c);
        if (list != null) {
            this.cache.remove(c);
        }
        return list;
    }

    public void destroy() {
        this.init = false;
        for (CometConnection o : this.cache.keySet()) {
            this.cache.get(o).clear();
        }
        this.cache.clear();
    }

    class CacheCleaner
    implements Runnable {
        private final List<CometConnection> toDeleteList = new ArrayList<CometConnection>();
        private final List<CometMessage> toDeleteMessageList = new ArrayList<CometMessage>();

        CacheCleaner() {
        }

        @Override
        public void run() {
            while (ExpiresCache.this.init) {
                try {
                    CometContext.getInstance().log("\u3010CometDebug\u3011\u5f00\u59cb\u6e05\u7406\u6d88\u606f\u7f13\u5b58");
                    Thread.sleep(ExpiresCache.this.frequency);
                    this.checkExpires();
                    CometContext.getInstance().log("\u3010CometDebug\u3011\u5f00\u59cb\u6e05\u7406\u6d88\u606f\u7f13\u5b58\u5b8c\u6bd5");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkExpires() {
            ExpiresCache.this.size = 0L;
            Map map = ExpiresCache.this.cache;
            synchronized (map) {
                for (CometConnection o : ExpiresCache.this.cache.keySet()) {
                    List list = (List)ExpiresCache.this.cache.get(o);
                    ExpiresCache expiresCache = ExpiresCache.this;
                    expiresCache.size = expiresCache.size + (long)list.size();
                    if (list.size() > 0) {
                        List list2 = list;
                        synchronized (list2) {
                            for (CometMessage msg : list) {
                                long expireMillis = msg.getTime() + ExpiresCache.this.timespan;
                                if (expireMillis >= System.currentTimeMillis()) continue;
                                this.toDeleteMessageList.add(msg);
                            }
                            if (!this.toDeleteMessageList.isEmpty()) {
                                for (CometMessage msg : this.toDeleteMessageList) {
                                    list.remove(msg);
                                }
                                this.toDeleteMessageList.clear();
                            }
                        }
                    }
                    if (list.size() != 0) continue;
                    this.toDeleteList.add(o);
                }
                if (!this.toDeleteList.isEmpty()) {
                    for (CometConnection c : this.toDeleteList) {
                        ExpiresCache.this.cache.remove(c);
                    }
                    this.toDeleteList.clear();
                }
            }
            CometContext.getInstance().log("\u3010CometDebug\u3011\u7f13\u5b58\u6570\u91cf:" + ExpiresCache.this.size);
        }
    }
}

