/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.comet4j.core.CometConnection;
import org.comet4j.core.CometMessage;
import org.comet4j.core.CometProtocol;
import org.comet4j.core.ExpiresCache;

public class CometSender {
    private ExpiresCache cacher;

    public CometSender(long timespan, long frequency) {
        this.cacher = new ExpiresCache(timespan, frequency);
    }

    synchronized void sendTo(CometConnection c, CometMessage msg) {
        if (c == null) {
            return;
        }
        if ("dying".equals(c.getState()) || c.getResponse() == null) {
            this.cacher.push(c, msg);
            return;
        }
        try {
            this.writeData(c, msg);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    void sendTo(CometConnection c, List<CometMessage> list) {
        if (c == null || list.isEmpty()) {
            return;
        }
        for (CometMessage msg : list) {
            this.sendTo(c, msg);
        }
    }

    void sendTo(List<CometConnection> list, CometMessage msg) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (CometConnection c : list) {
            this.sendTo(c, msg);
        }
    }

    private void writeData(CometConnection c, CometMessage msg) throws IOException {
        c.setDyingTime(System.currentTimeMillis());
        HttpServletResponse response = c.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=UTF-8");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        PrintWriter writer = response.getWriter();
        writer.print(CometProtocol.encode(msg));
        this.close(c);
    }

    private void close(CometConnection c) throws IOException {
        if (c.getResponse() != null) {
            if (c.getWorkStyle().equals("lpool")) {
                c.setState("dying");
                try {
                    c.getResponse().getWriter().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                c.setResponse(null);
            } else {
                try {
                    c.getResponse().flushBuffer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    List<CometMessage> getCacheMessage(CometConnection conn) {
        return this.cacher.get(conn);
    }

    void sendCacheMessage(CometConnection conn) {
        List<CometMessage> list = this.getCacheMessage(conn);
        if (list != null && !list.isEmpty()) {
            for (CometMessage msg : list) {
                this.sendTo(conn, msg);
            }
        }
    }

    public void destroy() {
        this.cacher.init = false;
        this.cacher = null;
    }
}

