/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.comet4j.core.CometConnection;
import org.comet4j.core.CometConnector;
import org.comet4j.core.CometContext;
import org.comet4j.core.CometMessage;
import org.comet4j.core.CometSender;
import org.comet4j.core.dto.ConnectionDTO;
import org.comet4j.core.event.BeforeConnectEvent;
import org.comet4j.core.event.BeforeDropEvent;
import org.comet4j.core.event.BeforeRemoveEvent;
import org.comet4j.core.event.ConnectEvent;
import org.comet4j.core.event.DropEvent;
import org.comet4j.core.event.DyingEvent;
import org.comet4j.core.event.ErrorEvent;
import org.comet4j.core.event.MessageEvent;
import org.comet4j.core.event.RemovedEvent;
import org.comet4j.core.event.RevivalEvent;
import org.comet4j.core.listener.BeforeConnectListener;
import org.comet4j.core.listener.BeforeDropListener;
import org.comet4j.core.listener.BeforeRemoveListener;
import org.comet4j.core.listener.ConnectListener;
import org.comet4j.core.listener.DropListener;
import org.comet4j.core.listener.DyingListener;
import org.comet4j.core.listener.MessageListener;
import org.comet4j.core.listener.RemovedListener;
import org.comet4j.core.listener.RevivalListener;
import org.comet4j.event.Observable;

public class CometEngine
extends Observable {
    private CometConnector ct;
    private CometSender sender;

    public CometEngine() {
        this.addEvent(BeforeConnectEvent.class);
        this.addEvent(ConnectEvent.class);
        this.addEvent(BeforeDropEvent.class);
        this.addEvent(DropEvent.class);
        this.addEvent(DyingEvent.class);
        this.addEvent(RevivalEvent.class);
        this.addEvent(MessageEvent.class);
        this.addEvent(ErrorEvent.class);
        CometContext cc = CometContext.getInstance();
        this.sender = new CometSender(cc.getCacheExpires(), cc.getCacheFrequency());
        this.ct = new CometConnector(cc.getConnExpires(), cc.getConnFrequency());
    }

    void connect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uId = request.getParameter("uid");
        CometContext.getInstance().log("\u3010CometDebug\u3011-->\u3010connect\u3011-->uid:" + uId);
        CometConnection conn = new CometConnection(request, response);
        BeforeConnectEvent be = new BeforeConnectEvent(this, request, response);
        if (!this.fireEvent(be)) {
            conn.getResponse().setStatus(400);
            conn.getResponse().getWriter().close();
            return;
        }
        this.ct.addConnection(conn);
        CometContext cc = CometContext.getInstance();
        ConnectionDTO cdto = new ConnectionDTO(conn.getId(), conn.getWorkStyle(), cc.getAppModules(), cc.getTimeout());
        this.sendTo("c4j", conn, (Object)cdto);
        try {
            try {
                conn.getResponse().getWriter().close();
                conn.setState("dying");
                conn.setResponse(null);
                conn.setDyingTime(System.currentTimeMillis());
            }
            catch (Exception exception) {
                ConnectEvent e = new ConnectEvent(this, conn);
                this.fireEvent(e);
            }
        }
        finally {
            ConnectEvent e = new ConnectEvent(this, conn);
            this.fireEvent(e);
        }
    }

    void dying(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uId = request.getParameter("uid");
        String cId = request.getParameter("cid");
        CometContext.getInstance().log("\u3010CometDebug\u3011-->\u3010dying\u3011-->cid:" + cId + "," + "uid:" + uId);
        CometConnection conn = this.ct.getConnection(request);
        if (conn != null) {
            CometContext.getInstance().getEngine().sendTo("c4j", conn, (Object)"dying");
        }
        try {
            conn.getResponse().getWriter().close();
        }
        catch (Exception exc) {
            try {
                response.getWriter().close();
            }
            catch (Exception excp) {
                excp.printStackTrace();
            }
        }
        if (conn != null) {
            conn.setState("dying");
            conn.setResponse(null);
            conn.setDyingTime(System.currentTimeMillis());
            DyingEvent e = new DyingEvent(this, conn);
            this.fireEvent(e);
        }
    }

    void revival(HttpServletRequest request, HttpServletResponse response) throws IOException {
        CometConnection conn;
        String cId = this.getConnectionId(request);
        String uId = request.getParameter("uid");
        CometContext.getInstance().log("\u3010CometDebug\u3011-->\u3010revival\u3011-->cid:" + cId + "," + "uid:" + uId);
        if (cId == null) {
            this.drop(request, response);
        }
        if ((conn = this.ct.getConnection(cId)) != null) {
            conn.setRequest(request);
            conn.setResponse(response);
            conn.setDyingTime(System.currentTimeMillis());
            conn.setState("alive");
            RevivalEvent e = new RevivalEvent(this, conn);
            this.fireEvent(e);
            this.sender.sendCacheMessage(conn);
        } else {
            this.drop(request, response);
        }
    }

    public void drop(HttpServletRequest request, HttpServletResponse response) throws IOException {
        BeforeDropEvent be = new BeforeDropEvent(this, request);
        if (!this.fireEvent(be)) {
            return;
        }
        String cId = this.getConnectionId(request);
        String uId = request.getParameter("uid");
        CometContext.getInstance().log("\u3010CometDebug\u3011-->\u3010drop\u3011-->cid:" + cId + "," + "uid:" + uId);
        CometConnection conn = null;
        conn = cId != null ? this.ct.getConnection(cId) : this.ct.getConnection(request);
        if (conn != null) {
            this.remove(conn);
        }
        response.getWriter().close();
    }

    void remove(CometConnection aConn) {
        BeforeRemoveEvent be = new BeforeRemoveEvent(this, aConn);
        if (!this.fireEvent(be)) {
            return;
        }
        this.sender.getCacheMessage(aConn);
        this.ct.removeConnection(aConn);
        RemovedEvent re = new RemovedEvent(this, aConn);
        this.fireEvent(re);
        DropEvent de = new DropEvent(this, aConn);
        this.fireEvent(de);
    }

    public CometConnection getConnection(String id) {
        return this.ct.getConnection(id);
    }

    public CometConnection getConnection(HttpServletRequest request) {
        String cId = this.getConnectionId(request);
        CometConnection conn = null;
        conn = cId != null ? this.ct.getConnection(cId) : this.ct.getConnection(request);
        return conn;
    }

    public List<CometConnection> getConnections() {
        return this.ct.getConnections();
    }

    public void sendTo(String channel, CometConnection c, Object data) {
        CometMessage msg = new CometMessage(data, channel);
        this.sender.sendTo(c, msg);
        MessageEvent e = new MessageEvent(this, c, msg);
        this.fireEvent(e);
    }

    public void sendTo(String channel, CometConnection c, List<Object> data) {
        for (Object o : data) {
            this.sendTo(channel, c, o);
        }
    }

    public void sendTo(String channel, List<CometConnection> list, Object data) {
        if (list.isEmpty()) {
            return;
        }
        for (CometConnection c : list) {
            this.sendTo(channel, c, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToAll(String channel, Object data) {
        List<CometConnection> list = this.getConnections();
        if (list == null) {
            return;
        }
        List<CometConnection> list2 = list;
        synchronized (list2) {
            for (CometConnection c : list) {
                this.sendTo(channel, c, data);
            }
        }
    }

    public String getConnectionId(HttpServletRequest request) {
        String id = request.getParameter("cid");
        if (id == null || "".equals(id)) {
            id = null;
        }
        return id;
    }

    public void addBeforeConnectListener(BeforeConnectListener li) {
        this.addListener(BeforeConnectEvent.class, li);
    }

    public void removeBeforeConnectListener(BeforeConnectListener li) {
        this.removeListener(BeforeConnectEvent.class, li);
    }

    public void addBeforeDropListener(BeforeDropListener li) {
        this.addListener(BeforeDropEvent.class, li);
    }

    public void removeBeforeDropListener(BeforeDropListener li) {
        this.removeListener(BeforeDropEvent.class, li);
    }

    public void addBeforeRemoveListener(BeforeRemoveListener li) {
        this.addListener(BeforeRemoveEvent.class, li);
    }

    public void removeBeforeRemoveListener(BeforeRemoveListener li) {
        this.removeListener(BeforeRemoveEvent.class, li);
    }

    public void addConnectListener(ConnectListener li) {
        this.addListener(ConnectEvent.class, li);
    }

    public void removeConnectListener(ConnectListener li) {
        this.removeListener(ConnectEvent.class, li);
    }

    public void addDropListener(DropListener li) {
        this.addListener(DropEvent.class, li);
    }

    public void removeDropListener(DropListener li) {
        this.removeListener(DropEvent.class, li);
    }

    public void addDyingListener(DyingListener li) {
        this.addListener(DyingEvent.class, li);
    }

    public void removeDyingListener(DyingListener li) {
        this.removeListener(DyingEvent.class, li);
    }

    public void addMessageListener(MessageListener li) {
        this.addListener(MessageEvent.class, li);
    }

    public void removeMessageListener(MessageListener li) {
        this.removeListener(MessageEvent.class, li);
    }

    public void addRemovedListener(RemovedListener li) {
        this.addListener(RemovedEvent.class, li);
    }

    public void removeRemovedListener(RemovedListener li) {
        this.removeListener(RemovedEvent.class, li);
    }

    public void addRevivalListener(RevivalListener li) {
        this.addListener(RevivalEvent.class, li);
    }

    public void removeRevivalListener(RevivalListener li) {
        this.removeListener(RevivalEvent.class, li);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.ct.init = false;
        this.ct.destroy();
        this.sender.destroy();
        this.ct = null;
        this.sender = null;
    }
}

