/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.comet4j.core.CometEngine;
import org.comet4j.core.Language;
import org.comet4j.core.event.CometContextEvent;
import org.comet4j.core.exception.DoubleAppModuleKeyException;
import org.comet4j.core.listener.CometContextListener;
import org.comet4j.event.Observable;

public class CometContext
extends Observable<CometContextEvent, CometContextListener> {
    public final String version = "0.1.1";
    private Locale locale = Locale.CHINESE;
    private String workStyle = "auto";
    private CometEngine engine;
    private List<String> appModules = new ArrayList<String>();
    private int timeout = 60000;
    private int cacheExpires = 60000;
    private int cacheFrequency = 60000;
    private int connExpires = 5000;
    private int connFrequency = 5000;
    private boolean debug = false;
    private boolean init = false;
    private ServletContext servletContext;
    private static CometContext instance;

    public void init(ServletContextEvent event) {
        if (this.init) {
            return;
        }
        this.servletContext = event.getServletContext();
        this.loadConfig(this.servletContext);
        this.init = true;
        CometContextEvent e = new CometContextEvent(this, CometContextEvent.INITIALIZED);
        e.setCometContext(this);
        e.setServletContext(event.getServletContext());
        this.fireEvent(e);
        this.log("Comet4J v0.1.1 " + Language.get("InitComplete"));
    }

    public static CometContext getInstance() {
        if (instance == null) {
            instance = new CometContext();
        }
        return instance;
    }

    public void log(String str) {
        if (this.debug) {
            CometContext.instance.servletContext.log(str);
        }
    }

    public void log(String str, Throwable trb) {
        if (this.debug) {
            CometContext.instance.servletContext.log(str, trb);
        }
    }

    public Object createInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object obj = Class.forName(className).newInstance();
        return obj;
    }

    private CometContext() {
        this.addEvent(CometContextEvent.class);
    }

    private void loadConfig(ServletContext ct) {
        String engineStr;
        String languageStr;
        String debugStr;
        String connFrequencyStr;
        String connExpiresStr;
        String cacheFrequencyStr;
        String cacheExpiresStr;
        String timeoutStr;
        String workStyleStr = ct.getInitParameter("Comet.WorkStyle");
        if (workStyleStr != null && !"".equals(workStyleStr.trim()) && ("auto".equals(workStyleStr) || "lpool".equals(workStyleStr) || "stream".equals(workStyleStr))) {
            this.workStyle = workStyleStr;
        }
        if ((timeoutStr = ct.getInitParameter("Comet.Timeout")) != null && !"".equals(timeoutStr.trim())) {
            try {
                this.timeout = Integer.valueOf(timeoutStr);
            }
            catch (Exception e) {
                this.log("\u914d\u7f6e\u9519\u8bef", e);
            }
        }
        if ((cacheExpiresStr = ct.getInitParameter("Comet.CacheExpires")) != null && !"".equals(cacheExpiresStr.trim())) {
            try {
                this.cacheExpires = Integer.valueOf(cacheExpiresStr);
            }
            catch (Exception e) {
                this.log("\u914d\u7f6e\u9519\u8bef", e);
            }
        }
        if ((cacheFrequencyStr = ct.getInitParameter("Comet.CacheFrequency")) != null && !"".equals(cacheFrequencyStr.trim())) {
            try {
                this.cacheFrequency = Integer.valueOf(cacheFrequencyStr);
            }
            catch (Exception e) {
                this.log("\u914d\u7f6e\u9519\u8bef", e);
            }
        }
        if ((connExpiresStr = ct.getInitParameter("Comet.ConnExpires")) != null && !"".equals(connExpiresStr.trim())) {
            try {
                this.connExpires = Integer.valueOf(connExpiresStr);
            }
            catch (Exception e) {
                this.log("\u914d\u7f6e\u9519\u8bef", e);
            }
        }
        if ((connFrequencyStr = ct.getInitParameter("Comet.ConnFrequency")) != null && !"".equals(connFrequencyStr.trim())) {
            try {
                this.connFrequency = Integer.valueOf(connFrequencyStr);
            }
            catch (Exception e) {
                this.log("\u914d\u7f6e\u9519\u8bef", e);
            }
        }
        if ((debugStr = ct.getInitParameter("Comet.Debug")) != null && "true".equals(debugStr.trim())) {
            this.debug = true;
        }
        if ((languageStr = ct.getInitParameter("Comet.Language")) != null && !"".equals(languageStr.trim()) && Locale.ENGLISH.getLanguage().equals(languageStr)) {
            this.locale = Locale.ENGLISH;
        }
        if ((engineStr = ct.getInitParameter("Comet.CometEngine")) != null && !"".equals(engineStr.trim())) {
            try {
                this.engine = (CometEngine)this.createInstance(engineStr);
            }
            catch (Exception e) {
                this.log("\u914d\u7f6e\u9519\u8bef", e);
                this.engine = new CometEngine();
            }
        } else {
            this.engine = new CometEngine();
        }
    }

    public String getVersion() {
        return "0.1.1";
    }

    public String getWorkStyle() {
        return this.workStyle;
    }

    public CometEngine getEngine() {
        return this.engine;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getCacheExpires() {
        return this.cacheExpires;
    }

    public int getConnExpires() {
        return this.connExpires;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isInit() {
        return this.init;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public int getCacheFrequency() {
        return this.cacheFrequency;
    }

    public int getConnFrequency() {
        return this.connFrequency;
    }

    public List<String> getAppModules() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < this.appModules.size()) {
            String key = this.appModules.get(i);
            list.add(key);
            ++i;
        }
        return list;
    }

    public void registChannel(String anAppModule) {
        if (this.appModules.contains(anAppModule)) {
            throw new DoubleAppModuleKeyException(Language.get("DoubleAppModuleKey"));
        }
        this.appModules.add(anAppModule);
    }

    @Override
    public void destroy() {
        this.appModules.clear();
        this.appModules = null;
        this.engine.destroy();
        this.engine = null;
        this.servletContext = null;
        instance = null;
        CometContextEvent e = new CometContextEvent(this, CometContextEvent.DESTROYED);
        this.fireEvent(e);
    }
}

