/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.comet4j.core.CometConnection;
import org.comet4j.core.CometContext;
import org.comet4j.core.CometEngine;
import org.comet4j.event.Observable;

public class CometConnector
extends Observable {
    private final long timespan;
    private final long frequency;
    boolean init = true;
    private Thread cleanner;
    private List<CometConnection> connections = Collections.synchronizedList(new ArrayList());

    public CometConnector(long aTimespan, long aFrequency) {
        this.frequency = aFrequency;
        this.timespan = aTimespan;
        this.cleanner = new Thread((Runnable)new CacheCleaner(), "Comet4J-ConnectorCleaner");
        this.cleanner.setDaemon(true);
        this.cleanner.start();
    }

    CometConnection getConnection(HttpServletRequest request) {
        int i = 0;
        while (i < this.connections.size()) {
            CometConnection conn = this.connections.get(i);
            if (conn.getRequest() == request) {
                return conn;
            }
            ++i;
        }
        return null;
    }

    CometConnection getConnection(String id) {
        int i = 0;
        while (i < this.connections.size()) {
            CometConnection conn = this.connections.get(i);
            if (conn.getId().equals(id)) {
                return conn;
            }
            ++i;
        }
        return null;
    }

    synchronized void addConnection(CometConnection connection) {
        this.connections.add(connection);
    }

    synchronized void removeConnection(CometConnection connection) {
        this.connections.remove(connection);
    }

    synchronized void removeConnection(String id) {
        for (CometConnection c : this.connections) {
            if (!c.getId().equals(id)) continue;
            this.connections.remove(c);
            break;
        }
    }

    boolean contains(String anId) {
        boolean result = false;
        for (CometConnection c : this.connections) {
            if (!c.getId().equals(anId)) continue;
            result = true;
            break;
        }
        return result;
    }

    boolean contains(CometConnection conn) {
        return this.connections.contains(conn);
    }

    List<CometConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void destroy() {
        this.init = false;
        this.cleanner = null;
        this.connections.clear();
        this.connections = null;
    }

    class CacheCleaner
    implements Runnable {
        private final List<CometConnection> toDeleteList = new ArrayList<CometConnection>();

        CacheCleaner() {
        }

        @Override
        public void run() {
            while (CometConnector.this.init) {
                try {
                    CometContext.getInstance().log("\u3010CometDebug\u3011\u5f00\u59cb\u6e05\u7406\u8fde\u63a5");
                    Thread.sleep(CometConnector.this.frequency);
                    this.checkExpires();
                    CometContext.getInstance().log("\u3010CometDebug\u3011\u8fde\u63a5\u6e05\u7406\u5b8c\u6bd5");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void checkExpires() {
            CometEngine engine = CometContext.getInstance().getEngine();
            CometContext.getInstance().log("\u3010CometDebug\u3011\u8fde\u63a5\u6570\u91cf:" + CometConnector.this.connections.size());
            if (!CometConnector.this.connections.isEmpty()) {
                for (CometConnection c : CometConnector.this.connections) {
                    if (c == null) continue;
                    long expireMillis = c.getDyingTime() + CometConnector.this.timespan;
                    if (!"dying".equals(c.getState()) || expireMillis >= System.currentTimeMillis()) continue;
                    this.toDeleteList.add(c);
                }
            }
            if (!this.toDeleteList.isEmpty()) {
                CometContext.getInstance().log("\u3010CometDebug\u3011\u68c0\u6d4b\u5230\u8fc7\u671f\u95f2\u7f6e\u8fde\u63a5" + this.toDeleteList.size() + "\u4e2a");
                for (CometConnection c : this.toDeleteList) {
                    try {
                        CometContext.getInstance().log("\u3010CometDebug\u3011\u79fb\u9664\u95f2\u7f6e\u8fde\u63a5:" + c.getId());
                        engine.remove(c);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                this.toDeleteList.clear();
            }
        }
    }
}

