/*
 * Decompiled with CFR 0.152.
 */
package org.comet4j.core;

import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.comet4j.core.CometContext;
import org.comet4j.core.util.ExplorerUtil;
import org.comet4j.core.util.NetUtil;

public class CometConnection {
    private String id;
    private final String clientIp;
    private final String clientVersion;
    private String workStyle;
    private String state = "alive";
    private long dyingTime = 0L;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public CometConnection(HttpServletRequest anRequest, HttpServletResponse anResponse) {
        this.clientIp = NetUtil.getIpAddr(anRequest);
        this.clientVersion = anRequest.getParameter("cv");
        this.workStyle = CometContext.getInstance().getWorkStyle().equals("auto") ? (ExplorerUtil.canStreamingXHR(anRequest).booleanValue() ? "stream" : "lpool") : CometContext.getInstance().getWorkStyle();
        this.request = anRequest;
        this.response = anResponse;
        this.id = anRequest.getParameter("cid");
        if (this.id == null || "".equals(this.id.trim())) {
            this.id = UUID.randomUUID().toString();
        }
    }

    public String getId() {
        return this.id;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getWorkStyle() {
        return this.workStyle;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public long getDyingTime() {
        return this.dyingTime;
    }

    public void setDyingTime(long dyingTime) {
        this.dyingTime = dyingTime;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void destroy() {
        this.request = null;
        this.response = null;
    }
}

