/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.exportdata.esri.keys.textbackground;

/**
 * The Class LineCalloutKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD line callouts that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class LineCalloutKeys {

    public static final String LINE_CALLOUT = "LineCallout";
    public static final String ANCHOR_POINT = "anchorPoint";
    public static final String LEADER_TOLERANCE = "leaderTolerance";
    public static final String BOTTOM_MARGIN = "bottomMargin";
    public static final String LEFT_MARGIN = "leftMargin";
    public static final String RIGHT_MARGIN = "rightMargin";
    public static final String TOP_MARGIN = "topMargin";
    public static final String ACCENT_BAR = "accentBar";
    public static final String BORDER = "border";
    public static final String MARKER = "marker";
    public static final String TEXT_SYMBOL = "textSymbol";
}
