/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.exportdata.esri.keys.symbols;

/**
 * The Class DotDensityFillSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD dot density maker symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class DotDensityFillSymbolKeys {

    public static final String DOT_DENSITY_FILL_SYMBOL = "DotDensityFillSymbol";
    public static final String DOT_SIZE = "dotSize";
    public static final String DOT_SPACING = "dotSpacing";
    public static final String MASK_GEOMETRY = "maskGeometry";
    public static final String BACKGROUND_COLOUR = "backgroundColour";
    public static final String FILL_COLOUR = "fillColour";
    public static final String OUTLINE = "outline";
    public static final String SYMBOL = "symbol";
    public static final String SYMBOL_LIST = "symbolList";
    public static final String USE_MASKING = "useMasking";
    public static final String FIXED_PLACEMENT = "fixedPlacement";
}
