/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.exportdata.esri.keys.renderer;

/**
 * The Class ClassBreakRendererKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD class break renderer that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class ClassBreakRendererKeys {

    public static final String CLASS_BREAKS_RENDERER = "ClassBreaksRenderer";
    public static final String DEVIATION_INTERVAL = "deviationInterval";
    public static final String EXCLUSION_CLAUSE = "exclusionClause";
    public static final String EXCLUSION_DESCRIPTION = "exclusionDescription";
    public static final String EXCLUSION_LABEL = "exclusionLabel";
    public static final String FLIP_SYMBOLS = "flipSymbols";
    public static final String MAX_SAMPLE_SIZE = "maxSampleSize";
    public static final String CLASSIFICATION_FIELD = "classificationField";
    public static final String MINIMUM_BREAK = "minimumBreak";
    public static final String NORMALISATION_FIELD = "normalisationField";
    public static final String NORMALISATION_FIELD_ALIAS = "normalisationFieldAlias";
    public static final String NORMALISATION_FIELD_TOTAL = "normalisationFieldTotal";
    public static final String NORMALISATION_TYPE = "normalisationType";
    public static final String NORM_FIELD = "normField";
    public static final String SAMPLING_METHOD = "samplingMethod";
    public static final String SIZE_RENDERER_EXPRESSION = "sizeRendererExpression";
    public static final String SIZE_RENDERER_FLAGS = "sizeRendererFlags";
    public static final String SHOW_CLASS_GAPS = "showClassGaps";
    public static final String SHOW_EXCLUSION_GAPS = "showExclusionGaps";
    public static final String SORT_CLASSES_ASCENDING = "sortClassesAscending";
    public static final String SIZE_RENDERER_RANDOM_RANGE_MIN = "sizeRendererRandomRangeMin";
    public static final String SIZE_RENDERER_RANDOM_RANGE_MAX = "sizeRendererRandomRangeMax";
    public static final String WEIGHT = "weight";
    public static final String BACKGROUND_SYMBOL = "backgroundSymbol";
    public static final String EXCLUSION_SYMBOL = "exclusionSymbol";
    public static final String NUMBER_FORMAT = "numberFormat";
    public static final String FIELD_NAME = "name";
    public static final String BREAK = "break";
    public static final String LOW_BREAK = "lowBreak";
    public static final String WHERE_CLAUSE = "whereClause";
    public static final String SYMBOL = "symbol";
    public static final String VALUES = "values";
    public static final String FIELDS = "fields";
}
