/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.symbols;

/**
 * The Class TextSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD text symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class TextSymbolKeys {

    public static final String TEXT_SYMBOL = "TextSymbol";
    public static final String BREAK_CHARACTER = "breakCharacter";
    public static final String CASE = "case";
    public static final String CHARACTER_SPACING = "characterSpacing";
    public static final String CHARACTER_WIDTH = "characterWidth";
    public static final String DIRECTION = "direction";
    public static final String FLIP_ANGLE = "flipAngle";
    public static final String HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String LEADING = "leading";
    public static final String MARGIN = "margin";
    public static final String MASK_SIZE = "maskSize";
    public static final String MASK_STYLE = "maskStyle";
    public static final String POSITION = "position";
    public static final String SHADOW_X_OFFSET = "shadowXOffset";
    public static final String SHADOW_Y_OFFSET = "shadowYOffset";
    public static final String TEXT = "text";
    public static final String WORD_SPACING = "wordSpacing";
    public static final String CJK_CHARACTERS_ROTATION = "CJKCharactersRotation";
    public static final String CLIP = "clip";
    public static final String KERNING = "kerning";
    public static final String RIGHT_TO_LEFT = "rightToLeft";
    public static final String ROTATE_WITH_TRANSFORM = "rotateWithTransform";
    public static final String TYPE_SETTING = "typeSetting";
    public static final String BACKGROUND = "background";
    public static final String FONT = "font";
    public static final String SHADOW_COLOUR = "shadowColour";
    public static final String FILL_SYMBOL = "fillSymbol";
    public static final String MASK_SYMBOL = "maskSymbol";
}
