/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.symbols;

/**
 * The Class PieChartSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD pie chart symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class PieChartSymbolKeys {

    public static final String PIE_CHART_SYMBOL = "PieChartSymbol";
    public static final String BACKGROUND_SYMBOL = "backgroundSymbol";
    public static final String MAX_VALUE = "maxValue";
    public static final String THICKNESS = "thickness";
    public static final String TILT = "tilt";
    public static final String DISPLAY3D = "display3D";
    public static final String CLOCKWISE = "clockwise";
    public static final String USE_OUTLINE = "useOutline";
    public static final String OUTLINE = "outline";
    public static final String VALUE = "value";
    public static final String SYMBOL = "symbol";
    public static final String SYMBOL_LIST = "symbols";
}
