/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.symbols;

/**
 * The Class PictureMarkerSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD picture marker symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class PictureMarkerSymbolKeys {

    public static final String PICTURE_MARKER_SYMBOL = "PictureMarkerSymbol";
    public static final String SWAP_FORE_GROUND_BACK_GROUND_COLOUR = "swapForeGroundBackGroundColour";
    public static final String X_SCALE = "xScale";
    public static final String Y_SCALE = "yScale";
    public static final String ROTATE_WITH_TRANSFORM = "rotateWithTransform";
    public static final String PICTURE = "picture";
    public static final String BACKGROUND_COLOUR = "backgroundColour";
    public static final String BITMAP_TRANSPARENCY_COLOUR = "bitmapTransparencyColour";
}
