/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.symbols;

/**
 * The Class MultiLayerMarkerSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD multi layer marker symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class MultiLayerMarkerSymbolKeys {

    public static final String MULTI_LAYER_MARKER_SYMBOL = "MultiLayerMarkerSymbol";
    public static final String MARKER = "marker";
    public static final String MASK_SIZE = "maskSize";
    public static final String MASK_STYLE = "maskStyle";
}
