/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.symbols;

/**
 * The Class CommonSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD common symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class CommonSymbolKeys {

    public static final String MAP_LEVEL = "mapLevel";
    public static final String ROP2 = "rop2";
    public static final String ANGLE = "angle";
    public static final String SIZE = "size";
    public static final String LENGTH = "length";
    public static final String STYLE = "style";
    public static final String WIDTH = "width";
    public static final String X_OFFSET = "xOffset";
    public static final String Y_OFFSET = "yOffset";
    public static final String COLOUR = "colour";
}
