/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.symbols;

/**
 * The Class CartographicLineSymbolKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD cartographic line symbols that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class CartographicLineSymbolKeys {

    public static final String CARTOGRAPHIC_LINE_SYMBOL = "CartographicLineSymbol";
    public static final String CAP = "cap";
    public static final String JOIN = "join";
    public static final String MITRE_LIMIT = "mitreLimit";
    public static final String POSITION = "position";
    public static final String LINE_DECORATION = "lineDecoration";
    public static final String LINE_START_OFFSET = "lineStartOffset";
    public static final String INTERVAL = "interval";
    public static final String MARK = "mark";
    public static final String GAP = "gap";
    public static final String TEMPLATE = "template";
}
