/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.renderer;

/**
 * The Class ScaleDependentRendererKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD scale dependent renderer that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class ScaleDependentRendererKeys {

    public static final String SCALE_DEPENDENT_RENDERER = "ScaleDependentRenderer";
    public static final String GRADUATED_SYMBOLS = "graduatedSymbols";
    public static final String BREAK = "break";
    public static final String RENDERER = "renderer";
    public static final String RENDERER_LISTS = "renderers";

}
