/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.renderer;

/**
 * The Class DotDensityRendererKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD dot density renderer that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class DotDensityRendererKeys {

    public static final String DOT_DENSITY_RENDERER = "DotDensityRenderer";
    public static final String CONTROL_LAYER_NAME = "controlLayerName";
    public static final String CONTROL_LAYER_BROWSE_NAME = "controlLayerBrowseName";
    public static final String DOT_VALUE = "dotValue";
    public static final String EXCLUSION_CLAUSE = "exclusionClause";
    public static final String EXCLUSION_DESCRIPTION = "exclusionDescription";
    public static final String EXCLUSION_LABEL = "exclusionLabel";
    public static final String EXCLUSION_SYMBOL = "exclusionSymbol";
    public static final String FIELD_ALIAS = "alias";
    public static final String FIELD_NAME = "name";
    public static final String FIELDS = "fields";
    public static final String MAINTAIN_DENSITY_BY = "maintainDensityBy";
    public static final String MAX_DENSITY = "maxDensity";
    public static final String MAX_DENSITY_AREA = "maxDensityArea";
    public static final String MEAN_AREA = "meanArea";
    public static final String MEAN_DENSITY = "meanDensity";
    public static final String MIN_AREA = "minArea";
    public static final String MIN_DENSITY_AREA = "minDensityArea";
    public static final String MAINTAIN_SIZE = "maintainSize";
    public static final String GRADUATED_SYMBOLS = "graduatedSymbols";
    public static final String SHOW_EXCLUSION_CLASS = "showExclusionClass";
    public static final String DOT_DENSITY_SYMBOL = "dotDensitySymbol";

}
