/*
 * SLD Editor - The Open Source Java SLD Editor
 *
 * Copyright (C) 2016, SCISYS UK Limited
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sldeditor.importdata.esri.keys.renderer;

/**
 * The Class BiUniqueValueRendererKeys, contains all the keys used within
 * the intermediate json file to represent an Esri MXD bi-unique value renderer that the
 * SLD Editor can understand.
 *
 * @author Robert Ward (SCISYS)
 */
public class BiUniqueValueRendererKeys {

    public static final String BI_UNIQUE_VALUE_RENDERER = "BiUniqueValueRenderer";
    public static final String MAIN_RENDERER = "mainRenderer";
    public static final String VARIATION_RENDERER = "variationRenderer";
    public static final String GRADUATED_SYMBOLS = "graduatedSymbols";

}
