/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.appbundler;

import org.apache.tools.ant.BuildException;

public class BundleDocument {
    private String name = "editor";
    private String role = "";
    private String icon = null;
    private String[] extensions;
    private boolean isPackage = false;

    private String capitalizeFirst(String string) {
        char[] stringArray = string.toCharArray();
        stringArray[0] = Character.toUpperCase(stringArray[0]);
        return new String(stringArray);
    }

    public void setExtensions(String extensionsList) {
        if (extensionsList == null) {
            throw new BuildException("Extensions can't be null");
        }
        for (String extension : this.extensions = extensionsList.split(",")) {
            extension.trim().toLowerCase();
        }
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRole(String role) {
        this.role = this.capitalizeFirst(role);
    }

    public void setIsPackage(String isPackageString) {
        this.isPackage = isPackageString.trim().equalsIgnoreCase("true");
    }

    public String getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }

    public String getRole() {
        return this.role;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean hasIcon() {
        return this.icon != null;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.getName());
        s.append(" ").append(this.getRole()).append(" ").append(this.getIcon()).append(" ");
        for (String extension : this.extensions) {
            s.append(extension).append(" ");
        }
        return s.toString();
    }
}

