Here’s a **guided task checklist** designed for **Abigail** to work through the key objectives from **Section 1 - Planning** for the **IBM Associate Certified DBA - Db2 12 for z/OS Fundamentals (C1000-122)** exam. This checklist outlines the **learning tasks** along with **assessment checkpoints** to evaluate her progress.

---

### **Section 1: Planning Checklist**

| **Task** | **Learning Objectives** | **Learning Links/Resources** | **Assessment/Checkpoint** |
|----------|-------------------------|-----------------------------|---------------------------|
| **1.1 Connect to DB2 servers** | | | |
| **1.1.1 Understand methods of connecting to DB2 from z/OS** | Explore methods like SPUFI, TSO, CICS, and BATCH | [Common Ways to Interact with Db2 for z/OS](https://www.ibm.com/docs/en/db2-for-zos/12?topic=operations-commonwaysinteract-db2-zos) <br> [Introduction to Db2 for z/OS (PDF)](https://www.ibm.com/docs/en/SSEPEK_12.0.0/pdf/db2z_12_introbook.pdf) | **Checkpoint:** Explain how SPUFI, TSO, and CICS are used for DB2 connections |
| **1.1.2 Understand Attachment facilities** | Learn about CAF, RRSAF, TSO, CICS, IMS, and Universal attachment methods | [DB2 Attachment Facilities](https://www.ibm.com/docs/en/db2-for-zos/12?topic=architecture-db2-attachmentfacilities) <br> [Db2 for z/OS Basic Skills](https://www.ibm.com/docs/en/zos-basic-skills?topic=architecture-db2attachmentfacilities) | **Assessment:** Identify and compare CAF, RRSAF, and CICS |
| **1.1.3 Understand connecting to DB2 from remote systems using TCP/IP** | Study remote connection methods such as ODBC/JDBC and REST | [Connecting DB2 Distributed Database Systems](https://www.ibm.com/docs/en/db2-for-zos/12?topic=db2-connectingdistributeddatabase-systems) <br> [Connecting DB2 via TCP/IP](https://www.ibm.com/docs/en/db2-for-zos/12?topic=db2-connecting-systemstcpip) | **Assessment:** Demonstrate how to connect to DB2 using ODBC/JDBC or REST |
| **1.2 Understand DB2 databases and different types of tables and table spaces** | | | |
| **1.2.1 General knowledge of DB2 databases** | Explore DB2 database structure and objects | [DB2 Database Objects Overview](https://www.ibm.com/docs/en/db2-for-zos/12?topic=concepts-db2-databaseobjects-overview) | **Checkpoint:** Identify different DB2 database objects (e.g., tablespaces, indexes) |
| **1.2.2 Differences between classic Tables and Temporary Tables** | Study the difference between persistent data and temporary tables (CTEs, CGTTs, DGTTs) | [Distinctions between Db2 Base and Temporary Tables](https://www.ibm.com/docs/en/db2-for-zos/12?topic=tables-distinctionsbetweendb2-base-temporary) | **Assessment:** Explain how CGTTs and DGTTs are used in DB2 |
| **1.2.3 Basics of Temporal Tables** | Understand temporal tables: Base table, history table, bitemporal tables | [Temporal Data Versioning in DB2](https://www.ibm.com/docs/en/db2-for-zos/12?topic=tables-temporaldataversioning) | **Assessment:** Create an example Temporal Table with base and history components |
| **1.2.4 Basics of Archive-Enabled Tables** | Explore Archive-enabled tables and their benefits | [Archive-Enabled Tables in DB2](https://www.ibm.com/docs/en/db2-for-zos/12?topic=tables-archiveenabledarchive) | **Checkpoint:** Define and create an Archive-Enabled Table |
| **1.2.5 Understand Table Spaces and their characteristics** | Learn about VSAM, pages, page size, partitions, and compression | [DB2 Table Spaces Overview](https://www.ibm.com/docs/en/db2-for-zos/12?topic=structures-db2-table-spaces) | **Assessment:** Compare VSAM, compression, and partitioning in DB2 table spaces |
| **1.2.6 Differences between types of Table Spaces** | Understand UTS, PBG, PBR, PBR RPN, LOB, and XML table spaces | [DB2 Table Space Types and Characteristics](https://www.ibm.com/docs/en/db2-for-zos/12?topic=spaces-table-spacetypescharacteristics-in-db2-zos) | **Checkpoint:** List the differences between PBG and PBR table spaces |
| **1.2.7 Clone Tables** | Understand Clone Tables and when to use them | [Clone Tables in DB2](https://www.ibm.com/docs/en/db2-for-zos/12?topic=table-exchangingdatabetween-base-clone) <br> [IBM Redbook: Clone Tables (PDF)](https://www.redbooks.ibm.com/redbooks/pdfs/sg247330.pdf) | **Assessment:** Describe a use case for Clone Tables in DB2 |
| **1.2.8 Accelerator-Only Tables and MQTs** | Learn about Accelerator-Only tables and Materialized Query Tables (MQTs) | [Creating Materialized Query Tables](https://www.ibm.com/docs/en/db2-for-zos/12?topic=tables-creatingmaterializedquery) <br> [Using MQTs to Improve SQL](https://www.ibm.com/docs/en/db2-for-zos/12?topic=performanceusingmaterialized-query-tables-improve-sql) | **Checkpoint:** Create a basic MQT in DB2 |
| **1.3 Demonstrate knowledge of subsystem parameters** | | | |
| **1.3.1 Purpose of Subsystem Parameters** | Learn about the role of subsystem parameters and their impact on DB2 operations | [DB2 Subsystem Parameters Overview](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objectssubsystemparameters) | **Checkpoint:** Explain what DSNZPARM is and its purpose in DB2 |
| **1.3.2 Setting and storing parameters** | Understand where subsystem parameters are stored and how to modify them | [Defining DB2 Initialization Parameters](https://www.ibm.com/docs/en/db2-for-zos/12?topic=id1-installation-step-6-definedb2-initialization-parameters-dsntijuz-dsntijua-dsntijum-dsntijul) | **Assessment:** Demonstrate how to change a parameter in DSNZPARM |
| **1.3.4 Check subsystem parameter values** | Learn how to retrieve parameter values using stored procedures | [Checking Subsystem Parameter Values](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objectssubsystemparameters) | **Checkpoint:** Write a stored procedure to extract subsystem parameters |
| **1.4 Understand DB2 Architecture** | | | |
| **1.4.1 How DB2 operates within z/OS** | Learn about DB2 address spaces and their functions | [DB2 in z/OS Environment](https://www.ibm.com/docs/en/db2-for-zos/12?topic=architecture-db2-inzosenvironment) | **Assessment:** Describe the purpose of each DB2 address space |
| **1.4.2 Buffer Pools** | Study the role of buffer pools in DB2 | [DB2 Buffer Pools Overview](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objects-buffer-pools) | **Checkpoint:** Demonstrate how to configure a Buffer Pool |
| **1.4.3 DB2 Catalog and Directory** | Learn the purpose of the DB2 Catalog and Directory | [DB2 Catalog and Directory](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objects-db2-catalog) | **Assessment:** Write a query to retrieve data from the DB2 Catalog |
| **1.4.4 Active and Archive Logs** | Understand how DB2 logs function | [DB2 Active and Archive Logs](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objects-active-archive-logs) | **Checkpoint:** Explain how DB2 manages active and archive logs |
| **1.4.5 Resource Limit Facility (RLF)** | Learn about the Resource Limit Facility and its usage | [DB2 Resource Limit Facility](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objects-resource-limit-facility) | **Assessment:** Configure and monitor RLF in DB2 |
| **1.4.6 Work file Database** | Study the role of the Work file database in DB2 | [DB2 Work File Database](https://www.ibm.com/docs/en/db2-for-zos/12?topic=objects-work-file-database) | **Checkpoint:** Set up a Work file Database in a DB2 environment |
| **1.5 Understand Data Sharing Concepts** | | | |
| **1.5.1 Advantages of DB2 Data Sharing** | Learn about the benefits of data sharing in DB2 | [Advantages of DB2 Data Sharing](https://www.ibm.com/docs/en/db2-for-zos/12?topic=ds-advantages-db2-datasharing) | **Assessment:** Explain how DB2 data sharing improves system availability |
| **1.5.2 Components of a Data Sharing Group** | Study the basic components

 of data sharing: Group Buffer Pool, LOCK structure, SCA | [DB2 Data Sharing Concepts](https://www.ibm.com/docs/en/db2-for-zos/12?topic=concepts-db2-data-sharing) <br> [Redbook: Data Sharing in a Nutshell](https://www.redbooks.ibm.com/abstracts/sg247322.html) | **Checkpoint:** Set up a small DB2 Data Sharing Group in a lab environment |

---

### **Study Tips:**
- Focus on understanding the tasks practically by performing them in a lab environment.
- Use the assessment checkpoints to gauge your understanding and refine your knowledge.
- Regularly review the references provided in each section to dive deeper into complex concepts.

This checklist will help Abigail track her learning progress, test her knowledge, and build hands-on experience with DB2 concepts.
