# IBM Carbon Design System - Pictograms

## Overview

This directory contains the IBM Carbon Design System pictograms. Pictograms are used to communicate ideas quickly and effectively, providing interactivity and simplifying complex concepts. They are essential in various applications including websites, product UIs, signage, events, and merchandise.

## Contents

- `productive/` - Contains productive pictograms suitable for a variety of contexts.
- `expressive/` - Contains expressive pictograms designed for dynamic, impactful use.
- `svg/` - Includes scalable vector graphics files for all pictograms.
- `ai/` - Adobe Illustrator files for all pictograms, allowing for further customization.

## Usage Guidelines

### Productive Pictograms

Productive pictograms are ideal for most contexts and are designed to work across different scales and environments, both physical and digital. They are illustrative and straightforward, making them suitable for conveying complex ideas.

### Expressive Pictograms

Expressive pictograms offer a more dynamic visual option, using gradients, layering, and transparency to create depth and movement. These should be used selectively and only in scenarios that require a strong graphic presence.

## Best Practices

- **Sizing**: Pictograms should be used at a minimum size of 48px. Ensure they are scaled appropriately without distorting their proportions.
- **Alignment**: Pictograms should be optically centered within their boundary box for consistent alignment.
- **Containers**: Use circular or rectangular containers with appropriate padding to maintain visual balance.
- **Clearance**: Maintain a minimum padding of 1/4 of the scaled grid size around pictograms for clarity and legibility.
- **Color**: Ensure pictograms pass color contrast requirements and follow the color family rules to avoid clashes. Use the appropriate color theme for expressive pictograms based on the background color.

## Examples

- **Productive Pictogram Usage**: 
  ![Productive Example](examples/productive_example.svg)
- **Expressive Pictogram Usage**: 
  ![Expressive Example](examples/expressive_example.svg)

## Resources

- [IBM Productive Pictogram Master](link-to-productive-master.ai)
- [IBM Expressive Pictogram Master](link-to-expressive-master.ai)
- [IBM Pictograms (SVG)](link-to-svg-pictograms)
- [IBM Pictograms on GitHub](https://github.com/carbon-design-system/carbon/tree/main/packages/pictograms)

## Contact

For questions or issues, please contact us at [carbon@us.ibm.com](mailto:carbon@us.ibm.com) or open an issue on [GitHub](https://github.com/carbon-design-system/carbon/issues).

---

© SKUNKWORKS. All rights reserved. [Privacy](www.skunkworks.africa/privacy) | [Terms of Use](https://skunkworks.africa/terms.html)
