# Getting Started with Create React App

This project was bootstrapped with [Create React App](https://github.com/facebook/create-react-app).

## Available Scripts

In the project directory, you can run:

### `npm start`

Runs the app in the development mode.\
Open [http://localhost:3000](http://localhost:3000) to view it in your browser.

The page will reload when you make changes.\
You may also see any lint errors in the console.

### `npm test`

Launches the test runner in the interactive watch mode.\
See the section about [running tests](https://facebook.github.io/create-react-app/docs/running-tests) for more information.

### `npm run build`

Builds the app for production to the `build` folder.\
It correctly bundles React in production mode and optimizes the build for the best performance.

The build is minified and the filenames include the hashes.\
Your app is ready to be deployed!

See the section about [deployment](https://facebook.github.io/create-react-app/docs/deployment) for more information.

### `npm run eject`

**Note: this is a one-way operation. Once you `eject`, you can't go back!**

If you aren't satisfied with the build tool and configuration choices, you can `eject` at any time. This command will remove the single build dependency from your project.

Instead, it will copy all the configuration files and the transitive dependencies (webpack, Babel, ESLint, etc) right into your project so you have full control over them. All of the commands except `eject` will still work, but they will point to the copied scripts so you can tweak them. At this point you're on your own.

You don't have to ever use `eject`. The curated feature set is suitable for small and middle deployments, and you shouldn't feel obligated to use this feature. However we understand that this tool wouldn't be useful if you couldn't customize it when you are ready for it.

## Learn More

You can learn more in the [Create React App documentation](https://facebook.github.io/create-react-app/docs/getting-started).

To learn React, check out the [React documentation](https://reactjs.org/).

### Code Splitting

This section has moved here: [https://facebook.github.io/create-react-app/docs/code-splitting](https://facebook.github.io/create-react-app/docs/code-splitting)

### Analyzing the Bundle Size

This section has moved here: [https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size](https://facebook.github.io/create-react-app/docs/analyzing-the-bundle-size)

### Making a Progressive Web App

This section has moved here: [https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app](https://facebook.github.io/create-react-app/docs/making-a-progressive-web-app)

### Advanced Configuration

This section has moved here: [https://facebook.github.io/create-react-app/docs/advanced-configuration](https://facebook.github.io/create-react-app/docs/advanced-configuration)

### Deployment

This section has moved here: [https://facebook.github.io/create-react-app/docs/deployment](https://facebook.github.io/create-react-app/docs/deployment)

### `npm run build` fails to minify

This section has moved here: [https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify](https://facebook.github.io/create-react-app/docs/troubleshooting#npm-run-build-fails-to-minify)
=======
# Skunkworks Web Solutions

![GitHub repo size](https://img.shields.io/github/repo-size/skunkworksza/web)
![GitHub contributors](https://img.shields.io/github/contributors/skunkworksza/web)
![GitHub stars](https://img.shields.io/github/stars/skunkworksza/web?style=social)
![GitHub forks](https://img.shields.io/github/forks/skunkworksza/web?style=social)
![GitHub license](https://img.shields.io/github/license/skunkworksza/web)

Welcome to the Skunkworks Web Solutions repository! This project is designed to showcase innovative technology, education solutions, and placement services. Our repository includes resources, assets, and code implementations for our web presence.

---

## Table of Contents

- [Project Overview](#project-overview)
- [Features](#features)
- [Tech Stack](#tech-stack)
- [Installation](#installation)
- [Usage](#usage)
- [Contributing](#contributing)
- [License](#license)
- [Acknowledgments](#acknowledgments)

---

## Project Overview

![Skunkworks Animation](https://github.com/skunkworksza/web/blob/main/assets/skunkworks_animation.gif)

Skunkworks is at the intersection of education and technology. Our goal is to provide top-tier solutions to businesses looking to harness the power of technology and educational innovation. This repository hosts the code for our web platform, where users can explore our services, products, and strategic partnerships.

---

## Features

| Feature                          | Description                                                                 |
|----------------------------------|-----------------------------------------------------------------------------|
| **Responsive Design**            | Fully responsive design that adapts to various screen sizes and devices.    |
| **Custom Animations**            | Engaging animations to enhance the user experience.                        |
| **Dark Mode**                    | A sleek, modern dark mode design.                                           |
| **IBM Carbon Design System**     | Integration with the IBM Carbon Design System for consistent UI elements.   |
| **Interactive UI Elements**      | Interactive UI elements like dropdowns, modals, and more.                   |
| **Dynamic Content Filtering**    | Real-time search and filtering features for partners and services.          |

---

## Tech Stack

![HTML5](https://img.shields.io/badge/HTML5-%23E34F26.svg?&style=for-the-badge&logo=html5&logoColor=white)
![CSS3](https://img.shields.io/badge/CSS3-%231572B6.svg?&style=for-the-badge&logo=css3&logoColor=white)
![JavaScript](https://img.shields.io/badge/JavaScript-%23F7DF1E.svg?&style=for-the-badge&logo=javascript&logoColor=black)
![Carbon Design System](https://img.shields.io/badge/Carbon%20Design%20System-%231D8B98.svg?&style=for-the-badge&logo=ibm&logoColor=white)

Our project is built using the latest web technologies:

- **HTML5**: The standard markup language for creating web pages.
- **CSS3**: The latest version of the Cascading Style Sheets language.
- **JavaScript**: A versatile programming language for creating dynamic web content.
- **Carbon Design System**: A design system developed by IBM to ensure a consistent design across web platforms.

---

## Installation

To get started with this project, follow these steps:

1. **Clone the repository:**

    ```bash
    git clone https://github.com/skunkworksza/web.git
    ```

2. **Navigate to the project directory:**

    ```bash
    cd web
    ```

3. **Install dependencies:**

    Depending on your development environment, install the necessary dependencies:

    - For frontend dependencies:

      ```bash
      npm install
      ```

4. **Start the development server:**

    ```bash
    npm start
    ```

    The site should now be running at `http://localhost:3000`.

---

## Usage

### Accessing the Website

Once the project is running, you can explore various sections:

- **Home**: Navigate to the homepage for an overview of Skunkworks' offerings.
- **Services**: Discover the wide range of services we provide, from software development to cloud management.
- **Partners**: Learn about our strategic partnerships and find detailed information about each partner.
- **Contact**: Use the contact form to get in touch with us.

### Dynamic Features

- **Search Filtering**: Use the search bar in the Partners section to filter partners by name.
- **Responsive Navigation**: Experience seamless navigation on both desktop and mobile devices.

---

## Contributing

We welcome contributions from the community. To contribute:

1. **Fork the repository:**

    ![GitHub forks](https://img.shields.io/github/forks/skunkworksza/web?style=social)

2. **Create a new branch:**

    ```bash
    git checkout -b feature/your-feature-name
    ```

3. **Make your changes and commit them:**

    ```bash
    git commit -m "Add your commit message here"
    ```

4. **Push your changes to the branch:**

    ```bash
    git push origin feature/your-feature-name
    ```

5. **Create a Pull Request:**

    Go to the repository on GitHub and click "New Pull Request."

---

## License

![GitHub license](https://img.shields.io/github/license/skunkworksza/web)

This project is licensed under the MIT License. See the [LICENSE](https://github.com/skunkworksza/web/blob/main/LICENSE) file for more details.

---

## Acknowledgments

We would like to thank the following:

- **IBM** for the Carbon Design System.
- **Contributors** for their hard work on this project.
- **Community** for providing invaluable feedback.

---

![Skunkworks Logo](https://github.com/skunkworksza/web/blob/main/assets/skunkworks/logo-skunkworks-trans.png)

Visit our [website](https://skunkworks.africa) to learn more about what we do.

---

*Made with ❤️ by the Skunkworks Team.*
