# 100 Days Of Code Log

### Introduction

![Image](./Images/super_64.png) 

Welcome to my #100 Days of Code Log as I take on the challenge to code at least an hour a day for the next 100 days! I am joining the brave new world of learning how to code by starting the School of Code's full stack web development bootcamp. It's full time for the next four months but it's also free. The application process was lengthy but **School of Code only accepted 3% of the 4000 applicants for my cohort.** How could I turn down the opportunity?
#careerchange #womenintech

![Image](./Images/SchoolOfCode.AccurateName_WebSmallSize.jpg)

### Day 1: 26 September 2022

**Today's Progress**: Learned new CSS selectors and practiced them while pair programming with CSS Diner

**Link(s) to work**: [CSS Diner](https://lnkd.in/ePbUsARa) 

**Thoughts:** Made it through my first day at School of Code and loved it. The founder and CEO, Chris Meah, told us today that a more accurate name for School of Code is "Technology Career Intensive Onboarding of Collaborative Creative Problem Solvers." I am excited to start my journey learning to code with all these new people!  

![Image](./Images/SoC.Cohort13.W1D1.ZoomPhoto.jpg)

### Day 2: 27 September 2022

**Today's Progress**: 
- Reviewed and practiced basics of Git and Github.
- Learned about computational thinking:
    - Understand the problem
    - Decompose the problem (break it down into smaller parts)
    - Recognize patterns
    - Abstraction (filter out/ignore the characteristics of the problem that are not needed).
    - Create algorithms
- Problem solved in pairs with flow charts and with puzzles such as Hack the Galaxy.

**Link(s) to work**: [Hack the Galaxy](https://www.hackthegalaxy.dev/) 

### Day 3: 28 September 2022

**Today's Progress**: 
- Started learning JavaScript with The School of Code
- Practiced pair programming in JavaScript using Visual Studio Code, Git, and GitHub

### Day 4: 29 September 2022

**Today's Progress**: 
- Learned about objects and arrays in JavaScript
- Declared objects and arrays, read object and array values, created loops, accessed objects and arrays, and reassigned properties. Completed all these tasks (and more!) by pair programming with my teammate using Visual Studio Code, Gitbash, and Github.
- Plus, I had a fantastic first meeting with my mentor this evening.

### Day 5: 30 September 2022

**Today's Progress**: 
Spent the whole day programming in #javascript and #problemsolving with my teammate in our first School Of Code Hackathon. We built a Rock, Paper, Scissors game from scratch.

**Thoughts:** I enjoy this catchy School of Code hackathon tune that gets us all fired up to take on the day - [Hackathon Fridays.](https://open.spotify.com/track/4oHKTtoYPBhfZBiTtO4OIP?si=s_USUc5gQByXnMzciOlWWQ&utm_source=copy-link&nd=1)

### Day 6: 1 October 2022

**Today's Progress**: 
Today I learned how to fork a repo in GitHub. Then I forked the repos of workshops that I did during the week with my pairing partner. We hadn't finished them during the week, so I forked them so I could work on them independently. 

### Day 7: 2 October 2022

**Today's Progress**: 
Worked on our homework for the weekend which was a GitHub repo covering all the topics on JavaScript that we were taught in our first week at School of Code. 

### Day 8: 3 October 2022

**Today's Progress**: 
- Signed up to #codewars and practiced breaking down problems into solvable chunks and problem solving in pairs. Wrote functions in JavaScript to solve our first kata (challenge) together.
- Learned about the Document Object Model (DOM) in JavaScript - how to create, append, and add elements to the DOM. Attempted to practice what we'd learned with my programming pair partner.

### Day 9: 4 October 2022

**Today's Progress**: 
- Learned about and practiced JavaScript Events in the Document Object Model (DOM).
- Completed another JavaScript kata in Code Wars with my pairing partner.

**Thoughts:** I'm starting to understand what a programmer does other than "works with computers." 😂

![Image](./Images/A%20programmer%20-%20What%20people%20think%20I%20do.jpg)

### Day 10: 5 October 2022

**Today's Progress**:
- Learned about asynchronous #javascript and practiced coding using setTimeout(), setInterval(), and clearInterval(). 
- Practiced coding in #javascript to fetch (with async) resources from Application Programming Interfaces (APIs). I learned how to do this in Python with #codefirstgirls a few months ago so thankfully I already understood the basics. 
- Completed two more katas in #codewars with my programming pair partner.

### Day 11: 6 October 2022

**Today's Progress**:
- Practiced using APIs and extracting data with my pair programming partner.
- Researched Promise.all(), Promise.any(), and Promise.race() in a small group and together we presented our learnings to a larger group of about 40 people

### Day 12: 7 October 2022

**Today's Progress**:
- Fetch Hackathon at School of Code: Made an app, with my pair programming partner, that requested data from a server.
-Used Javascript, CSS, DOM, APIs, async functions, await fetch, await response.json(), document.querySelector, addEventListener, incrementCount, setInterval

### Day 13: 8 October 2022

**Today's Progress**:
Studied and completed exercises on www.w3schools.com on the following topics in JavaScript: Variables, Data Types, Functions, Arrays, Comparison and Logical Operators, For Loops, and HTML DOM

**Link(s) to work**: [W3Schools JavaScript Tutorial](https://www.w3schools.com/js/default.asp)

![Image](./Images/w3schools%20logo.jpg)

### Day 14: 9 October 2022

**Today's Progress**:
Started working on Recap Week 2 workshop from School of Code which covers functions, strings, for loops, arrays, setInterval, clearInterval, and fetch. 

### Day 15: 10 October 2022

**Today's Progress**:
- Attempted to recreate the Google search page in an HTML file (without using any help or resources)
- Learned about Agile, UI (User Interface), and UX (User Experience). I was already familiar with Agile from getting my CompTIA Security+ Certification and starting the Agile Foundations LinkedIn Learning Course this past year, but UI & UX were new to me.  
- Started a newbie challenge on Front End Mentor with my new programming pair partner for this week (https://lnkd.in/eBKh6P4e)
#javascript #programming #agile #uiux

**Thoughts:** My inspirational quote for today. Saw this and it's perfect for me as I start week 3 of coding bootcamp. What new thing will you be brave enough to suck at?

![Image](./Images/BeBraveEnough.jpg)

### Day 16: 11 October 2022

**Today's Progress**:
- Learned about CSS Variables and completed workshop in which we created CSS variables, created a new CSS class and reassigned the CSS variables within that specific class.
- Learned about the User Experience (UX) design process. Tried our hand at it by going through the process steps starting with an idea that we came up with in our small group.
- Attempted to complete another kata (challenge) in #codewars with my pairing partner.
#css #uxdesign

### Day 17: 12 October 2022

**Today's Progress**:

User Interface (UI) design:
* Learned about the elements and principles of UI design.
* Created a low fidelity wireframe on www.figma.com.
* Learned how to generate a Lighthouse report to analyse the accessibility of a web app.
* Played the “Can’t Unsee” game with my programming pair partner where you pick the design that is most correct. https://cantunsee.space/
* Explored colour palettes on https://coolors.co/ and https://paletton.com/

CSS:
* Learned about Specificity in CSS https://lnkd.in/e2aerhUz 
* Also learned how to name CSS classes to make them more specific
#css #ui

![Image](./Images/Figma_whereTeamsDesignBetterProductsTogether.jpg)

### Day 18: 13 October 2022

**Today's Progress**:
* For a UX design group project, we analysed a company’s website and presented our recommendations on how to improve the accessibility of the website.
* CSS (Cascading Style Sheets) is the code that styles web content. Learned about flex, gap, viewpoint height, and viewpoint width in CSS. #css #project #uxdesign #accessibility

### Day 19: 14 October 2022

**Today's Progress**:
Yesterday was Hackathon Friday at School Of Code. We used our newly developed UI/UX skills to design a business landing page. Working together in a pair we:
* Created user stories and user personas to identify users' needs and the problem we needed to solve.
* Made a user journey flow diagram on www.lucidchart.com
* Created low and high-fidelity wireframes using www.figma.com and miro.com
* Chose our colour scheme (via coolors.co) and tested our colours for accessibility. For example, we checked to see if the colours we chose had enough contrast so that people who are colour-blind can still distinguish them.
#uiuxdesign #collaboration

### Day 20: 15 October 2022

**Today's Progress**:

* Continued coding functions, loops, and arrays for the JavaScript Recap workshop with School Of Code.
* One of the many things I love about School of Code is they connect each of us with a mentor who works in the tech industry already and is willing to meet with us 1:1 each week. Arthur is my mentor and he has encouraged me so much already with his tips, advice, and support. He sent me an inspiring quote this morning when I was feeling discouraged and I've been repeating it to myself all day. Thank you, Arthur! 

    ![Image](./Images/CompetitionMeVsMe.jpg)

#javascript #mentoring

### Day 21: 17 October 2022

**Today's Progress**:

* Learned some tips on how to debug code
* Started learning about Back End Development. As part of that, with my new pairing partner, we:
    * installed Node.js
    * Created, imported and exported modules using CommonJS
    * Imported JSON data using CommonJS
* My favourite quote from our coach, Loz, today (paraphrased):  “You can’t really understand something in coding just by watching someone do it. You only become familiar with it that way. You have to do it to understand it.”
#backenddevelopment #nodejs #json #debugging

### Day 22: 18 October 2022

**Today's Progress**:

This week we are learning about backend development. We are using Nodejs (an open-source javascript runtime) to run JavaScript outside the browser.
* Today we learned how to use modules (built-in libraries) to interact with systems.
* We dealt with Node core modules and 3rd party modules like NPM.
* With my pair partner, I practiced:
* Reading and writing to files using the fs module.
* Used uuid (a third party package) to generate unique ids.
* Serialized and deserialized data using the JSON.parse and JSON.stringify methods.
* Started learning how to build a web server using expressjs.com.

#nodejs #backenddevelopment #json #expressjs

![Image](/Images/FrontendDev.Json.BackendDev_FullstackDeveloper.jpg)

### Day 23: 19 October 2022

**Today's Progress**:

* Built a REST API using Node.js and Express
* Created API endpoints allowing the user to create, read, update and delete a resource
* Used Postman to make HTTP requests to test API endpoints. Postman is an API platform for building and using APIs.
* Installed nodemon on NPM. nodemon is a tool that helps develop Node.js based applications by automatically restarting the node application when file changes in the directory are detected.
#api #restapi #nodejs #expressjs #postmanapi

### Day 24: 20 October 2022

**Today's Progress**:

* Learned how to create custom Middleware
* Installed a third party Middleware package called morgan which logs the details of requests.
* Used a built in middleware to serve static files

### Day 25: 21 October 2022

**Today's Progress**:
Hackathon Friday at School of Code on Building a Back End.
Built a REST API from scratch. Set up CRUD routes and got them running in our router. Created model functions and passed them to route handlers in the router.

### Day 26: 23 October 2022

**Today's Progress**:
Forked the repo from the workshop that I did with my programming pair partner last week on Building a REST API using Node.js and Express. Did it again from scratch by myself this time to reinforce what I had learned.
* Created API endpoints allowing the user to create, read, update and delete a resource (Set up CRUD routes in my router so that my server is listening for requests and serves test responses).
* Used Postman to make HTTP requests to test API endpoints.
#middleware #restapi #nodejs #postmanapi #apitesting

![Image](./Images/Full%20Stack%20Developer%20Duck.jpg)

### Day 27: 24 October 2022

**Today's Progress**:
This week, we are learning about the programming language, SQL.
* Structured Query Language (SQL) was designed for managing data that is held in a relational database management system.
* We practiced performing CRUD (Create, Read, Update, Delete) operations in SQL via the website db-fiddle.com. 
#sql #database

### Day 28: 25 October 2022

**Today's Progress**:

* Learned about joining SQL tables, SQL keywords, functions, and how to query a database. I am loving SQL so far.
* My favourite part of today was solving the SQL Murder Mystery with my new programming partners this week (we're pair programming in a team of 3).
#sql #postgresql

### Day 29: 26 October 2022

**Today's Progress**:
Today, we learned how to connect a library to a database.
* Created a Postgres database on ElephantSQL.
* Created Environment variables.
* Learned how to use the dotenv package to load environment variables.
* Connected to the PostgreSQL database using a pool from the pg package and export a query method. This allowed us to execute SQL queries in our models and other files.
* Wrote parameterized queries and tested the APIs with Postman. 
#sql #backendwebdevelopment #postgresql #api

### Day 30: 27 October 2022

**Today's Progress**:
* Solved my first SQL kata on #codewars, with my two programming pair partners for this week, and ranked up to the next level kyu!
* Worked together with four other teammates to research and present to a larger group (of 40+ people) about error handling in Expressjs. As part of this, I learned about the JavaScript statements try{}, catch {}, finally {}, and throw {}.
#javascript #sql #expressjs #postgresql

### Day 31: 28 October 2022

**Today's Progress**:
Hackathon Friday at School Of Code!
Working together in a team of three, we:
* Created a PostgreSQL database, with multiple tables, via ElephantSQL and hosted on the Amazon Web Service (AWS) cloud. 
* Coded environment variables to store database credentials. 
* Created a fully functioning REST API with routes to manage CRUD (Create, Read, Update, Delete) requests to the database and serve responses. 
* Created the models pattern to allow easy interaction with the database. 
#aws #postgresql #restapi #backendwebdevelopment

### Day 32: 30 October 2022

**Today's Progress**:

* Forked the repos of the workshops I worked on last week with my pairing partners so I can continue to work on them on my own.
* Read article on "Getting Started with Node.js ESM" (https://lnkd.in/ePzW94Cp)
* Watched video on "JavaScript Modules: From IIFEs to CommonJS to ES6 Modules" in preparation for our School of Code homework which is to convert our previous workshops to ECMAScript modules (ESM)
(https://lnkd.in/ea3vV7RC)
#github #nodejs #esm #esma #modules #javascript

### Day 33: 31 October 2022

**Today's Progress**:
This week we are learning about testing and modern software engineering practices. We've learned about Jestjs.io, Test-driven development (TDD), and Cypress.io.
* Started converting the code that I wrote in the Build a REST API workshop from CommonJS (CJS) to ECMAScript modules (ESM).
* Used jestjs.io to do basic testing in JavaScript. Jest is a JavaScript Testing Framework. (https://jestjs.io/)

### Day 34: 1 November 2022

**Today's Progress**:

* Read about Test-driven development (TDD) and discussed the pros/cons of TDD.
* Worked on a repo, with my new programming pair partner, to practice Test-driven development (TDD)
* Learned about Cypress.io, a JavaScript-based front-end testing tool built for the modern web. It uses a DOM manipulation technique and operates directly in the browser.
#javascript #tdd #restapi #jest #cypress #ecmascript

### Day 35: 2 November 2022

**Today's Progress**:

* Wrote end-to-end tests using Cypress.io
* Learned how to automate API endpoint testing using the npmjs package superagent (https://lnkd.in/eGCANeVP).
* Decided to go back to basics this evening so I completed the first 20 lessons of the "JavaScript Algorithms and Data Structures" certification on freeCodeCamp
* Tackled more #codewars challenges, with my pairing partner, and ranked up another kyu in JavaScript 😁
#apitesting #cypress #freecodecamp

### Day 36: 3 November 2022

**Today's Progress**:

* Forked the #100daysofcode template and added all my notes from Notion, Tweets, and posts on LinkedIn from my first 35 days of the challenge into this 100 Days of Code log. It's a clear sign of how far I have come in a such a short time since when I started the 100 Days of Code challenge I didn't know how to use Github or VSCode and definitely didn't know how to fork a repo!
* Learned about NoSQL from guest speakers from Couchbase
* With my pair programming partner this week we created our own Kata for Code Wars and the tests required to check our CodeWarrior's solutions. We started with some simple ones which worked fine. Then we started creating a more complicated one but haven't finished it yet.
* We also learned about NoSQL from Couchbase at School of Code today. It was interesting to learn more about it.

**Link(s) to work**: [Free Code Camp](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5) 

### Day 37: 4 November 2022

**Today's Progress**:

* It was Hackathon Friday at School of Code. Our goal was to create testable code for end-to-end testing and API integration testing. We did our End-to-End testing using cypress.io. This included creating a SQL database in ElephantSQL. We did our API testing using jest and supertest. As part of that we wrote the code to test GET and POST. 

### Day 38: 6 November 2022

**Today's Progress**:

* Worked on the week 6 recap homework which was to test a full stack app. 

### Day 39: 7 November 2022

**Today's Progress**:

* This week at School of Code we are covering component-based thinking and frameworks. We are specifically focused on learning how to use React, a JavaScript library used for building advanced user interfaces with a component-based architecture approach. 
* Today we learned about how to create single-page React applications using Create React App. 

![Image](./Images/React%20JS.png)

### Day 40: 8 November 2022

**Today's Progress**:

*  Solved a kata with my pairing partner this week by using JavaScript String split() and the Spread (...) operator. I worked on this particular kata with two different fellow programmers so it felt wonderful to finally solve it! 
* At School of Code today we also learned and practiced coding using:
    * JavaScript array methods such as map(), filter(), some(), every(), and sort().  
    * React components: creating, building and nesting components.

### Day 41: 9 November 2022

**Today's Progress**:

*  Learned about React useState hooks: const [state, setState] = useState(initialState)

### Day 42: 10 November 2022

**Today's Progress**:

* Learned about React lists and keys
* Immutable updates to objects and arrays

**Thoughts:** Every day on my lunch break I try to walk outside. It's great for my health and also [scientifically proven](https://news.stanford.edu/2014/04/24/walking-vs-sitting-042414/) to boost creative thinking by an average of 60 percent! A perfect aid for effective problem solving. 

![Image](./Images/walk_woods.jpg)

### Day 43: 11 November 2022

**Today's Progress**: 
Hackathon Friday at School Of Code. We attempted to use the skills in Reactjs that we've been learning all week to create a "To do list" app. My pairing partner and I decided that we needed to go back to understanding some of the basics of React such as State and Props. As a result, we spent some time going through The Net Ninja's YouTube playlist, [Full React Tutorial](https://www.youtube.com/playlist?list=PL4cUxeGkcC9gZD-Tvwfod2gaISzfRiP9d) and discussing it to make sure we understood it.  

### Day 44: 12 November 2022

**Today's Progress**: 
- Today I learned [How to Transform Your #100DaysOfCode Log Into a Visual Experience](https://www.freecodecamp.org/news/how-to-transform-your-100daysofcode-log-into-a-visual-experience-d048334af8d9/) thanks to this Free Code Camp article. 
- I have subsequently updated this log with images, links, and formatting changes with the help of Markdown code such as:

    *Italic*
    
    **Bold**
    # Heading 1
    ## Heading 2
    [Link](http://a.com)
    ![Image](http://url/a.png)
    > Blockquote
    
     * List
     * List
     * List
    
     1. One
     2. Two
     3. Three

    Horizontal rule:
    ---
    
    `Inline code` with backticks	

    ```
    # code block
    print '3 backticks or'
    print 'indent 4 spaces'
    ```

**Link(s) to resources**: 

[Markdown Tutorial](https://commonmark.org/help/)

[Markdown Tutorial and  Visual Studio Code](https://code.visualstudio.com/docs/languages/markdown#_markdown-preview) 

**Thoughts:** After an intense week, when I was sick with the flu and trying to learn how to code using React JS, I needed a mental break. I found it encouraging and motivating learning how to improve my #100daysofcode log on #github to make it more interesting to read. One of these days I'll hopefully be posting some actual projects, but for now this is a good first step. This quote from Code First Girls was just what I needed to read today:

 ![Image](./Images/ResultsHappenOverTime.jpg)

 ### Day 45: 14 November 2022

**Today's Progress**: 
Learned about pure functions in Reactjs such as useEffect hook. How to fetch data from an API using fetch, useEffect and useState. 

 ### Day 46: 15 November 2022

**Today's Progress**:

Learned about branch management in Git. This included learning some new git commands such as:
* git checkout –b adding-to-remote. This creates a new branch called “adding-to-remote” and switches to it at the same time.

* git checkout main. 

* git push --set-upstream origin newBranchName

We also learned about useReducer which is a hook that allows you to manage your state in React when you want to keep everything under control.

 ### Day 47: 16 November 2022

**Today's Progress**:

Refactored a list with useReducer from The School of Code useReducer Workshop 

Worked on solving a 6kyu kata in Code Wars with my pairing partner. 

Had a refresh on writing test code in preparation for our group project next week. 

Then worked on a React Component Testing workshop.

Learned about Create React App. React Testing Library. 
 

 ### Day 48: 17 November 2022

**Today's Progress**:

Learned more about Agile working, Kanban board, Agile Sprint Iterations, MSCW (Must have, should have, could have, won’t have). etc. 

More review on Testing React Components.

We also conducted and presented Group Research projects on the following topics: 
* Breaking down a project
* Standups and retrospectives
* Estimation, story points, and story point poker
* Sprint planning
* Scrum
* Kanban
* Minimum Viable Product (MVP) and Minimum Loveable Product (MLP)

![Image](./Images/MVP%20and%20MLP.jpg)

 ### Day 49: 19 November 2022

**Today's Progress**:
Continued completing lessons in the JavaScript course on FreeCodeCamp

**Link(s) to work**: [JavaScript Algorithm and Data Structures Certification Course](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5) 

 ### Day 50: 20 November 2022

**Today's Progress**:
Continued working through lessons in the JavaScript course on FreeCodeCamp

**Link(s) to work**: [JavaScript Algorithm and Data Structures Certification Course](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5) 

 ### Day 5: 21 November 2022

 **Today's Progress**:

 This week at School of Code we have been put into groups of four and asked to design a full stack web application which helps to address challenges that bootcampers face while learning remotely. At the end of the week we’ll present our solution to a panel of judges from the industry

One of our goals this week is to use Agile software development practices as we plan, manage, develop, and present our app. Therefore, as a team we first agreed upon our Team Manifesto core items and recovery strategy. We then used a Jamboard and the Disney Ideation Method to brainstorm ideas and then narrow them down. We also completed our user stories, component tree, and low-fidelity wireframe on Figma. 

Before starting my day with School of Code, I watched YouTube instructional videos by Net Ninja about Node.js and React (Using JSON Server and useEffect Dependencies).

![Image](./Images/Jamboard%20Disney%20Ideation%20Method.jpg)
![Image](./Images/Draft%20Low%20Fidelity%20Wireframes.jpg)
![Image](./Images/ComponentTree_DatabasePlanningTable_API.RequestPaths.jpg)

 ### Day 52: 22 November 2022

 **Today's Progress**:

 Today we created a Kanban board on Trello for project management purposes. We then spilt into programming pairs with one pair starting to build the front-end and the other working on the back-end. 

For the back-end, we drew a diagram showing what tables our database would contain and how they join. We also wrote an API planning table for the requests that our back-end would handle. Then we created a PostgreSQL database in railway.app

**Thoughts:** 

This was a very stressful day. Friction that we had in the team yesterday became worse today. One of our colleagues wasn’t in tune with the rest of the team and we found ourselves spending too much energy articulating why we were doing what we agreed upon previously, trying to push forward against a force pushing back. Halfway through the afternoon, it became unbearable and our team reached a breaking point. 

![Image](./Images/Kanban%20Planning%20Board.jpg)

 ### Day 53: 23 November 2022

 **Today's Progress**:

One of the challenges today was connecting the front and back ends that we had developed. We ended up downloading a node.js package called CORS which provides Express middleware and tweaking our React components to respond appropriately. 

We also had a console.log inside an async function which threw us off for a while until we noticed that we needed to move it out. 

We did manage to get two components to work correctly. 

 **Thoughts:** 

 We started today with uncertainty about what was going to happen to our team. We carried on working as a trio but we were still a bit lost, as it was difficult to proceed while things were actively changing. 

It stayed like that up until the mid-afternoon when we officially received a decision from School of Code that from then onwards we would be a team of three. We were clearly behind, but this confirmation gave us what we needed which was certainty. For the rest of the afternoon, the three of us reassessed our situation, rewrote our Recovery plan, and started reconsidering our Minimum Viable Product (MVP) definition.  

![Image](./Images/Our%20App%20at%20the%20end%20of%20Wed.jpg)

### Day 54: 24 November 2022

**Today's Progress**:

This morning at our daily stand-up we decided that our goal by the end of the day was for our app to have a modularized dashboard with clear sections and to be visually well structured. We had to make a few sacrifices on our original plan to reach our revised MVP by the end of the day, such as:
* Testing our app
* Making sure it was accessible and 
* Officially naming our solution.

After revising our MVP, we came up with a colour scheme, modified our low-fidelity wireframe, and discussed our priorities and responsibilities for tasks using our Kanban board on Trello. 

I learned today how to use CSS in React to style components and enjoyed seeing immediate, visual results from my coding.  

At the end of every day this week we met for a retrospective, using the 4Ls technique, to discuss what we Loved, Loathed, Longed For, and Learned that day.

![Image](./Images/Our%20App%20at%20midday%20on%20Thurs.jpg)

### Day 55: 25 November 2022

**Today's Progress**:

Today our focus was on preparing and presenting our App to a panel of judges from the industry. 

Our solution is a dashboard to help bootcampers decompresses after an intense day of learning. It has activities, organized by category, which help to boost wellbeing. You can add to it each day and view your progress based on your goals. It also has a random joke generator. Finally, there’s a prompt to write down things that you are grateful for with a list reminding you of what you have been thankful for in the past. 

*Tools used:* Jamboard, Figma, Trello, VSCode, Git, GitHub, Zoom, Google docs, and Google Slides

*Tech Stack used:* JavaScript ES6, Node.js, Expres.js, React.js, PostgreSQL (ElephantSQL and Railway.app), HTML, and CSS

 **Thoughts:** 

We had unavoidable setbacks this week and then we became a team of three when we were already behind. After that, although our team was smaller we worked as a cohesive team, celebrated our victories however small, and our productivity level shot through the roof. 

The big take away for us is how important mindset and a positive attitude is when facing challenges as a team. We had a unique chance to experience the type of obstacles one might face in a real work environment. It was important for us to keep moving forward and to stay agile. 

This week, we lived out the following values from The Agile Manifesto:
* Responding to change over following a plan
* Individual and interactions over processes and tools and 
* Working software over comprehensive documents 

I am incredibly grateful to my teammates on this project, Gabe and Milly. They were supportive, encouraging, kind, flexible, resilient, and brilliant at coding too! We faced huge challenges but overcame them together, working as a cohesive team with a positive attitude. At the end of the week we presented to the judges a functioning app which was coded almost entirely in a day. What an achievement!

#### Feedback from the judges on our week-long group project:

>You guys showed a solid understanding of the fundamental principals of software design and the software development life cycle in general. 

>Really good job making a positive situation out of a tough week.

>Unfortunate journey given the problems they had with a team member, but still delivered on the project which is impressive.

>Naturally, your end product was less developed than others that we saw, but that is absolutely understandable when we take into consideration the troubles that you had in the week (and was completely unavoidable!) What you did present though was **genuinely impressive** for what is essentially a day's work. 


![Image](./Images/Our%20App%20on%20Fri%20morning.jpg)

### Day 56: 28 November 2022

**Today's Progress**:
Before SoC started this morning, I read in the Reactjs docs about State to reinforce my understanding.

At School of Code today, we spent the morning in our project groups from last week holding our Sprint Retrospective. We created a Trello board to discuss what went well, what needs improvement, and action items for the future. I also learned how to add a voting option for the Trello cards so we could have a team vote on the three ideas we’d like to see at the top of the list. 

In the afternoon, we focused on Code Reviews. We read up on code review guidelines and then met with another team from last week to review their code (and vice versa). 

**Links to some resources used**: 

[State: A Component's Memory](https://beta.reactjs.org/learn/state-a-components-memory) 

[Retrospective basics from Atlassian](https://www.atlassian.com/wac/team-playbook/plays/retrospective?)

### Day 57: 29 November 2022

**Today's Progress**:
Today we started implementing some changes to the code in our project based on the feedback that we received from our peer code review yesterday.
* We learned how to use the JSDoc Tool for adding documentation comments to our code. 
* We simplified the code as much as possible. 
* We learned about the readme.so tool to create documentation for our front and back ends.
* We practiced reviewing code in a branch before approving it to be merged with the main branch in Github. My teammate, Milly, created tests using Cypress and tested some of the components from our project. She wrote the test in a branch file, so when she went to merge it to our main file, she added Gabe and me as reviewers in GitHub so we could practice how it works. Then we each went through it, making comments, modifying any code, and then merging it. 
* I also learned about the "git mv" feature to fix a file name on our main branch which kept reverting back to the wrong name. 

 **Thoughts:** 
I really enjoyed today and feel that I learned a lot. As we were reviewing our code, I tried to explain out loud to my teammates what the code was doing. My teammates were brilliant at explaining anything I didn't understand. They are also helping me to start using the correct syntax. Often I understand and can explain the logic of the code but don't remember the correct technical words to use (such as "rendering a component"). 

**Links to resources**: [JSDoc Tool for adding documentation comments](https://jsdoc.app/about-getting-started.html) and [README markdown editor ](https://readme.so/)

*Cypress Testing a component of our app:*
![Image](./Images/CypressTestofGratitudeComponent.jpg)


*GitHub Network Graph of our commits:*
![Image](./Images/NetworkGraph.jpg)

### Day 58: 30 November 2022

**Today's Progress**:
Created README docs for the frontend and backend repos from our group project from last week. Finished writing JSDoc comments in the code for both the frontend and backend repos. As we went through the code again, it was good to review my understanding of how each part connects and communicates with other parts from the front to the backend. 

### Day 59: 1 December 2022

**Today's Progress**:
Today we learned about Identity as a Service (IDaaS), a cloud-based authentication built and operated by a third-party provider. Examples of IDaaS providers are Auth0, AWS Cognito, Firebase, and Supabase. In the afternoon I started trying to set up authentication on the frontend of a React project. I used [Autho0](https://auth0.com/) to integrate the following features within a single-page React app:
* Allow users to login
* Allow users to log out
* If a user is logged in, display their information (e.g. name, email, image URL)

### Day 60: 2 December 2022

**Today's Progress**:
Today I continued working on yesterday's project. I learned how to call an API that validates ourJSON Web Tokens. The aim was to get our user's metadata to display on the page and we managed to do it!

Next, we worked on protecting the backend of our React project. We created an API that supports the following routes:  
* GET /api/public
* GET /api/private
* GET /api/private-scoped

It took ages to figure out how to get the last one (private-scoped) to work but we finally managed to find and tick the right boxes in the Auth0 API settings to get it to work (hint: check the Machine to Machine Applications tab).

In the last few minutes of the day, I built a React app from scratch that uses authentication via Auth0. The one bit I haven't figure out yet is how to code it so that you can only access the app once you have logged in. Right now it's showing on the main page and also when you log in. Will tackle that problem another day. 

Today I also added a demo video to the README files for our week 9 Group Project:
[Globally Scoped Project Frontend](https://github.com/SchoolOfCode/bc13_w9_project-frontend-globally-scoped)
and
[Globally Scoped Project Backend](https://github.com/SchoolOfCode/bc13_w9_project-backend-globally-scoped)

### Day 61: 5 December 2022

**Today's Progress**:
Learned and practiced how to deploy React app projects via [Netlify](https://app.netlify.com/). 

### Day 62: 6 December 2022

**Today's Progress**:
Learned and practiced how to deploy a backend environment using [Render](https://render.com/). Then deployed the related frontend (a React app shopping list) via [Netlify](https://app.netlify.com/). 

The highlight for me today was learning how to set up my React App from last Friday (2 Dec) so that the user has to log in first before they had access to the app, their user info and their user metadata. 

To do this, we leveraged the Identity as a Service (IDaaS), Auth0 React SDK. It is a JavaScript library for implementing authentication and authorization in React. We used the useAuth0 hook in our components to access authentication states such as (isAuthenticated and user), authentication methods such as logout, as well as the logical conjunction (&&) operator to do it.

In the morning I also completed some katas on Code Wars with my pairing partner for an hour. We started going through [Katas list of Training JS series](https://github.com/myjinxin2015/Katas-list-of-Training-JS-series) together. 

### Day 63: 7 December 2022

**Today's Progress**:
Today we learned about a React Hook called useContext that lets you read and subscribe to context from your component.

**Links to resources**: 
[React Hooks: useContext](https://beta.reactjs.org/apis/react/useContext)  and [Passing Data Deeply with Context](https://beta.reactjs.org/learn/passing-data-deeply-with-context)

### Day 64: 8 December 2022

**Today's Progress**:
This morning I completed a CodeWars kata with my pairing partners. Then we worked on completing the workshop from yesterday on custom hooks. 

In the afternoon, we learned more about [Couchbase](https://www.couchbase.com/). Couchbase is a DataBase as a Service (DBaaS) provider. 

### Day 65: 9 December 2022

**Today's Progress**:
Hackathon Friday at School of Code. Our challenge was to ideate, plan, and build a full stack app that included:
* Deployed front and back ends that talk to each other
* Use of the useContext hook somewhere in your app
* Use of at least one custom hook somewhere in your app

It was a huge challenge to do in just 5 hours. We managed the first task and had started on the second one when it was time to present at the end of day. 

 **Thoughts:** 
How do you maintain motivation to keep going when you are worn out? After twelve weeks of intensive learning with the School Of Code boot camp, I took the advice that Women In Technology (WIT) shared below so I can press on to keep going in my #100daysofcodechallenge.

![Image](./Images/HowToMaintainMotivation.jpg)

### Day 66: 13 December 2022

**Today's Progress**:
We started learning about TypeScript today. Here's a little code snippet from the first part of our workshop practicing writing in TypeScript:

**Code Snippets**

```tsx
/* TASK 1.1: declare and initialize a boolean variable */
let isTrue: boolean = true;

/* declare and initialize a string variable */
let myName: string = "Stephanie";

/* declare and initialize a number */
let myAge: number = 32;

/* declare and initialize an array of booleans */
let isVeryTrue: boolean[] = [true, false];

/* declare and initialize an array of strings */
let stringArray: string[] = ["2", "b", "6"];

/* TASK 1.2: Declare and implement a function which takes in two numbers and 
returns their sum.*/
function totalSum(a: number, b: number) {
  return (a + b);
}
console.log(totalSum(2, 8));

/* TASK 1.3: Declare a new type that describes an object containing the keys and 
types below: 
amount: a number
uniqueId: a string
isValid: a boolean
addressLines: an array of strings */

type Data = {
    amount: number;
    uniqueID: string;
    isValid: boolean;
    addressLines: string[];
};

function getData(personalData: Data) {
    return personalData.uniqueID; 
}
console.log(getData(
    { 
    amount: 15, 
    uniqueID: "Sam", 
    isValid: true,
    addressLines: ["1 Park Lane", "2 Falcon Way"] 
    }
    ));

    /* TASK 1.4: Declare a new type which is any one of: "BLUE" or "YELLOW" */
    function setColor(color: string | string ) {
        return "My favourite color is " + color;
    }
    console.log(setColor("BLUE"));

    console.log(setColor("YELLOW"));
```
### Day 67: 14 December 2022

**Today's Progress**:
Learned how to convert React JavaScript to TypeScript. Spent the day with my pairing partner converting all the .js components of a “to-do list” React app to .tsx components. 

### Day 68: 15 December 2022

**Today's Progress**:
Today we learned how to use VS Code to debug code. We also learned a bit more about how to code using TypeScript.  

Tomorrow I have a progress interview. Therefore, I also took some time to review the code from our week 9 group project to make sure I understood it. My programming pair partner for this week, Beatrice, was kind enough to let me practice explaining it to her. She asked me some good questions about it too. 

In the evening I met with my mentor, Arthur, and he helped me review and practice answering common interview questions that someone might be asked when interviewing for a software development job. 

### Day 69: 16th December 2022

**Today's Progress**:
Hackathon Friday at School of Code. With our programming pair partner our challenge was to build a weather checker app using Typescript and React. The user needed to be able to input the name of a city and have weather information about that city added to the page. 

We first made a plan then created a component tree diagram in Miro before we started any coding. I had my progress interview in the middle of the day so Beatrice did a large chunk of the coding during the 1 1/2 hours that I was away for my interview. 

In the last bit of time we had at the end of the day we managed to add a background image and weather icon which reflects the city's weather. 

![Image](./Images/London.TypeScript.React.Hackathon.jpg)

### Day 70: 17th December 2022

**Today's Progress**:
Continued to work through more of the Free Code Camp curriculum for the JavaScript Algorithms and Data Structures Certification. Also started watching Dave Grey's Node.js Tutorials on YouTube.

 **Link(s) to work**: [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5) 


 **Link(s) to resources**: [Node.js Tutorials](https://youtube.com/playlist?list=PL0Zuz27SZ-6PFkIxaJ6Xx_X46avTM1aYw)

 **Thoughts:** 
I have now completed the first twelve weeks of the School of Code (SoC) boot camp. When I started, the only coding I knew how to do was some basic Python from the Code First Girls intro course I took last summer. I didn't know any JavaScript, HTML, or CSS. I didn't know how to use Git or GitHub. I had never heard of a PERN Stack much less how to code using PostgreSQL, Express, React, and NodeJS. In these past twelve weeks, we have been taught a massive amount and I've worked incredibly hard - day, night, and every weekend. It's amazing how much I have learned and grown in just three months.

I still feel so behind though in my comprehension and was feeling quite discouraged yesterday. However, Bee helped me gain some perspective by pointing out that before our SoC boot camp started, she spent two months going through some Udemy courses on JavaScript (while also working). At our SoC bootcamp we only spent 3 days learning what she had spent a full 2 months learning on her own. 

I really enjoyed going through this basic JavaScript course on Free Code Camp today. It's so much easier on my brain. I'm learning things that so many others on my SoC course already knew before they started. Some of these concepts look familiar to me because we have used them in our coding at SoC but I had not learned them yet. 

This post encouraged me too:

![Image](./Images/ClimbingStepsJourney.jpg)

### Day 71: 19th December 2022

**Today's Progress**: 
This morning David Adams, Site Reliability Engineer (SRE) at ManyPets, gave us a interesting, practical presentation about the Continuous Integration and Continuous Delivery (CI/CD) cycle.

In the afternoon, I  met my new programming pair partner for the week and together we started learning more about Amazon Web Services' many products. We created a new AWS account and followed the Amplify with React tutorial
to create a full stack application with the AWS Amplify Comment Line Interface (CLI). We didn’t have time today to add authentication to the app or deploy and host it but managed to get everything else done from the tutorial.  

 **Link(s) to resources**: [Amplify with React Tutorial](https://docs.amplify.aws/start/q/integration/react/)

 ### Day 72: 20th December 2022

**Today's Progress**: 
This afternoon we did group research projects on Nextjs, Gatsby, and Remix. Each programming pair was assigned one of the React frameworks to research. We later presented to groups who  looked at the other two frameworks. My programming partner and I were assigned to research Remix. As part of our research we created a Remix project from scratch. Our group presentations at the end led to some interesting discussions about which framework was better to use depending on your needs. 

In the morning I also solved a CodeWars kata with my programming pair partner for this week. 

 **Link(s) to resources**: [Nextjs](https://nextjs.org/docs), 
[Gatsby](https://www.gatsbyjs.com/docs/tutorial/part-0/), and 
[Remix](https://remix.run/docs/en/v1/tutorials/blog)

 ### Day 73: 21th December 2022

**Today's Progress**: 
Continuted watching Dave Grey's Node.js Tutorials on YouTube and writing the code along with the tutorial. 

**Link(s) to resources**: [Node.js Tutorials](https://youtube.com/playlist?list=PL0Zuz27SZ-6PFkIxaJ6Xx_X46avTM1aYw)

### Day 74: 24th December 2022

**Today's Progress**: 
Continued to work through more of the Free Code Camp curriculum for the JavaScript Algorithms and Data Structures Certification. 

 **Link(s) to work**: [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5)  

 ### Day 75: 27th December 2022

**Today's Progress**: 
Continued to work through more of the Free Code Camp curriculum for the JavaScript Algorithms and Data Structures Certification. Also watched more of Dave Grey's Node.js Tutorial playlist on YouTube.

 **Link to work**: [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5)

 **Link to resources**: [Node.js Tutorials](https://youtube.com/playlist?list=PL0Zuz27SZ-6PFkIxaJ6Xx_X46avTM1aYw)

 ### Day 76: 28th December 2022

**Today's Progress**: 
Continued to work through more of the Free Code Camp curriculum for the JavaScript Algorithms and Data Structures Certification.

**Link to work**: [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5)

 ### Day 77: 29th December 2022

**Today's Progress**:
Continued to work through more of the Free Code Camp curriculum for the JavaScript Algorithms and Data Structures Certification.

**Link to work**: [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5)

 ### Day 78: 1st January 2023

**Today's Progress**:
Continued to work through more of the Free Code Camp curriculum for the JavaScript Algorithms and Data Structures Certification.

**Link to work**: [JavaScript Algorithms and Data Structures Certification](https://www.freecodecamp.org/fcc1c4bc12a-0732-4d31-8cf5-256370ff73f5)

### Day 79: 3rd January 2023 - FINAL GROUP PROJECT

**Today's Progress**:

This month at School of Code we have been put into teams of six people and tasked with designing a full stack web application which solves a real-world problem. The aim of this month-long project is to help us experience what it’s like to be part of a real-life engineering team building a practical solution for our end users. 

Today as a team we accomplished the following:
* Wrote and agreed upon our Team Manifesto which includes core items like how to work together and our recovery strategy.
* Discussed the strengths, preferences, weaknesses and goals of each person on the team and how we can work together to maximize each other’s potential. 
* Brainstormed about a problem that we want to solve as a team. Considered how we could use technology to solve a problem affecting our end users. We used a Figma Jamboard that I created and the Disney Ideation Method. 
* Discussed roles and responsibilities within the team. I volunteered to serve at the scrum coach for the week and I created a Trello board to help with our planning and prioritising. 

**Key Principles from our Team Manifesto:**

![Final Team Manifesto](Images/TeamManifestoTopFrugalFanatics(3Jan2023).jpg)

**Thoughts:** 

Today was our first day back after a two-week holiday and the first thing we did was find out who our teammates are for this final project. I have only worked with one of my five teammates (pair programming) before but know some of them as we’re in a larger 40 person group (A) on the bootcamp. I am very excited to about our team. They are all great people and we have huge potential. 

![Frugal Fanatics Team Photo](Images/FrugalFanaticsTeamPhoto(6Jan2023).jpg)

### Day 80: 4th January 2023

**Today's Progress**:

Disney Ideation Method:
* Today we continued putting ideas through the Disney Ideation Rooms. Yesterday we had come up with ideas of 23 problems that we could solve. Therefore, we used dot voting to narrow them down to 6 ideas. 
* Then we brainstormed possible solutions for the 6 problems. After that, we voted again to narrow it down to 3 potential problems we could solve with our app. 
* We took those three ideas through the Realist and Critic rooms then voted again to decide on the one problem we would aim to solve: the cost of living crisis. 

![Brainstorming using Disney Ideation Method](Images/Disney%20Ideation%20Method%20-%20Realist%20and%20Critic%20rooms.jpg)

User Stories:
* Once we decided on the problem we wanted to help solve, we each drafted a user stories. 
* We decided that our users wanted to get out of debt and learn how to budget. 

![User Stories](Images/User%20Stories.jpg)

#### *Our solution will be an app which provides a customized budget tool with tips and links to external resources for additional help.*

The Unique Selling Point (USP) of our app will be:
* Accessible to everyone (including people with disabilities)
* Light-hearted and gamified. Fun and creative, helping to lower stress. 

Now that we had agreed on an idea for our app we decided on a team name: *Frugal Fanatics*

![Image](./Images/IncreaseSavings.jpg)

### Day 81: 5th January 2023

**Today's Progress**:
Today we began to define our Minimum Viable Product (MVP) and to design a basic low fidelity wireframe based on our requirements.

We also created a Market Research Survey on Google docs. I shared it on LinkedIn, Facebook, and on the School of Code Slack channels to gather as much feedback as possible.

**Link to our survey**: [Frugal Fanatics Market Research Survey](https://forms.gle/5kotbG6x2PodcPJHA)

### Day 82: 6th January 2023

**Today's Progress**:

We had 74 people complete our Market Research Survey! *The results led us to quickly pivot our MVP based on the user feedback.* 

It showed that the vast majority of those surveyed have increased stress and anxiety as a result of the cost of living crisis. This led us to decide to add a component to the app which would help them, such as a mindfulness element. 

Users also indicated that they were keen to have a budgeting tool as well as a tracker for their expenses and saving. However, not many indicated that they needed help with managing debt. So we decided to shelve the debt tracker for the time being. 

Today we also finished our low fidelity wireframes. 

![MVP for Sprint 1](Images/MVP%20for%20Sprint%201.jpg)

### Day 83: 9th January 2023

**Today's Progress**:

We made final decisions on our Tech stack today, including using relational databases over non-relational. We also decided on our Git branching strategy (GitHub Flow) and practiced it using a practice repo. We will be protecting the main branch and deploying after every sprint. In addtion, we agreed on our colour scheme. 

**Tech Stack:**

![Tech Stack](Images/TechStackChosen.jpg)

**Colour Scheme:**

![Color Scheme](Images/Color%20scheme%20for%20Frugal%20Fanatics%20project.png)

### Day 84: 10th January 2023

**Today's Progress**:

We finally started coding today! 
* This morning I represented our team at the Stand up of Stand ups. 
* In our morning team meeting we agreed on a rota so that we will all have a chance to work on the back and front end and also to pair programme with each person on the team. 
* We created front and back end repos. I installed the relevant dependencies for our front end repo (Nextjs, Tailwindcss, Postcss, Autoprefixer, Heroicons, Headlessui, and Prettier). I also installed the Tailwindcss Intellisense VSCode Extension for uniformity and help when creating inline CSS. 
* We decided on the naming convention for the files and folder layout. Instead of using index.js we will name each file by the component for example DashboardLayout.js

**Team Rota:**

![Team Rota](Images/Team%20Rota%20Frugal%20Fanatics.jpg)

Other work we did today as a team:

On the Front End: 
* Created the desktop/mobile sidebar and navbar.
* Started sourcing doughnut charts to display our savings data.

On the Back End: 
* Completed setting up back end. Installed dependencies and created index.js/app.js. 
* Created a database in elephantSQL after playing with data on dbfiddle
* Updated Entity Relationship Diagram (ERD) for the database with new details


**Entity Relationship Diagram**
![Entity Relationship Diagram](Images/EntityRelationshipDiagram(ERD)%20for%20databse.jpg)

### Day 85: 11th January 2023

**Today's Progress**:

We merged all the front and back end branches this morning so we are moving forward on a uniform copy. With my pair partner for the day I set up the back end to include 3 models and 3 routes connected to the database tables on elephantSQL. 

Today’s front end teams:
* Created form components and styled to match the wireframes. 
* Set up the dashboard data with a hard coded object that will be populated by the back end.

### Day 86: 12th January 2023

**Today's Progress**:
Today I was working with a different partner on the back end. We debugged and successfully tested GET requests for userRoutes, expensesRoutes, and savingsRoutes via Postman. We also successfully debugged and tested POST for userRoutes. 

I drafted the README doc for our back end repo. 

We also deployed the back end to Render: [Users Table](https://frugalfanaticsbackend.onrender.com/api/userRoutes), [Expenses Table](https://frugalfanaticsbackend.onrender.com/api/expensesRoutes), and [Savings Table](https://frugalfanaticsbackend.onrender.com/api/savingsRoutes)

### Day 87: 13th January 2023

**Today's Progress**:
This morning, with my partner, I finished debugging and testing the back-end GET and POST requests for users, expenses and savings. 

We then prepared our group presentation for our mid-month product demos which we showed in the afternoon to everyone in Group A (around 40 people). We received some helpful feedback from the coaches which we will bring into our planning next week.  

### Day 88: 14th January 2023

**Today's Progress**:
Worked on documenting our teams progress since we started, including taking screen shots and recoding videos which demonstrate our app as it is today. 

![Onboarding Income](Images/Onboarding1_Income(14Jan2023).jpg)
![Onboarding Expenses](Images/Onboarding2_Expenses(14Jan2023).jpg)
![Onboarding Savings](Images/Onboarding3_Savings(14Jan2023).jpg)
![Overview](Images/OverviewPage(14Jan2023).jpg)
![Budgeting Page](Images/BudgetingPage(14Jan2023).jpg)
![Savings Page](Images/SavingsPage(14Jan2023).jpg)

### Day 89: 16th January 2023

**Today's Progress**:
Today we discussed our goals for our next week-long sprint which starts today. Our top priority is to get the front and back end connected. Right now we have a fully funtional back end with GET and POST requests working. The front end is working too but with dummy data that's been hard coded. 

My programming pair partner for today and I worked on cleaning up the code on the front end: breaking down the components into groups and updating the terminology to match the database. At the end of the day, we met as a team of six again and decided that tomorrow morning four of us will work together to agree upon how we want to connect the front and back end so we are not doing separate things (on the front and back end) that don't end up working together. 

We are also considering at what stage we will implement authentication - at the start before completing the budget information form, or only after that form has been completed but before displaying the custom dashboard which is populated with data from the completed form.  

### Day 90: 17th January 2023 

**Today's Progress**:
Last week, we created a custom Express.js server on the back end and built our front end using the Next.js React framework. We realised this week that there are some challenges with connecting these two. Therefore, today we explored some other options for the back end that would work better with Next.js, such as Supabase. Some of the features that Supabase offers are a Postgres database and authentication. It is also open-source. We spent today discussing, researching and experimenting to determine the best option to use.  While I was doing this with a few of my teammates, two others from our group worked together to get the front end deployed on Netlify as well. When we divide and conquer we make great progress together as a team! 

**Link(s) to resources**: [Supabase](https://frugalfanaticsbackend.onrender.com/api/userRoutes)


### Day 91: 18th January 2023 

**Today's Progress**:
Yesterday afternoon we created a test branch off our main front end branch and scaled it down to test whether we could get Supabase working with authentication and our simplified Next.js app. We managed to get it working so decided to go with Supabase + Next.js instead of elephantSQL and Express.js with Next.js. It was easy to quickly replicate our Postgres database in Supabase. Then we started refactoring our code on the front end using Supabase. It's been slow going as it's all new to us. Up to this point, the only authentication that we've learned in the bootcamp was how to use Auth0 as a login for a simple static site. Our app for this project, however, requires authentication and authorization when accessing the database and it's also a dynamic website.  

We also spent time as a team today discussing how we can make our app fun and gamefied since that's one of our unique selling points. We have some great ideas which we hope to implement once we finish connecting the front and back ends. 

Two of our team worked together today updating the front end to make it accessible. By the end of the day, Google's Lighthouse accessibility audit was showing all green with 100% ratings. 

This evening I spent some time reading through documentation on Next.js and supabase so I have a better understanding of how they work. I feel more confident now going into tomorrow. 

**Tech Stack starting week 3**

![Alt text](Images/Tech%20Stack%20week%203.jpg)

**Accessibility - Lighthouse Audit**

![Accessibility:Lighthouse Audit Overview page](Images/LighthouseAudit_Overview_AFTER.jpg)
![Accessibility:Lighthouse Audit Budgeting page](Images/LighthouseAudit_Budgeting_AFTER.jpg)
![Accessibility:Lighthouse Audit Savings page](Images/LighthouseAudit_Savings_AFTER.jpg)


### Day 92: 19th January 2023 

**Today's Progress**:
Discussed our goals first thing this morning. Decided to make dark mode the default mode for our app as we all think it looks better (based on our high fidelity wireframes). 

Then we split into two teams for the day. My team continued refactoring the code on our front end to add authentication with supabase. It was slow going but we made some good progress. 

The second team worked on making the savings page of our app look more fun with icons and colors. 

We also had the opportunity to hear from two companies that are hiring for roles that we can apply for when we finish the bootcamp. One of them is hosting a hackathon next week for potential applicants. Exciting!

**High Fidelity Wireframe dark mode**

![High Fidelity Wireframe dark mode](Images/High%20Fidelity%20Wireframe%20dark%20mode.jpg)

### Day 93: 20th January 2023 

**Today's Progress**:
Today we agreed on the name of our app: frumo (short for frugal money). 

My pairing partner and I started working on the dark mode version of our app. I enjoyed learning how to use Tailwind CSS for the first time.

We also prepared and gave a presentation to the coaches and other teams in Group A summarizing what we accomplished this week. 

**Sprint goals week 3 and accomplishments:**

![Sprint goals week 3](Images/Sprint%20goals%20week%203%20(20Jan2023).jpg)

**Savings page with features added to make it more fun:**

![AGamefied savings page](Images/Savings%20page%20end%20of%20week%203%20(20Jan2023).jpg)


### Day 94: 23th January 2023 

**Today's Progress**:
I spent most of today with my pairing partner updating the code so that our app runs by default in dark mode and the dark mode matches our high fidelity wireframe. It was a lot of grunt work but the end result looks good. It also helped me to get more familiar with the interworking of the code on the front end, Tailwindcss, and Figma. We also tried adding a celebration animation to the app for when a goal is achieved to make the app more fun. 

Another pairing group from our team worked on the landing page. The third pairing group from our team continued working on the savings page. 

At the end of today, the team decided that I should be the scrum leader for the rest of our time working together. I served as the scrum leader our first week and then we started changing to a new scrum leader every two days. Even though half the team initially weren't keen on being a scrum leader, we thought everyone should have the chance to lead because it would be a good experience. It was also interesting to see people's different leadership styles. 

**frumo app in dark mode:**

![Landing Page](Images/LandingPage(23Jan2023).jpg)

![Sign Up Page](Images/SignUpPage(23Jan2023).jpg)

![Sign In Page](Images/SignInPage(23Jan2023).jpg)

![Form Income Page](Images/FormIncomePage(23Jan2023).jpg)

![Form Expenses Page](Images/FormExpensesPage(23Jan2023).jpg)

![Form Savings Page](Images/FormSavingsPage(23Jan2023).jpg)

![Overview Page](Images/OverviewPage(23Jan2023).jpg)

![Budgeting Page](Images/BudgetingPage(23Jan2023).jpg)

### Day 95: 24th January 2023 

**Today's Progress**:

As the scrum leader today, I ran the daily stand-up and end-of-the day retrospective. That evening, one of my teammates sent me a message which boosted my confidence. They said, 

*“Hey Stephanie, I think you did a fantastic job leading the team today! You kept the stand-ups on point and I think we were a lot more clear and productive thanks to it!”*

 It was a surprise to receive their message and their encouraging words made my day. 

We paired off into three teams today with tasks to complete. My partner and I worked on making the app responsive so that you can view it on mobile phones as well. 

By Friday we have to prepare a short video introducing our project, create a new YouTube account for our team, and upload the video to this account. Therefore, I started preparing the PowerPoint presentation and embedding a demonstration video of our app into it. 


### Day 96: 25th January 2023 

**Today's Progress**:

I had a fun day today participating in my first hackathon for a potential employer. It’s the first step to apply for a junior software developer role at this company. I was put in a group of four and we were given four hours to design and create a web app to promote sustainability to individuals and software development project teams. We also had to prepare and give a 5 minute presentation to a panel of interviewers from the company about our app. 

Throughout the day, we were each pulled out at different times to meet one to one with someone from the company for a casual interview. I enjoyed my conversation with the person who interviewed me and learned a lot more about the company. All in all, it was a great experience. I had never worked with the three people in my group but we worked well together and the interviewers said that our presentation was really good.

### Day 97: 26th January 2023 

**Today's Progress**:

Today was the last day to work on our app. It was a flurry of activity and stress but we got through it. The main things we worked on were:
* Testing
* PowerPoint Presentation including video
* Tying the domain name to deployment
* Last merge with main branch and fixing bugs.

### Day 98: 27th January 2023 

**Today's Progress**:

Today we recorded our presentation and submitted it. You can view it here:

[Frugal Fanatics presentation](https://www.youtube.com/watch?v=uUx-UU_VvwM&t=10s)

If you’d like to try out our app for yourself, check it out here: https://frumo.co.uk/

![frumo Take Your Cash to the Next Level](Images/frumo_TakeYourCashToTheNextLevel.jpg)



**Celebrating the completion of our final project!**

![Frugal Fanatics last day photo](Images/FrugalFanaticsLastDay(27Jan2023).jpg)

 ### Day 99: 28th January 2023

**Today's Progress**:

Today I took on a 6 kyu Shopping List kata on CodeWars. First, I wrote a plan in plain English. I did something differently today though. Once I'd written the plan, I worked backwards. I looked at the best solutions and then wrote code to solve it. I did it in steps, first writing the code to solve the simplest part of the kata. For the next step, I wrote the code to include any discounts and buy one get one free deals on the products. Throughout I wrote comments explaining each line of code. I did all of it in a private repo in js files and tested them in [JS Console](https://jsconsole.com/).  

**Link to resource**: 
[Codewars Shopping List kata (6kyu)](https://www.codewars.com/kata/596266482f9add20f70001fc/javascript)

### Day 100: 29th January 2023

**Today's Progress**:

Continuing on from yesterday, today I wrote code to test the solutions that I wrote yesterday. I initialised a Node.js project and installed Jest as a dependency. Then I created the test files, wrote the tests, and ran the tests (`npm test`). Loved seeing those green pass test results!

### Day 101: 30th January 2023

**Today's Progress**:
Today we worked on preparing and rehearsing our presentation for the School of Code demo day. 

### Day 102: 31th January 2023

**Today's Progress**:
I worked with one of my Frugal Fanatics teammates this morning to write some end to end tests to test our app using Cypress. It was really fun to explore testing with Cypress. We hadn't done it since week 6 of the 16 week bootcamp. 

### Day 103: 1st February 2023

**Today's Progress**:

Today we shared our frumo app to the School Of Code's partner companies who are looking to hire talented junior developers. Our team had the chance to share our frumo app with 12 people from 9 different companies. Their responses blew me away! Here are a few quotes:

>"Awesome idea"

>"The best presentation I've seen all day. Very professional"

>"Shout out to the gamification of savings"

>"Amazing app"

>"Awesome presentation"

>"Really useful"

>"Makes dealing with money more digestible for non-financial people"

>"Looks fantastic"

>"Wonderful"

>"The dashboard is beautiful"

>"Really good looking app"

>"Looks really impressive. Very professional."

My personal favourite quote for the day though was:

>#### "Anyone can learn to code with enough time. How you work with people and your communication skills are much harder to learn."

It gives me high hopes as I continue learning how to code even after my days at the wonderful School Of Code are done. I am incredibly grateful to the School Of Code for choosing me, from among the 4000 applicants, to have the opportunity to attend their fantastic bootcamp. I have been stretched beyond measure and learned more than I ever thought possible these last four months. I can't wait to keep learning and coding!

![A Little Progress Each Day Adds Up To Big Results](Images/AlittleProgressEachDayAddsUpToBigResults.jpg)
