﻿using System.Collections.Generic;
using System.Threading.Tasks;

namespace SSCMS.Services
{
    public partial interface IAuthManager
    {
        Task<bool> IsSuperAdminAsync();

        Task<bool> IsSiteAdminAsync();

        Task<bool> IsSiteAdminAsync(int siteId);

        Task<string> GetAdminLevelAsync();

        Task<List<int>> GetSiteIdsAsync();

        Task<List<int>> GetContentPermissionsChannelIdsAsync(int siteId);

        Task<List<int>> GetVisibleChannelIdsAsync(List<int> channelIdsWithPermissions);

        Task<List<int>> GetContentPermissionsChannelIdsAsync(int siteId, params string[] permissions);

        Task<bool> HasAppPermissionsAsync(params string[] permissions);

        Task<List<string>> GetAppPermissionsAsync();

        Task<bool> HasSitePermissionsAsync(int siteId);

        Task<bool> HasSitePermissionsAsync(int siteId, params string[] permissions);

        Task<List<string>> GetSitePermissionsAsync(int siteId);

        Task<bool> HasContentPermissionsAsync(int siteId, int channelId, params string[] permissions);

        Task<bool> HasContentPermissionsAsync(int siteId, int channelId);

        Task<List<string>> GetContentPermissionsAsync(int siteId, int channelId);

        Task<List<string>> GetContentPermissionsAsync(int siteId);
    }
}
