﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using NSwag.Annotations;
using SSCMS.Configuration;
using SSCMS.Dto;
using SSCMS.Repositories;
using SSCMS.Services;

namespace SSCMS.Web.Controllers.Home.Common.Form
{
    [OpenApiIgnore]
    [Authorize(Roles = Types.Roles.User)]
    [Route(Constants.ApiHomePrefix)]
    public partial class LayerImageSelectController : ControllerBase
    {
        private const string Route = "common/form/layerImageSelect";

        private readonly IAuthManager _authManager;
        private readonly IPathManager _pathManager;
        private readonly IStorageManager _storageManager;
        private readonly ISiteRepository _siteRepository;

        public LayerImageSelectController(IAuthManager authManager, IPathManager pathManager, IStorageManager storageManager, ISiteRepository siteRepository)
        {
            _authManager = authManager;
            _pathManager = pathManager;
            _storageManager = storageManager;
            _siteRepository = siteRepository;
        }

        public class GetRequest : SiteRequest
        {
            public string Keyword { get; set; }
            public int Page { get; set; }
            public int PerPage { get; set; }
        }

        public class Image
        {
            public string ImageUrl { get; set; }
            public string VirtualUrl { get; set; }
        }

        public class GetResult
        {
            public List<Image> Images { get; set; }
            public int Count { get; set; }
        }
    }
}
