﻿using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using SSCMS.Dto;
using SSCMS.Services;
using SSCMS.Utils;

namespace SSCMS.Web.Controllers.Admin.Common.Editor
{
    public partial class LayerVideoController
    {
        [HttpGet, Route(Route)]
        public async Task<ActionResult<GetResult>> Get([FromQuery] SiteRequest request)
        {
            var site = await _siteRepository.GetAsync(request.SiteId);
            if (site == null) return this.Error("无法确定内容对应的站点");

            var rootUrl = _pathManager.GetRootUrl();
            var siteUrl = await _pathManager.GetSiteUrlAsync(site, true);

            var vodSettings = await _vodManager.GetVodSettingsAsync();
            var isCloudVod = _vodManager is ICloudManager && vodSettings.IsVod;

            var options = TranslateUtils.JsonDeserialize(site.Get<string>(nameof(LayerVideoController)), new Options
            {
                IsChangeFileName = true,
                IsLibrary = false,
            });

            return new GetResult
            {
                RootUrl = rootUrl,
                SiteUrl = siteUrl,
                IsChangeFileName = options.IsChangeFileName,
                IsLibrary = options.IsLibrary,
                IsCloudVod = isCloudVod,
                VideoUploadExtensions = site.VideoUploadExtensions
            };
        }
    }
}