<h1 align="center">
  <a href="https://singlelink.io">
    <img alt="Singlelink logo" height="150" src="https://uploads-ssl.webflow.com/61adc63433f2df05fde531f0/6208a997bb1f010bd2fc014f_singlelink-badge-padded.svg">
  </a>
</h1>

<h3 align="center">
    <a href="https://singlelink.co">Singlelink</a> is the open-source Linktree alternative.
</h3>
<p align="center">
  <a href="https://github.com/Neutron-Creative/Singlelink/actions/workflows/build-lint.yml">
    <img src="https://github.com/Neutron-Creative/Singlelink/actions/workflows/build-lint.yml/badge.svg" alt="Build & lint">
  </a>
    <a href="https://github.com/Neutron-Creative/Singlelink/projects/1">
        <img src="https://img.shields.io/badge/%20Beta-4.1.0-%2303d2d4" alt="Version">
    </a>
    <a href="https://www.gnu.org/licenses/gpl-3.0.en.html">
        <img src="https://img.shields.io/badge/License-GPL-%236ab04c" alt="License"/>
    </a>
    <a href="https://app.singlelink.co/analytics"/>
        <img src="https://img.shields.io/badge/dynamic/json?color=FF4081&label=Hosted%20Users&query=users&url=https%3A%2F%2Fapi.singlelink.co%2Fanalytics" alt="Users"/>
    </a>
    <a href="https://neutroncreative.com">
        <img src="https://img.shields.io/badge/-Built%20by%20Neutron%20Creative-%235353EC?logo=data:image/png;base64,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_EyKuIA41DMrSPy4DxifMvaCAY/zW3D1QSsL1NtEeGCFfE2XkHO8V6pTeQBbegzMD+Ta4NlQqef02N8ThCKDBil9Zooy9S+0qhJsjOVQpl5qgb68ckab1LP++m+p7+f7izdfI52f06AAAAAElFTkSuQmCC"/>
    </a>
</p>

<p align="center">
	<a href="https://twitter.com/singlelink">
		<img alt="Twitter Follow" height=20 src="https://img.shields.io/twitter/follow/singlelink?color=%2300acee&label=Follow%20us%20on%20Twitter&style=plastic">
	</a
	<a href="https://discord.gg/BUbmgV4">
		<img src="https://img.shields.io/discord/739822478276165675?color=%237289da&label=Join%20our%20community%20on%20Discord"/>
	</a>
</p>

<p align="center">
  <a href="#getting-started">Getting started</a> •
  <a href="#local-development">Local development</a> •
  <a href="#production-deployment">Production deployment</a> •
  <a href="#credits">Credits</a>
</p>

<h2 id="getting-started">Getting started</h2>

The easiest way to get started is to deploy your [Singlelink](https://singlelink.co) site with [Railway](https://railway.app). You can get started with one-click using the button below and build up to three Singlelink pages, each with custom domains, 100% free, thanks to their $5/mo credit system.

[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/new/template/R7HMcu)

We also recommend connecting [Vercel](https://vercel.com) and [Planetscale](https://planetscale.com) for a free self-hosted Singlelink environment.

<h2 id="local-development">Local development</h2>

Singlelink is a [NodeJS](#) project built on [Next.js](https://nodejs.org/en/), [GraphQL](https://graphql.org/) (served via [Apollo Server](https://www.apollographql.com/)), and [MySQL](https://www.MySQL.org/).

If you haven't already, you'll need to install NodeJS and MySQL before being able to host or work on Singelink.
- [NodeJS installation guide](https://nodejs.dev/learn/how-to-install-nodejs)
- To install MySQL with Docker, run `npm run db:boot` from the project root.

Once you've installed NodeJS & MySQL, you can download Singlelink locally with:
```bash
git clone https://github.com/Neutron-Creative/Singlelink.git;cd Singlelink;
```

Before you start, you'll need to configure your environment by copying the .env template:
```
cp .env.template .env
```

Then, set the following **mandatory** environment variables to your preferences:
- `DB_URL`: Optionally, override the remaining DB ENV variables with an all-in-one connection URL
- `DB_DATABASE`: The name of the MySQL database you'll connect to (ex: railway)
- `DB_PORT`: The port for the MySQL database you'll connect to (ex: 3306)
- `DB_HOST`: The host url for your MySQL database (ex: containers-us-east-13.railway.app)
- `DB_USER`: The username for your MySQL user (ex: root)
- `DB_PASSWORD`: The password for your MySQL user
- `SECRET`: The secret used to sign and validate JWTs during authentication
- `PASSWORD`: The password you'll use to login and manage your Singlelink

Optionally, set the following variables to customize your site:
- `META_TITLE`: The title for your site, seen in Google Search results
- `META_DESC`: The description for your site, seen in Google Search results
- `META_IMG`: The OG image for your site, seen when sharing your site on social media.
- `BRANDING`: A boolean that enables/disables Singlelink branding on your site & dashboard

Next, install your NPM dependencies using `--ignore-scripts`:
```bash
npm i --ignore-scripts
```

After, you can run the DB migration script to initialize your DB:
```bash
npm run db:migrate
```
*You'll need to run `npm run db:migrate` again everytime you pull changes. It can't hurt to run a migration, but it can break things if you don't.*<br><br>

Finally, you can start your development environment by running:
```bash
npm run dev
```

Open [http://localhost:3000](http://localhost:3000) with your browser to view your new Singlelink, and [http://localhost:3000/login](http://localhost:3000/login) to login and add your first link.

<h2 id="production-deployment">Production deployment</h2>

You can [deploy Singlelink in one-click here with Railway](https://railway.app/new/template?template=https%3A%2F%2Fgithub.com%2FNeutron-Creative%2FSinglelink&plugins=MySQL&envs=SECRET%2CPASSWORD%2CMETA_TITLE%2CMETA_DESC%2CMETA_IMG&optionalEnvs=META_TITLE%2CMETA_DESC%2CMETA_IMG&SECRETDesc=The+secret+used+when+signing+JWTs.&PASSWORDDesc=The+password+you%27ll+use+to+login+to+your+Singlelink+dashboard.&META_TITLEDesc=Your+page+%26+meta+title%2C+seen+in+Google+search+results&META_DESCDesc=Your+page+description+seen+in+Google+Search+results.&META_IMGDesc=The+OG+image+thumbnail+shown+when+sharing+your+Singlelink+on+social+media.&referralCode=singlelink). At this time, they are the only provider we maintain & gurantee support for.

### Need to host elsewhere?
#### Platform as a service hosts are recommended due to ease of installation (ex: Heroku, DigitalOcean App Platform , etc.)
We don't offer official support yet, but you can host Singlelink with any VPS, provided you can install and run both Node.JS & MySQL. Singlelink will need one MySQL database, and one NodeJS instance capable of running Next.JS at run-time/SSR.
<br><br>
<p align="center">
<b>Looking for cloud hosting with premium support?
<br>
Consider checking out <a href="https://singlelink.co">Singlelink Cloud</a>, with plans available soon starting at just $8/month.</b>
</p>

<h2 id="credits">Credits</h2>

Singlelink was built by the following team full-time from August 2020-2021 our mission to to *open-source the world* at [Neutron Creative](https://neutroncreative.com).
<br><br>
<ul>
    <li>Jim Bisenius (Co-founder & former CEO, <a target="_blank" href="https://twitter.com/jim_bisenius">@jim_bisenius</a>)</li>
    <li>Navid Kabir (Co-founder  & former CTO, <a target="_blank" href="https://twitter.com/navidk0">@navidk0</a>)</li>
    <li>Andrew Boyle (Co-founder & former CMO)</li>
</ul><br>

Today, Singlelink is maintained soley by me, Jim Bisenius on nights & weekends. If you'd like to assist in my development efforts, I'd love your help. Please [join our Discord](https://discord.gg/DDGnXCcgsu) or [create a pull request](https://github.com/Neutron-Creative/Singlelink/pulls)!
