# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/)
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

Generated by [`auto-changelog`](https://github.com/CookPete/auto-changelog).

## [Unreleased](https://github.com/Neutron-Creative/Singlelink/compare/v2.2.0...HEAD)

## [v2.2.0](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.9...v2.2.0) - 2021-03-08

### Merged

- Merge UI minor fixes in v2.1.9 [`#103`](https://github.com/Neutron-Creative/Singlelink/pull/103)
- Merge latest master commits into client overhaul. [`#102`](https://github.com/Neutron-Creative/Singlelink/pull/102)
- Update enterprise user stats on website [`#101`](https://github.com/Neutron-Creative/Singlelink/pull/101)
- Merge minor fixes from client-overhaul into master [`#100`](https://github.com/Neutron-Creative/Singlelink/pull/100)
- Re-enable profile analytics [`#99`](https://github.com/Neutron-Creative/Singlelink/pull/99)
- Merge minor client overhaul changes in master [`#98`](https://github.com/Neutron-Creative/Singlelink/pull/98)
- Merge client overhaul into master [`#97`](https://github.com/Neutron-Creative/Singlelink/pull/97)

### Commits

- Create skeleton of marketplace and some preliminary functionality [`b11a948`](https://github.com/Neutron-Creative/Singlelink/commit/b11a94815e457e3600553c7dd111e151de9a425e)
- Add proper SEO tags to client [`e87fa3e`](https://github.com/Neutron-Creative/Singlelink/commit/e87fa3e7cd8c05c00340b8fbb2a9bd1491eb71e1)
- More marketplace functionality [`23dfe26`](https://github.com/Neutron-Creative/Singlelink/commit/23dfe265ed795cce8704d1b60777df569b188993)
- Add basic front-end marketplace, awaiting rich theme details to finalize [`2db8019`](https://github.com/Neutron-Creative/Singlelink/commit/2db8019ca1fc99ee111ae9bea7549dedf90293e7)
- Update website [`8b9e36a`](https://github.com/Neutron-Creative/Singlelink/commit/8b9e36a869fe20bdae162ba7ceb993284ea03e97)
- Pushing update for team [`30babca`](https://github.com/Neutron-Creative/Singlelink/commit/30babca0e4c8de044da3849bac0075114142c30e)
- Add new link types, and fix client bug with links not sorting properly after adding/deleting links [`7dc8a26`](https://github.com/Neutron-Creative/Singlelink/commit/7dc8a26c08bd859492530b54c11d5ac982e48c80)
- No-code profiles is done! [`5f780c7`](https://github.com/Neutron-Creative/Singlelink/commit/5f780c7887e157bcc7dc1e0f31d78e5db2b1cbfa)
- Add mixpanel analytics and events to server [`437063a`](https://github.com/Neutron-Creative/Singlelink/commit/437063a7741b2dbf8e545132d31863502877233e)
- Finish up work for the first iteration of the marketplace [`4333b9b`](https://github.com/Neutron-Creative/Singlelink/commit/4333b9bd9a53152affad8a60a20335728d673373)
- Replace Custom CSS & HTML textareas with Monaco text-editor [`a9d426e`](https://github.com/Neutron-Creative/Singlelink/commit/a9d426ecd570d299f04f1ab214696f59a33d3799)
- Fix analytics privacy mode bugs [`cd1cc5b`](https://github.com/Neutron-Creative/Singlelink/commit/cd1cc5b24da5b859429c8abf8ceb850f38ffc606)
- Add null checks if mixpanel token is not provided [`4ba2d71`](https://github.com/Neutron-Creative/Singlelink/commit/4ba2d71c970d8e2ce15afe0367d1e6d90c693f6f)
- Create marketplace and theme detail view [`cdf9e7b`](https://github.com/Neutron-Creative/Singlelink/commit/cdf9e7b65c657a2b841e055f50100874ee13dfd3)
- Added no-code typography [`6ca6af6`](https://github.com/Neutron-Creative/Singlelink/commit/6ca6af6f85adc647f9ffae3dea451c1b3233462d)
- Add profile leaderboard api [`0f61b35`](https://github.com/Neutron-Creative/Singlelink/commit/0f61b3591b99adecc70d14b5c39879d060125786)
- Add quite a few options for sorting [`66b5604`](https://github.com/Neutron-Creative/Singlelink/commit/66b560411aa675ee9959df83fb933937f5b674ef)
- Add link styles & typography UI [`9b67af5`](https://github.com/Neutron-Creative/Singlelink/commit/9b67af5aeb84e81c3e478ef5576bfe4504bbc503)
- Added theme previews [`eebd714`](https://github.com/Neutron-Creative/Singlelink/commit/eebd7143f52e0baa2926ee9a82eb93be47a7fc98)
- Add stats exporter and corresponding npm command [`f417d40`](https://github.com/Neutron-Creative/Singlelink/commit/f417d40f75a2849d45facf8d8cefb696ee5cf47c)
- Add new private metadata field and update email notification options [`36ddfef`](https://github.com/Neutron-Creative/Singlelink/commit/36ddfef347791f24c6e51c6bb92ea39e96842467)
- Fixed null in css issue [`ecb0ae0`](https://github.com/Neutron-Creative/Singlelink/commit/ecb0ae0d72c66ca349d644a5d75b119c2cb8a5b3)
- Push no-code avatars [`7097a1a`](https://github.com/Neutron-Creative/Singlelink/commit/7097a1a1d255dbd89e8ae404eab26579b9f4f1a5)
- Add fuzzy searching using trigrams for marketplace [`f653e9b`](https://github.com/Neutron-Creative/Singlelink/commit/f653e9b5622d841a2507090ca91435826a6fd2f5)
- Add desktop website draft [`03a3f0b`](https://github.com/Neutron-Creative/Singlelink/commit/03a3f0b224b130df9d32da4a1b7327205bddc0a5)
- Add Ace Code Editor to client for appearance editing [`8361a62`](https://github.com/Neutron-Creative/Singlelink/commit/8361a62cfecdcaf684f54fb06e30caef1b25a9d6)
- Create marketplace list draft [`c4ff79d`](https://github.com/Neutron-Creative/Singlelink/commit/c4ff79dc93287a859f36de8c5e6e6e1d77f39eae)
- Update package versions and changelog [`8ebd7e7`](https://github.com/Neutron-Creative/Singlelink/commit/8ebd7e7a4094c025102449d886714298f2f57b25)
- Add basic no-code backgrounds [`d41de5d`](https://github.com/Neutron-Creative/Singlelink/commit/d41de5dc641fd03d6f00bc3d98240626aee8503d)
- Update analytics range [`39d2fe0`](https://github.com/Neutron-Creative/Singlelink/commit/39d2fe06ef64fa5c7f7f7fd6bb4c5d6536ca752a)
- Addons now contain more resource info when "detailed: true" is passed in the body [`e88b008`](https://github.com/Neutron-Creative/Singlelink/commit/e88b008de4095f8c87721f508b55f9e690679c23)
- Add leaderboard to website [`83040fe`](https://github.com/Neutron-Creative/Singlelink/commit/83040fedcb44b5a88b18f09a4244b5e31a84dfc3)
- Add new private metadata field [`9a721a5`](https://github.com/Neutron-Creative/Singlelink/commit/9a721a53df3ec7fca88f4817848d858e279f756e)
- Add search bar [`767df5e`](https://github.com/Neutron-Creative/Singlelink/commit/767df5e21c25c8ae532e9dab37719f895abda91a)
- Prevent deletion of actively used addons and themes below a certain threshold [`69d5335`](https://github.com/Neutron-Creative/Singlelink/commit/69d5335bcb4bb4ef7d4c0230f7fe48d71655106f)
- Enriched marketplace data [`702a9b1`](https://github.com/Neutron-Creative/Singlelink/commit/702a9b10998b8b217c1b0f4d2dbd4e6c2599c8a7)
- Add basic page styles to no-code [`0b1971e`](https://github.com/Neutron-Creative/Singlelink/commit/0b1971ef90f3153c972a9c7d9d461e5d5e132ff7)
- Add scrollability to preview tab [`1269f49`](https://github.com/Neutron-Creative/Singlelink/commit/1269f497f0e147b5c3a6f62d78bc633a0588f764)
- Add unlisted toggle (server side) [`cf716d7`](https://github.com/Neutron-Creative/Singlelink/commit/cf716d7f4df5ef006557da6bd56ac9f0f81dba16)
- Implement GDPR package download, and fix bug with metadata for links [`0bee2bc`](https://github.com/Neutron-Creative/Singlelink/commit/0bee2bced07430bca5113c9b306cc8ef998ce260)
- Add CSStoJSON for no-code appearance [`6eede62`](https://github.com/Neutron-Creative/Singlelink/commit/6eede62391a2a9f4bfe818477fbb3b4b44638ef5)
- Update marketplace landing page [`75d8cdb`](https://github.com/Neutron-Creative/Singlelink/commit/75d8cdb7aff45922842f9df6385f26e3cf1d4220)
- Enrich marketplace pages and preview [`dc27578`](https://github.com/Neutron-Creative/Singlelink/commit/dc2757800c2dc7da3984ed4d3b704807591ce08c)
- Add new www seo tags [`ced905f`](https://github.com/Neutron-Creative/Singlelink/commit/ced905f7f7d2b2dd5787d9de211c5a6494072434)
- Add no-code theme builder to theme editor [`84f679c`](https://github.com/Neutron-Creative/Singlelink/commit/84f679c26be67c41835b323fead850df80909f85)
- Add background types to no-code [`e11a0e9`](https://github.com/Neutron-Creative/Singlelink/commit/e11a0e9de474e66d4a76599c97c33aa564dfc7dd)
- Append query string to a href tags when present on client for tours [`e56d30a`](https://github.com/Neutron-Creative/Singlelink/commit/e56d30a0bd1f8e7068580671ca63d1d650452cdd)
- Add theme preview [`e0fa5c1`](https://github.com/Neutron-Creative/Singlelink/commit/e0fa5c1723785b7d0dae9e40611e723d5bfd5872)
- Add dynamic testimonial and profile previews to landing page [`13cc74e`](https://github.com/Neutron-Creative/Singlelink/commit/13cc74e6893f1692dd21b8c5f61f0bb87d33fa58)
- Add analytics disabled warning on privacy mode [`b7c0a79`](https://github.com/Neutron-Creative/Singlelink/commit/b7c0a79564f2c66ca2539e94ae7e024df19f9198)
- Make website responsive [`6c0be12`](https://github.com/Neutron-Creative/Singlelink/commit/6c0be1286dc97f45ca5f1e0f916a3e36adcb97be)
- Few small additions [`0c8f445`](https://github.com/Neutron-Creative/Singlelink/commit/0c8f4453124d074ec3a262c0fe1a9f0fbf90b3c4)
- Add preliminary functions for allowing for users to favorite addons [`c3e3499`](https://github.com/Neutron-Creative/Singlelink/commit/c3e34995c8f5082e05297a171da74654e7d44b5c)
- Fix CTR - make it calculated on client-side [`976d1dc`](https://github.com/Neutron-Creative/Singlelink/commit/976d1dccf6abaff5b37148cd9435c016d7d42140)
- Add anonymous analytics [`848f81e`](https://github.com/Neutron-Creative/Singlelink/commit/848f81e0e53576331b1ee666eb6d6176d4f78c56)
- Implement delete user [`6e91e99`](https://github.com/Neutron-Creative/Singlelink/commit/6e91e995a16da1476c2353315642cdd050613497)
- Add safety to avatar no-code [`9e8855e`](https://github.com/Neutron-Creative/Singlelink/commit/9e8855ed3c47441906844cfd1ece222b8191e72e)
- Addons can be deprecated [`75b1aae`](https://github.com/Neutron-Creative/Singlelink/commit/75b1aae598188b206fec40525a60093a2251ea83)
- Add QR Code embed [`3753347`](https://github.com/Neutron-Creative/Singlelink/commit/37533471bad3436065fa0bd5c8ce9e68bafe04ce)
- Add display name support to addons [`b579996`](https://github.com/Neutron-Creative/Singlelink/commit/b579996e41260a7accfe1f4f6ca930929b202d55)
- Basic enhance readme [`91c5939`](https://github.com/Neutron-Creative/Singlelink/commit/91c593998ff353839d43d8014cc2c09d5cec2ed0)
- Move useitful to head script [`0d99d43`](https://github.com/Neutron-Creative/Singlelink/commit/0d99d43dc51abae3f79c4f6ae4f0c8ac890be6f1)
- Add website scroll animations [`85b7276`](https://github.com/Neutron-Creative/Singlelink/commit/85b72768330b87e9bb71bc215d3a76f40d5184a1)
- Fix TS issues temporarily [`6669679`](https://github.com/Neutron-Creative/Singlelink/commit/666967984cd9ce6c89379804b7180a5934af511b)
- Fix bug where metadata would occasionally become null [`07e46e2`](https://github.com/Neutron-Creative/Singlelink/commit/07e46e2da4fea0065c4965aba2fd04eb5ed1c99e)
- Fix pagination because now it actually works [`04d6fc4`](https://github.com/Neutron-Creative/Singlelink/commit/04d6fc4f116db0f9db3569a5df6b76bc50844fc4)
- Add a rate limit to addon creation [`1991ec8`](https://github.com/Neutron-Creative/Singlelink/commit/1991ec82d6beaa2c8d9c1fdf9f8feb30c7f2b114)
- Add Useitful to dashboard [`99cbd1f`](https://github.com/Neutron-Creative/Singlelink/commit/99cbd1f17220137e3f73d8cd7e56ab011b8e220c)
- Ensure only one theme can be installed at a time from the marketplace [`6d8ea7f`](https://github.com/Neutron-Creative/Singlelink/commit/6d8ea7fb21891473cf481718dad52e1c12ebe139)
- Remove usetiful product tours for internal solution [`63edfa2`](https://github.com/Neutron-Creative/Singlelink/commit/63edfa2de4f6cfcac4f4cc59318ab0ff14579a13)
- Update website [`4b1f4a3`](https://github.com/Neutron-Creative/Singlelink/commit/4b1f4a37e637c3838524dec7b4d651cfe5c333f9)
- Update pricing dropdown & animations [`f81e948`](https://github.com/Neutron-Creative/Singlelink/commit/f81e9481dd84c376a1ce796137cfc9bdff8539e7)
- Fix mobile preview scaling issues [`e452244`](https://github.com/Neutron-Creative/Singlelink/commit/e4522449ccd37d171a25edf62da31ca7f195f7cf)
- Add Usetiful script to dashboard [`12d2a0b`](https://github.com/Neutron-Creative/Singlelink/commit/12d2a0b2ae5c15f45986aa378f5ed00574822d1f)
- Fix TS errors [`9ae406c`](https://github.com/Neutron-Creative/Singlelink/commit/9ae406c7a8c9531bb491204d37c16545bb7ae811)
- Track watermark status toggle [`f713580`](https://github.com/Neutron-Creative/Singlelink/commit/f713580aff10587970d2399a85d8d913c2e8c661)
- Debugging remotely sucks [`3983784`](https://github.com/Neutron-Creative/Singlelink/commit/3983784067090e1c0209e15e31c873d8382aec63)
- Allow for link metadata to be passed on link creation/update [`a14d3ed`](https://github.com/Neutron-Creative/Singlelink/commit/a14d3edc4dd01d622dc431c5a383df179c1055c5)
- Fix broken Custom CSS on appearance tab error [`afc41a2`](https://github.com/Neutron-Creative/Singlelink/commit/afc41a240a58a1914b9888c4b994fe6e377ff0fe)
- Search in marketplace finalized [`6f1fa93`](https://github.com/Neutron-Creative/Singlelink/commit/6f1fa939eea824380176b32709714eca9e589459)
- Avatar upload works? [`8f2c964`](https://github.com/Neutron-Creative/Singlelink/commit/8f2c9644f278d38f9ec2b33b581fa4a3bebf5fa6)
- Fix TS type bugs in marketplace.vue [`2e939fc`](https://github.com/Neutron-Creative/Singlelink/commit/2e939fc1b7871881557c320f65dd0107633030d0)
- Update tours page [`4eae8ec`](https://github.com/Neutron-Creative/Singlelink/commit/4eae8ec5a0c12c0103425b9e42dc8e530b92c1ba)
- Update default config values [`636ae50`](https://github.com/Neutron-Creative/Singlelink/commit/636ae50d97a4e176decc6d982c935fc836b253af)
- Update pricing copy on website [`a8e0783`](https://github.com/Neutron-Creative/Singlelink/commit/a8e07831deba6d7a77a8aa29592ffa96c7d7d459)
- Enable no-code background none [`abbbcc8`](https://github.com/Neutron-Creative/Singlelink/commit/abbbcc81fd0399aff3d68c224933f279644061a6)
- Fix border radius on mobile display [`c9ca1c3`](https://github.com/Neutron-Creative/Singlelink/commit/c9ca1c383bbf48e06a5b847d10d18fbe9ea0c232)
- Fix AOS on mobile [`36a8bbd`](https://github.com/Neutron-Creative/Singlelink/commit/36a8bbd09c605d78f04924674751b39d90b4692e)
- Allow profile css to override theme css [`daa7143`](https://github.com/Neutron-Creative/Singlelink/commit/daa7143383e73911ab44baccb71a5eb495593930)
- Fix input field for theme custom css [`cfc3588`](https://github.com/Neutron-Creative/Singlelink/commit/cfc35880214533413b8fc6449bdc8f6d8d9e2945)
- Fix issue where create addons query was misaligned (and fixed null constraint violation issues) [`bf4194c`](https://github.com/Neutron-Creative/Singlelink/commit/bf4194c0b7fdd35b001cb3cc59a75548d525da4f)
- Disable mobile aos on testimonials on www [`1c602ca`](https://github.com/Neutron-Creative/Singlelink/commit/1c602ca5f395b4fac05f492351c24c80aafffda2)
- Add custom domain documentation! [`94a3fa7`](https://github.com/Neutron-Creative/Singlelink/commit/94a3fa768bc8eb36a2956b88d757612f062b2896)
- Fixed no-code avatar shadow selector typo [`49a8eec`](https://github.com/Neutron-Creative/Singlelink/commit/49a8eeca17aab5bb3e3007897afe8b5e2a6d2774)
- Remove unused Querystring in request interface [`0c40577`](https://github.com/Neutron-Creative/Singlelink/commit/0c40577c52f86604013af39a553c256e14ea41b5)
- Update leaderboard to remove iframe & correct API url for production [`26b9477`](https://github.com/Neutron-Creative/Singlelink/commit/26b9477862b10cf624208565e7358bba260ac15e)
- Final pricing copy update for tonight [`65684a8`](https://github.com/Neutron-Creative/Singlelink/commit/65684a874a72302763853fceb404071799cf4d57)
- Fix flip-flopped button labels in no-code builder [`ad614f2`](https://github.com/Neutron-Creative/Singlelink/commit/ad614f209999761ef3870a1b42eb35ae78576675)
- Add overflow-x:hidden to profile view [`12012fc`](https://github.com/Neutron-Creative/Singlelink/commit/12012fcfdb6dadaac82ff0a8e681f9c30f8801d0)
- Fix avatar image url tooltip throwing improper errors on url with file type mid-string [`5bd0f63`](https://github.com/Neutron-Creative/Singlelink/commit/5bd0f639e2c5b1b2d6eb8f6c46adf4f306285d49)
- Test capture thumbnail on profile leaderboard [`396e703`](https://github.com/Neutron-Creative/Singlelink/commit/396e7032e196e0d0ce190e600fddea8a6bc964c1)
- Fix export icon link [`dabf197`](https://github.com/Neutron-Creative/Singlelink/commit/dabf197a1ac7e8558e6e302e280d7f4299aaa376)
- Add top cushioning on analytics page [`811c4b2`](https://github.com/Neutron-Creative/Singlelink/commit/811c4b2b07e09640f878c8341094a6e67a7faa5c)
- Remove video from homepage for upload [`e003b38`](https://github.com/Neutron-Creative/Singlelink/commit/e003b38e46ea0508e230f126d3d5ccb0c33cc663)
- Oops... add dynamic url to qr codes! [`526ae5f`](https://github.com/Neutron-Creative/Singlelink/commit/526ae5fc39d8daa36bf6ddfdadbbc61b94bdbea4)
- Check for missing config option [`7580c77`](https://github.com/Neutron-Creative/Singlelink/commit/7580c77c920c67eb214e3a4edc4a0f42a43bf0d2)
- Fix type errors p2 [`c176b95`](https://github.com/Neutron-Creative/Singlelink/commit/c176b95666a9dad4cf05dda6aacd4e327ae61ca2)
- Fix type errors [`d6bfb95`](https://github.com/Neutron-Creative/Singlelink/commit/d6bfb950fa7ad865dc2cc0549cd1fb0a9fd2b984)
- Add identifier to watermark [`e87049c`](https://github.com/Neutron-Creative/Singlelink/commit/e87049c11057cae89a31fbcdfa9e4705c0092efe)
- Fix border visible on link error [`cf749ae`](https://github.com/Neutron-Creative/Singlelink/commit/cf749aed16fb1c363260840f96c02cf64b035340)
- Remove TODO [`c740e46`](https://github.com/Neutron-Creative/Singlelink/commit/c740e46f2a4f5808e77cb057fb5c048413639eb8)
- Fix width on login UI error alert [`d0a66cd`](https://github.com/Neutron-Creative/Singlelink/commit/d0a66cdde5c46ad651e1b1d948c25d25aaaacdfb)
- Add tour redirect to create-account [`d039cc7`](https://github.com/Neutron-Creative/Singlelink/commit/d039cc77e99093f250997ad3e06c1da8ea4de7d0)
- Fix html & css modal on desktop bug in theme modal [`b5d5504`](https://github.com/Neutron-Creative/Singlelink/commit/b5d5504edaeb2056066668177dd857569ff6b012)
- Update user creation analytics [`a4f42c4`](https://github.com/Neutron-Creative/Singlelink/commit/a4f42c4385f8eb955e5687b6110488a779bf2a9e)
- Update marketplace landing page p2 [`2e7a7d6`](https://github.com/Neutron-Creative/Singlelink/commit/2e7a7d6359adce9442748ca30d7440a5502865a4)
- Add target=_blank to profile watermark [`4e44d2d`](https://github.com/Neutron-Creative/Singlelink/commit/4e44d2dc4f7da7cbb55b7ec638c60dba120e7c99)
- Add info button to login [`d378f00`](https://github.com/Neutron-Creative/Singlelink/commit/d378f001c19ab7c7b96450074b6736b9f08aaacb)

## [v2.1.9](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.8...v2.1.9) - 2021-02-12

### Commits

- Make major accessibility improvements to client [`7f63ca7`](https://github.com/Neutron-Creative/Singlelink/commit/7f63ca7ac2066aa5be6ea3633134e0eefdfe43f3)
- Update Singlelink website to v3 [`5af591d`](https://github.com/Neutron-Creative/Singlelink/commit/5af591d4db5842bf6660e1c28f51c0b14b2f82cc)
- New route: /profile/set-privacy-mode for enabling privacy mode [`71321e9`](https://github.com/Neutron-Creative/Singlelink/commit/71321e91f54c614e1f0f93c7876b308608567cd5)
- Fix analytics privacy mode bugs [`ff95f8b`](https://github.com/Neutron-Creative/Singlelink/commit/ff95f8bc2a81a1e490f9dccc1eadada9b04879e5)
- Update link and profile analytics for privacy mode [`02bf458`](https://github.com/Neutron-Creative/Singlelink/commit/02bf4580e1210c407996eb03d556524b1833aa93)
- Add analytics redirect [`9b84030`](https://github.com/Neutron-Creative/Singlelink/commit/9b840302f0e857e8990c311448bd08e9830de04e)
- Add wall of love scrolling animation [`0d264a7`](https://github.com/Neutron-Creative/Singlelink/commit/0d264a72e42b3afbfdf431d6869eb5b5b06ccfab)
- Add analytics page [`9347bcf`](https://github.com/Neutron-Creative/Singlelink/commit/9347bcff725d8abac58f9743fa8510f7c88d50f9)
- Update meta content [`01e4d8e`](https://github.com/Neutron-Creative/Singlelink/commit/01e4d8e4834691e79e38bdca5fb9f3b857d5aa01)
- Update analytics page on www [`9f399a6`](https://github.com/Neutron-Creative/Singlelink/commit/9f399a66851cf52bcf3a6126d0a8c39d21a4db3f)
- Minor fixes to www [`b03d4a3`](https://github.com/Neutron-Creative/Singlelink/commit/b03d4a3b96fd1c4e77624a3fac152df304d26981)
- Add pending appearance panel & target _blank to doc links in appearance [`397faed`](https://github.com/Neutron-Creative/Singlelink/commit/397faede1dcae6fd0891b8456411142699b18745)
- Update analtyics page & restyle dashboard headings [`827bcc3`](https://github.com/Neutron-Creative/Singlelink/commit/827bcc39d3bfe29d3753de6a025266c7d02eee29)
- HOTFIX: Https error on non-ssl enterprise client on analytics page of www fixed [`a2a3491`](https://github.com/Neutron-Creative/Singlelink/commit/a2a34918d54b108da41677a3e7ee2c0a9aebc435)
- Add JSON structure for product tours [`f4079f6`](https://github.com/Neutron-Creative/Singlelink/commit/f4079f63fb657e01a3256958ab329135ffdfb131)
- Add tours page outline [`d43d29c`](https://github.com/Neutron-Creative/Singlelink/commit/d43d29c97126c57b923c5979de37ddeda92894fa)
- Profile data is now loaded server-side with fetch() [`0556a10`](https://github.com/Neutron-Creative/Singlelink/commit/0556a104de570dee9d1a98a36c00fae3792b102b)
- Fix SEO Meta issues on profile [`62b6033`](https://github.com/Neutron-Creative/Singlelink/commit/62b60330fa21d79e66e36dd8d59e0d3e4da5e5f0)
- Clean up OG issues p2 [`7772141`](https://github.com/Neutron-Creative/Singlelink/commit/77721415a6e72c9645f1e8614ea8bea075e3d05d)
- Update enterprise user stats on website [`b5afbe6`](https://github.com/Neutron-Creative/Singlelink/commit/b5afbe6bf2a2ad3095f51659b651111aa4f3472b)
- Add pfp format verification [`a3f111d`](https://github.com/Neutron-Creative/Singlelink/commit/a3f111d199de583b6eade9745bd8e097e24d5386)
- Add documentation links to Custom HTML & CSS fields [`a4543da`](https://github.com/Neutron-Creative/Singlelink/commit/a4543dad530a1d5ff17e2af0920f176c3eb82e19)
- Added privacy toggle [`abd106c`](https://github.com/Neutron-Creative/Singlelink/commit/abd106c9d06f8d49b1fe5a210cc97e63180de056)
- HOTFIX: fix og bug from short-circuit expression [`f029bb1`](https://github.com/Neutron-Creative/Singlelink/commit/f029bb150435db0bf3a0fe0511a7dd653e607bd5)
- Add links to readme for SEO [`d034b62`](https://github.com/Neutron-Creative/Singlelink/commit/d034b62ae0edda9bf6f5ec9ac8ca735485934792)
- Add 404 page [`2a62cc1`](https://github.com/Neutron-Creative/Singlelink/commit/2a62cc1d182370053ac5653c2b888863e89f3be4)
- HOTFIX: pt 3 for og images [`31dcfaf`](https://github.com/Neutron-Creative/Singlelink/commit/31dcfaf84eadeb60325019d9779bdd3c87853701)
- Undo [`8bad58c`](https://github.com/Neutron-Creative/Singlelink/commit/8bad58c9f8a726923f89e247d4a46a782041cabc)
- HOTFIX: if this doesnt work whydontya [`8f9a656`](https://github.com/Neutron-Creative/Singlelink/commit/8f9a656d1f87680947428566c72b8bec7a7d2975)
- UNDO NAVID DANG IT WHY DO U DO THIS [`56de597`](https://github.com/Neutron-Creative/Singlelink/commit/56de597b0ee655d75ba929838fde3c124cf09ee3)
- Update analytics page stylings [`87da7f2`](https://github.com/Neutron-Creative/Singlelink/commit/87da7f2aaad20850544218f94c6217d7d65b8a4b)
- Update info of testimonials in www [`08cd30a`](https://github.com/Neutron-Creative/Singlelink/commit/08cd30a917e38e717797cffa805a1459499f0254)
- Update snippet placement for NuxtJS guidelines [`c55373e`](https://github.com/Neutron-Creative/Singlelink/commit/c55373ef9788b79b8234017609b5b887927ed62d)
- Update website profile copy [`51afcad`](https://github.com/Neutron-Creative/Singlelink/commit/51afcad7613627e35516a9bad2402f6790d98c4e)
- Add plausible analytics to client [`1f8ebfb`](https://github.com/Neutron-Creative/Singlelink/commit/1f8ebfbb1141de1847d145b139c080b1439e6e41)
- Remove billing info from account settings page temporarily [`19be63f`](https://github.com/Neutron-Creative/Singlelink/commit/19be63fae1abdba9acad10533a422d9728e0bf9b)
- Add fallback true to nuxt.config.js on www [`8c1f6ae`](https://github.com/Neutron-Creative/Singlelink/commit/8c1f6aeef424ce1f7dfcf6543208d405c411ad60)
- Update website banner [`17f7b06`](https://github.com/Neutron-Creative/Singlelink/commit/17f7b064137f3e8c01d927a40a723a7c244aafa7)
- Disable privacy mode toggle [`4bae276`](https://github.com/Neutron-Creative/Singlelink/commit/4bae27649a102ea2f0ae7ff43c85f6caac8a970a)
- Add target _blank to link [`b35baa3`](https://github.com/Neutron-Creative/Singlelink/commit/b35baa37ea81b62854a6dd09899e6d103fd1588b)
- Hide tours page temporarily [`64aa031`](https://github.com/Neutron-Creative/Singlelink/commit/64aa031ce23ddd6347d8a138f1b7b08e192217d9)
- Add CSS selectors to theme & custom html in profile view [`0cc5e29`](https://github.com/Neutron-Creative/Singlelink/commit/0cc5e29b42a70f15ad82d20d4c712e75991336ba)
- Change sales email address in www [`17d2179`](https://github.com/Neutron-Creative/Singlelink/commit/17d2179371520aa2a326d0f60011bdc74d115087)
- Updated wall of love [`1027f94`](https://github.com/Neutron-Creative/Singlelink/commit/1027f9427ec5441b84061359ecee645a4036d941)
- Change plausible snippet src to remote url [`1ec5643`](https://github.com/Neutron-Creative/Singlelink/commit/1ec56431aa6d66038ec93b402f62f87553b365cd)
- Add Plausible analytics snippet [`9351d7e`](https://github.com/Neutron-Creative/Singlelink/commit/9351d7e611384e67be36cfbbc650c1e7dc7aefe0)
- Replace SSH in instructions with HTTPS [`b22d9b9`](https://github.com/Neutron-Creative/Singlelink/commit/b22d9b91ba552c58bc614806adbe8483a59ffe70)
- Update placeholder on password submit field [`a71e56b`](https://github.com/Neutron-Creative/Singlelink/commit/a71e56b3d455f8570f4b43de36f9100e9d92b0e3)
- Re-enable profile analytics [`d555291`](https://github.com/Neutron-Creative/Singlelink/commit/d555291dc47fe93ad6ce7bcac2ae5f2912a20e75)
- Re-enable link click analytics [`bb117cd`](https://github.com/Neutron-Creative/Singlelink/commit/bb117cde332c4077a60373e9df82e0c65b6fd157)
- Links now should open with target="_blank" [`3db1faa`](https://github.com/Neutron-Creative/Singlelink/commit/3db1faafaffb255e58457409e696826c6bfd8154)
- Update promotional image [`e9ba73c`](https://github.com/Neutron-Creative/Singlelink/commit/e9ba73cb786f129563f3bb9f06b1f7c12266d24e)
- Fix discord button text alignment on index page of www [`4814c87`](https://github.com/Neutron-Creative/Singlelink/commit/4814c8719ef67b7d81d202ab47fb482daa6ff261)
- Change url for footer analytics link in www [`21a5688`](https://github.com/Neutron-Creative/Singlelink/commit/21a56884f5b7c3fd3c09acbe73484cdbb8637b9a)
- Change copy on hero button of www [`2040882`](https://github.com/Neutron-Creative/Singlelink/commit/2040882f766037f2d50e512dd42c4e6b4b08593d)
- HOTFIX: fix column width bug from class typo in www [`9f2700d`](https://github.com/Neutron-Creative/Singlelink/commit/9f2700d8523ba64ce5cd0a1ab5f43beb22c7ac15)
- Add href to empty link on www index [`2e9e570`](https://github.com/Neutron-Creative/Singlelink/commit/2e9e570af9a9fce2bf850bcb69bc5d66ad4bc95f)
- Add responsive CTA [`1cfa730`](https://github.com/Neutron-Creative/Singlelink/commit/1cfa7301c18fc8f7458f42c969a5fa0cd5f37c77)
- Update API source for hosted user count in readme [`d29a601`](https://github.com/Neutron-Creative/Singlelink/commit/d29a6015690f7088571ad23393c56cb17e4b9328)

## [v2.1.8](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.7...v2.1.8) - 2021-01-16

### Commits

- Fix user sign up bug [`8be2a03`](https://github.com/Neutron-Creative/Singlelink/commit/8be2a0379aabaac7c3b2a84542c93712bd2001eb)

## [v2.1.7](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.6...v2.1.7) - 2021-01-16

### Merged

- Bump node-notifier from 8.0.0 to 8.0.1 in /server [`#85`](https://github.com/Neutron-Creative/Singlelink/pull/85)
- Bump ini from 1.3.5 to 1.3.8 in /www [`#86`](https://github.com/Neutron-Creative/Singlelink/pull/86)
- Bump axios from 0.21.0 to 0.21.1 in /server [`#84`](https://github.com/Neutron-Creative/Singlelink/pull/84)

### Commits

- SL v2.1 [`d058f23`](https://github.com/Neutron-Creative/Singlelink/commit/d058f23e71536889c9d6ba68c39e30bc39681e35)
- Merge v2.0 website back over legacy after being removed in merge [`6a9fb43`](https://github.com/Neutron-Creative/Singlelink/commit/6a9fb43fc421c4fc7c96aacf87062368c3f4636a)
- Add footer to privacy policy [`82e81c6`](https://github.com/Neutron-Creative/Singlelink/commit/82e81c668af69e0d7c1af8ac7141993761e13a63)
- Add mobile responsiveness and fix avatar 404s, update to 2.1.7 [`b9580fc`](https://github.com/Neutron-Creative/Singlelink/commit/b9580fcb03c0e9048994f8cf238d9a68cb617e1e)
- Update readme.md [`d2ade24`](https://github.com/Neutron-Creative/Singlelink/commit/d2ade24abbf92c7f199496ff3bdbde7fa670ddf6)
- Enable client-side whitelabeling [`00d9740`](https://github.com/Neutron-Creative/Singlelink/commit/00d9740c27e7db1341fae45b4b12fb9cba0b4a14)
- Style privacy policy [`10434c8`](https://github.com/Neutron-Creative/Singlelink/commit/10434c8e907bf80f5755857892e670548e10c401)
- Fix basic responsiveness issues [`7ec9836`](https://github.com/Neutron-Creative/Singlelink/commit/7ec9836e0d57b3ebd1da034c3d47b7dc567267d2)
- Whitelabel privacy policy [`c3ed44b`](https://github.com/Neutron-Creative/Singlelink/commit/c3ed44b25cc4856c2f4bae2552f4636889ac9170)
- Updated meta info & added twitter meta [`5f90c06`](https://github.com/Neutron-Creative/Singlelink/commit/5f90c066913de74aae6f63d6d0be0942baec627a)
- Make GDPR banner responsive [`24dd070`](https://github.com/Neutron-Creative/Singlelink/commit/24dd0707759ff3761b9d75eb4f7b6a69c02771c6)
- Fixed changebar and dashboard layout issues [`6a1152b`](https://github.com/Neutron-Creative/Singlelink/commit/6a1152b1b46a7f4c95366f8087a8dfe3064f794c)
- Fix iframe chop on small height devices [`dfe150b`](https://github.com/Neutron-Creative/Singlelink/commit/dfe150bf7a87dfa118b007c5e6cdbecd8337ff49)
- Add unpublished profile alert [`3a54acd`](https://github.com/Neutron-Creative/Singlelink/commit/3a54acd06aaa89f32b7793e9a721e1e346895689)
- Renable scrolling in iframe and hide scrollbar [`0263c47`](https://github.com/Neutron-Creative/Singlelink/commit/0263c47ee8b4fd8735ccf9baf1321a8d3a3f68ca)
- Update GDPR banner styling [`a9fa134`](https://github.com/Neutron-Creative/Singlelink/commit/a9fa1349f6f8b9ea5bf94ef8f4c72e081c5d0db4)
- Fix responsive side-effects on desktop [`cba27ba`](https://github.com/Neutron-Creative/Singlelink/commit/cba27ba58100bb7eba2bd9a64f662ccb0b3c6f11)
- Stylize preview mode [`33dc3b7`](https://github.com/Neutron-Creative/Singlelink/commit/33dc3b7451e45395e6948dbff607a80a450ff441)
- HOTFIX: free signups toggle fixed on profile & whitelabeling on GDPR popup [`4b78c12`](https://github.com/Neutron-Creative/Singlelink/commit/4b78c1246413811c80f6c29a60735c1de59061b9)
- Remove overflow x from middle dashboard section [`61ea030`](https://github.com/Neutron-Creative/Singlelink/commit/61ea030a39e75a15fa93115d4dc170c9cc37c156)
- HOTFIX: Fix broken avatar profile img & style profile filter [`16b49ec`](https://github.com/Neutron-Creative/Singlelink/commit/16b49ec37cd0608b872b5b92facb7df1d612cdae)
- HOTFIX: Fix profile settings buttons in desktop modal [`1067fe8`](https://github.com/Neutron-Creative/Singlelink/commit/1067fe8fceb4f2c1b1ccf796d67ae6428bf439b4)
- Made privacy policy footer responsive [`b433025`](https://github.com/Neutron-Creative/Singlelink/commit/b43302500535a9f3e3fbabde6ef2e8d470e239a4)
- Fix custom domains, specify document type [`09dd044`](https://github.com/Neutron-Creative/Singlelink/commit/09dd044cbfb0b08547d3e0cd46e898a1d9a8c2dc)
- Update readme for new config location [`aca490c`](https://github.com/Neutron-Creative/Singlelink/commit/aca490cc7d9f04aba0d095684f230f7dc7a552cc)
- HOTFIX: Remove padding on right side of GDPR button [`ba03372`](https://github.com/Neutron-Creative/Singlelink/commit/ba03372c7337ea1f01e0c1be235fb7a9e6e52cc4)
- Fix global theme edit modal [`e773e37`](https://github.com/Neutron-Creative/Singlelink/commit/e773e37d4c46c0ec4fcce77cb7f96657d8f4b770)
- Enable scrolling on profile preview [`3e645b3`](https://github.com/Neutron-Creative/Singlelink/commit/3e645b3953dfb9826f1fdb405a5a3900a19e25bf)
- Fix graphic url in SL readme [`6114cda`](https://github.com/Neutron-Creative/Singlelink/commit/6114cdaecde38ee69bc19381e899f4224422810c)
- Fix theme modal overflow problem [`5e49560`](https://github.com/Neutron-Creative/Singlelink/commit/5e495601127ab0cd86e05ff7262e6c7bac432544)
- HOTFIX: added avatar fallback to dashboard avatar [`3f16d1a`](https://github.com/Neutron-Creative/Singlelink/commit/3f16d1ae266eab3a28eb8e76d97314856c5625cd)
- Remove link styles from analytics [`84fd64b`](https://github.com/Neutron-Creative/Singlelink/commit/84fd64b68214cbed376cd4f66ded1aea7cd9e39e)

## [v2.1.6](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.2...v2.1.6) - 2021-01-14

### Commits

- Converted client to typescript [`716b88c`](https://github.com/Neutron-Creative/Singlelink/commit/716b88c6091a7bda661fb9f84609e47c58412897)
- Move user profile into a component [`3ce38ab`](https://github.com/Neutron-Creative/Singlelink/commit/3ce38abe325fb0a6c90adacee5871f90abe38a50)
- Add Theme update/delete operations [`2051e0a`](https://github.com/Neutron-Creative/Singlelink/commit/2051e0a5376a9b5d384bb21ea591af4ac12f7630)
- Update types, fix many bugs [`4a7fd0d`](https://github.com/Neutron-Creative/Singlelink/commit/4a7fd0dc7ed86c7965438bb7b702f59d3491813b)
- Add GDPR privacy policy + popup banner [`f1e2b5a`](https://github.com/Neutron-Creative/Singlelink/commit/f1e2b5a91f3a7af05a8b0798b908e32518daaff3)
- Added admin panel [`a3aa844`](https://github.com/Neutron-Creative/Singlelink/commit/a3aa8445c7fdec2d8d92328a3c5ad4da82b1383c)
- Fix bug with clashing styles [`f0479d7`](https://github.com/Neutron-Creative/Singlelink/commit/f0479d7a384c3fee95ba1c51fbceba6ccf7ba6bb)
- Add rate limit for creating profiles + error message [`20b918b`](https://github.com/Neutron-Creative/Singlelink/commit/20b918bcc50d3e1c337911c6f471de040f6cd8a1)
- SL v2.1 [`fac7c76`](https://github.com/Neutron-Creative/Singlelink/commit/fac7c76478b71fcffed5d10faac748a1cae8b443)
- Add Singlelink watermark (opt-out option too) [`b084df7`](https://github.com/Neutron-Creative/Singlelink/commit/b084df738903af3e24b1189546faded328ab2e05)
- Add beginning to universal emojis [`43d819d`](https://github.com/Neutron-Creative/Singlelink/commit/43d819de5219ed08055751801ef9b0f06beea203)
- Add user filter search above profile selector [`d4b0a69`](https://github.com/Neutron-Creative/Singlelink/commit/d4b0a69a85e19ab97670d0054e6830f43f77fd37)
- Add dotenv [`b253114`](https://github.com/Neutron-Creative/Singlelink/commit/b253114778305d8f6495c39e610f0f5f99923ff6)
- Add custom domain support for TS version [`5b5e968`](https://github.com/Neutron-Creative/Singlelink/commit/5b5e9689f6c60751b3fd077e5c6e1abecb35615e)
- Added gallery & enterprise pricing tier on www [`19a6306`](https://github.com/Neutron-Creative/Singlelink/commit/19a6306e7dc80e9bca227563056498841b15c480)
- Fix auth cookies... wow that was a pain [`e36751b`](https://github.com/Neutron-Creative/Singlelink/commit/e36751b26f653abb282848dca654dda249c08010)
- Fix issue with rendering in dashboard [`8fbaeed`](https://github.com/Neutron-Creative/Singlelink/commit/8fbaeed773954d569e29be61dd987fc0fb7be0f6)
- Rename app-config.ts to config.ts [`e469e6a`](https://github.com/Neutron-Creative/Singlelink/commit/e469e6afe177d2e44593b6676713d99d3d9a2f77)
- Update pricing & gallery pages [`a52352e`](https://github.com/Neutron-Creative/Singlelink/commit/a52352e04d16002c5a63f13d32b4c6eacb1ebba2)
- Add privacy policy for Singlelink hosted [`b155c30`](https://github.com/Neutron-Creative/Singlelink/commit/b155c30e4d6cbeb0c1ca2da256352259b9d15244)
- Update types and fix type mismatches, fix theme modal [`d7062b9`](https://github.com/Neutron-Creative/Singlelink/commit/d7062b956dedcba41875b68a09a8023f349417a2)
- Modified pricing tiers in www [`c79d7b5`](https://github.com/Neutron-Creative/Singlelink/commit/c79d7b5bc79c3f81d8d5ac6679be8f2d3f145b2a)
- Updated pricing pace on www [`309dde3`](https://github.com/Neutron-Creative/Singlelink/commit/309dde3f5984241e65f3b27df4b89ab9194aca02)
- Remove beta link from footer, add analytics link, fix footer link href, update alert, and update version status [`9259ffe`](https://github.com/Neutron-Creative/Singlelink/commit/9259ffe519db78f2ed48cb7559690e37e3f5802c)
- Remove unused dependency [`7aa46fb`](https://github.com/Neutron-Creative/Singlelink/commit/7aa46fbfb949a51be41a5f594d4c6a48bb02f636)
- Update readme.md [`38efa14`](https://github.com/Neutron-Creative/Singlelink/commit/38efa149b7b18f26ce6266c736d15e37f275da93)
- Fix bug with iframe having wrong url (u instead of u-preview) [`145a26a`](https://github.com/Neutron-Creative/Singlelink/commit/145a26a942a85b399410673226a177be7fed0e98)
- Fix issue where themes would throw error instead of empty array [`13b419d`](https://github.com/Neutron-Creative/Singlelink/commit/13b419d0a319b07fc70fce2ff0c5aed70a85cf51)
- Fix hostname [`7fcaa5c`](https://github.com/Neutron-Creative/Singlelink/commit/7fcaa5cc5e3eb82dcc421910da855865fb6527c8)
- Fix bug where dashboard settings fields couldn't be empty strings [`e0f7bdd`](https://github.com/Neutron-Creative/Singlelink/commit/e0f7bdd505ff2bc5458a0da334cdf852cc1d731f)
- Update versioning script again [`91fef7b`](https://github.com/Neutron-Creative/Singlelink/commit/91fef7b771f92052c7daa878c48c400265c129ed)
- Edit vars from HOST to HOSTNAME and server host to SERVER_HOST for clarity. [`98f8ee6`](https://github.com/Neutron-Creative/Singlelink/commit/98f8ee69c447b5377a7f59b4008bd14146bc63a4)
- Fix GDPR thing [`63b811b`](https://github.com/Neutron-Creative/Singlelink/commit/63b811bfe6557fd85373b51477fb028fb78c72da)
- Update twitter image to updated og image in www [`4c2c6c6`](https://github.com/Neutron-Creative/Singlelink/commit/4c2c6c68149875744c2de5082c4ed8267eb24821)
- Updated open-graph image on www [`be152a3`](https://github.com/Neutron-Creative/Singlelink/commit/be152a3e93671fa6eb549e45be8426093fcf1d28)
- Fixed x overflow issue on www [`025616a`](https://github.com/Neutron-Creative/Singlelink/commit/025616ae732c300d47d9dac4c7f2b2e6b8a8c058)
- Center text in open-graph image in www [`ef25745`](https://github.com/Neutron-Creative/Singlelink/commit/ef25745509f3572e07eeec69097b1f2ce2e4a2a6)

## [v2.1.2](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.1...v2.1.2) - 2020-11-24

### Commits

- Update versioning scripts [`f8cff58`](https://github.com/Neutron-Creative/Singlelink/commit/f8cff5835d4a2202a6244e43c7b87b48a8c48893)
- Add a rate limit to the password reset endpoint [`ce98c8f`](https://github.com/Neutron-Creative/Singlelink/commit/ce98c8f4cbd596dbd941b7d545c86993978abee9)
- Update versioning script again [`a443376`](https://github.com/Neutron-Creative/Singlelink/commit/a443376f49bc7d6d9cbdfe817819faa01c4553af)

## [v2.1.1](https://github.com/Neutron-Creative/Singlelink/compare/v2.1.0...v2.1.1) - 2020-11-24

### Commits

- Update styling on changelog link [`16d8c13`](https://github.com/Neutron-Creative/Singlelink/commit/16d8c133a0c1dfa5e203d876820142d8e740c801)
- Update versioning scripts [`da4b3a1`](https://github.com/Neutron-Creative/Singlelink/commit/da4b3a1ab5e3433f9e4e959664f8251620aecafd)

## [v2.1.0](https://github.com/Neutron-Creative/Singlelink/compare/v2.0.2...v2.1.0) - 2020-11-24

### Commits

- Lots of work for server refactor [`89f9105`](https://github.com/Neutron-Creative/Singlelink/commit/89f9105d607d7054a6b51a6cb1cb91f9a45d959d)
- Massive commit with enormous amounts of changes [`801b294`](https://github.com/Neutron-Creative/Singlelink/commit/801b29485ab7f91e14a99e23719deb36b362b5bb)
- Create new server project, call old server "server-old" [`ef8804f`](https://github.com/Neutron-Creative/Singlelink/commit/ef8804f719187d1570cf464b42b1505c97695793)
- Current work [`1937698`](https://github.com/Neutron-Creative/Singlelink/commit/19376987307420d128189581b473241ab3d7f39a)
- Fixed a lot of client related bugs [`7ddf99e`](https://github.com/Neutron-Creative/Singlelink/commit/7ddf99eda089b6fe4013dba42d566d36d23cd386)
- Finish up Theme Controller, Profile Controller, and everything else [`11673c2`](https://github.com/Neutron-Creative/Singlelink/commit/11673c2c85615cd1dff7913f4e3e7f8f0716d196)
- Password reset emails are now configurable (replacement vars documentation coming soon) [`8ba218e`](https://github.com/Neutron-Creative/Singlelink/commit/8ba218ee1a4064852401dfd92c01895a9db0b90d)
- Disable autocomplete on handle text field [`3a43676`](https://github.com/Neutron-Creative/Singlelink/commit/3a4367668b83d679d6c19b0a97b6bf2cabdb2c97)
- Cleanup terminology [`e0f7e2e`](https://github.com/Neutron-Creative/Singlelink/commit/e0f7e2eed5dcdc0fb6cf572c87fec43423238215)
- Further restrict types [`e0fe44c`](https://github.com/Neutron-Creative/Singlelink/commit/e0fe44cd0e78a9382839c202baf37ef191e3ef7a)
- Fix typos and update paths [`a59e367`](https://github.com/Neutron-Creative/Singlelink/commit/a59e367123583731f3c1273bade1982e45664142)
- Bind (this) context to route handlers [`90651d5`](https://github.com/Neutron-Creative/Singlelink/commit/90651d5172a05b2d5f6b7aa4758cb93fbb429c6b)
- Add versioning info to client, and add version information from server [`ba1505a`](https://github.com/Neutron-Creative/Singlelink/commit/ba1505a77e33477e93de89603d59506a3c7241fc)
- Change auth manual object to Converter [`a79d248`](https://github.com/Neutron-Creative/Singlelink/commit/a79d248e2b146553f68d6383fb4f852f2c00a886)
- Update documentation [`6fe9133`](https://github.com/Neutron-Creative/Singlelink/commit/6fe9133aa82bb3121161d04abc42205c8b637c38)
- Add email hash to createUser method [`905e35b`](https://github.com/Neutron-Creative/Singlelink/commit/905e35baf1a9987458490339fcb0d3c07057ab0f)
- Update link target to link id [`34a8241`](https://github.com/Neutron-Creative/Singlelink/commit/34a8241ef7bc267b0fedb5da6d0b6bbdf394294c)
- Update styling on changelog link [`1858112`](https://github.com/Neutron-Creative/Singlelink/commit/18581126eca44d18de95c44e75b715aa084472fe)
- Fix readme img [`4de7132`](https://github.com/Neutron-Creative/Singlelink/commit/4de7132cd0de41a0b11d73443b16f774e1971a7c)

## [v2.0.2](https://github.com/Neutron-Creative/Singlelink/compare/2.0.1...v2.0.2) - 2021-01-14

### Commits

- Update readme [`828de37`](https://github.com/Neutron-Creative/Singlelink/commit/828de376174dbc05f75c396ce5d9e2e327f11854)
- Update website [`37e37ce`](https://github.com/Neutron-Creative/Singlelink/commit/37e37ce5fd7ad4a8efebd65881076bdda4c0d159)
- Update project readme, final update for v2.0.2 [`48ee03b`](https://github.com/Neutron-Creative/Singlelink/commit/48ee03bcdf608f4d0321edbfc761673c2164f44a)
- Update for v2.1 maintenance window [`a23ba07`](https://github.com/Neutron-Creative/Singlelink/commit/a23ba07621e2263b08f47ddfb189b0de98229d52)
- Update OG image [`6326a01`](https://github.com/Neutron-Creative/Singlelink/commit/6326a012cbcd01e907db70085b7dcb83ecddf2a6)

## [2.0.1](https://github.com/Neutron-Creative/Singlelink/compare/v2.0.1...2.0.1) - 2020-12-23

### Commits

- Fix issue where account signups weren't working [`6ee8efa`](https://github.com/Neutron-Creative/Singlelink/commit/6ee8efa5bc5e602bc244c053df0ba0d0d59c39f0)
- Add beginning to universal emojis [`43d819d`](https://github.com/Neutron-Creative/Singlelink/commit/43d819de5219ed08055751801ef9b0f06beea203)
- Added gallery & enterprise pricing tier on www [`19a6306`](https://github.com/Neutron-Creative/Singlelink/commit/19a6306e7dc80e9bca227563056498841b15c480)
- Add service outage post and update banner [`dbed759`](https://github.com/Neutron-Creative/Singlelink/commit/dbed7593a1fd127b0384aaa9efb1f6dad1c1aa1d)
- Update pricing & gallery pages [`a52352e`](https://github.com/Neutron-Creative/Singlelink/commit/a52352e04d16002c5a63f13d32b4c6eacb1ebba2)
- Add privacy policy for Singlelink hosted [`b155c30`](https://github.com/Neutron-Creative/Singlelink/commit/b155c30e4d6cbeb0c1ca2da256352259b9d15244)
- Modified pricing tiers in www [`c79d7b5`](https://github.com/Neutron-Creative/Singlelink/commit/c79d7b5bc79c3f81d8d5ac6679be8f2d3f145b2a)
- Updated pricing pace on www [`309dde3`](https://github.com/Neutron-Creative/Singlelink/commit/309dde3f5984241e65f3b27df4b89ab9194aca02)
- Remove beta link from footer, add analytics link, fix footer link href, update alert, and update version status [`9259ffe`](https://github.com/Neutron-Creative/Singlelink/commit/9259ffe519db78f2ed48cb7559690e37e3f5802c)
- Update readme.md [`38efa14`](https://github.com/Neutron-Creative/Singlelink/commit/38efa149b7b18f26ce6266c736d15e37f275da93)
- Add status link and ajax analytics hotfix for www [`30c49f3`](https://github.com/Neutron-Creative/Singlelink/commit/30c49f378f56d17b31cc8cfa78721e7529be93d0)
- Add service outage warning [`3932ea9`](https://github.com/Neutron-Creative/Singlelink/commit/3932ea9f87d6263ad5f1408fe1cc6195d4b1bb6a)
- Fix create account error [`0c10008`](https://github.com/Neutron-Creative/Singlelink/commit/0c100087fd101126935e21eba9ca707d6aae14bb)
- Update FUNDING.yml [`0877b92`](https://github.com/Neutron-Creative/Singlelink/commit/0877b926042bb744b23fefff3092eb78a6104faa)
- Create FUNDING.yml [`68c7538`](https://github.com/Neutron-Creative/Singlelink/commit/68c7538b7606d9663f7e624f3b792eab88e9fe7f)
- Update twitter image to updated og image in www [`4c2c6c6`](https://github.com/Neutron-Creative/Singlelink/commit/4c2c6c68149875744c2de5082c4ed8267eb24821)
- Updated open-graph image on www [`be152a3`](https://github.com/Neutron-Creative/Singlelink/commit/be152a3e93671fa6eb549e45be8426093fcf1d28)
- Update FUNDING.yml pt 2 [`aa0e526`](https://github.com/Neutron-Creative/Singlelink/commit/aa0e526321112a40a74cd8ade3463a216b88d3f8)
- Update readme user count api [`25045fb`](https://github.com/Neutron-Creative/Singlelink/commit/25045fb47838064b986f02d50f69753e93d210cf)
- Fixed x overflow issue on www [`025616a`](https://github.com/Neutron-Creative/Singlelink/commit/025616ae732c300d47d9dac4c7f2b2e6b8a8c058)
- Center text in open-graph image in www [`ef25745`](https://github.com/Neutron-Creative/Singlelink/commit/ef25745509f3572e07eeec69097b1f2ce2e4a2a6)

## [v2.0.1](https://github.com/Neutron-Creative/Singlelink/compare/v1.5.1...v2.0.1) - 2020-10-28

### Commits

- Add website to project [`281232c`](https://github.com/Neutron-Creative/Singlelink/commit/281232c0ee90d4730835289f5bc474046b18ea60)
- Add official GPL license.md [`8d56da1`](https://github.com/Neutron-Creative/Singlelink/commit/8d56da1afba8a188c3ee2430c5ae2513dec4ce90)
- Change readme promo graphic to alternate [`151b397`](https://github.com/Neutron-Creative/Singlelink/commit/151b397ced3df5e2f52919109b1e08edc755a87b)
- WIP: TAKING OUT THE TRASH, DOWNLOAD LAST COMMIT [`220da87`](https://github.com/Neutron-Creative/Singlelink/commit/220da87b17264f6276e27453e0e7fc2a88773bf0)
- Remove many extraneous console logs that were unnecessary showing traffic data [`ccbbf4e`](https://github.com/Neutron-Creative/Singlelink/commit/ccbbf4e047e742beefce4f33e8e626af5c3a64ef)
- Update website social assets [`5c931d6`](https://github.com/Neutron-Creative/Singlelink/commit/5c931d6d9096417fc0df229155cc1b90c0c8284d)
- Remove SSL support (for now, will be replaced with proper Proxy in V3) [`ae07db8`](https://github.com/Neutron-Creative/Singlelink/commit/ae07db8ea0c689c87d02b1ab0bf1f2b9f73f2739)
- Added profile visit overview fetching [`5dfea6d`](https://github.com/Neutron-Creative/Singlelink/commit/5dfea6dd40783ca5cc8652b03f05ed3170b15e18)
- Analytics is done - final update for v2.0 [`fcf8609`](https://github.com/Neutron-Creative/Singlelink/commit/fcf86096bce271b2afb202832caa33b2dfe75474)
- Update OG Image thumbnail [`cd6282f`](https://github.com/Neutron-Creative/Singlelink/commit/cd6282faa80006dc588e12646ee5daf673c8a63e)
- Dumpster gonito! [`565fd0b`](https://github.com/Neutron-Creative/Singlelink/commit/565fd0b98af87d93a63ee56b1872721248638ef4)
- Add server config.js example [`b46799e`](https://github.com/Neutron-Creative/Singlelink/commit/b46799ec5ccbb84ab5e667e9cf848feaf4590a37)
- Cleanup SSL comments [`d1fd272`](https://github.com/Neutron-Creative/Singlelink/commit/d1fd272d4d9887736ac2d9ee7af5421aa5205330)
- Change OG Image resolution AGAIN [`6202898`](https://github.com/Neutron-Creative/Singlelink/commit/6202898869ae73ce71a26e9ab60614d408eab69e)
- WIP: TAKING OUT THE TRASH, DOWNLOAD LAST COMMIT [`f375e0e`](https://github.com/Neutron-Creative/Singlelink/commit/f375e0e7b2aae4960cd5d9e4f956d75b7dc93138)
- Added meta tags for Twitter preview! [`a5c809d`](https://github.com/Neutron-Creative/Singlelink/commit/a5c809d3a6c6a8db54823dd2c9d318fe9a1a5f07)
- Remove SSL from localhost domains [`296e7d4`](https://github.com/Neutron-Creative/Singlelink/commit/296e7d4e8f2c8b4309ed49bd41d9952b421f9897)
- Change global.config to config [`9a6491e`](https://github.com/Neutron-Creative/Singlelink/commit/9a6491e6daf1b90da9550ee1d4d86be59c2c3703)
- Add custom domain support to client & fix custom domains api [`de58c42`](https://github.com/Neutron-Creative/Singlelink/commit/de58c42642ec20539c085c4f4c71a2060288f2ed)
- Fix for VisitController routing only GET requests [`2bfe1e5`](https://github.com/Neutron-Creative/Singlelink/commit/2bfe1e55afbe533a2de937794efbd22664c0fe98)
- Add CTR to analytics API [`ca44622`](https://github.com/Neutron-Creative/Singlelink/commit/ca44622aa06976526667aeb08d1b75717f2f7554)
- Fix another SSL issue, where config.apiDomain would only work in a production environment [`6ab390c`](https://github.com/Neutron-Creative/Singlelink/commit/6ab390cd5fc81188bbc61f2bd8a255657c5e5c7f)
- Update version no. [`49b87f8`](https://github.com/Neutron-Creative/Singlelink/commit/49b87f8d8cd72579ba64bcd51568c709fd756217)
- HOTFIX: correct my idiot mistake last commit with image url pt3 [`9bcbd4f`](https://github.com/Neutron-Creative/Singlelink/commit/9bcbd4f674d1d2406712ee66e7b107190bccf5b8)
- HOTFIX: correct my idiot mistake last commit with image url [`6a125e4`](https://github.com/Neutron-Creative/Singlelink/commit/6a125e487a22602abb0dd87af9ba6c51f5fa81ac)
- Add promotional graphic to readme [`8f6ecfa`](https://github.com/Neutron-Creative/Singlelink/commit/8f6ecfa7ad22a4663763a2ef5341f62a989c0050)
- HOTFIX: add comma to fix syntax error in www [`825486a`](https://github.com/Neutron-Creative/Singlelink/commit/825486a0d07cdf4170e67b102fcc5f819c10137f)
- Resolve dependabot issue #49 [`b78f5c6`](https://github.com/Neutron-Creative/Singlelink/commit/b78f5c6e77ac4201e85915deafba7008860afac0)
- HOTFIX: correct my idiot mistake last commit with image url [`3819ae0`](https://github.com/Neutron-Creative/Singlelink/commit/3819ae0d27f5336f0035a798fac5a1dae83d855e)
- Fix footer link to beta in www [`afad435`](https://github.com/Neutron-Creative/Singlelink/commit/afad435e3aa40195ddfdd7dc95415dc376276d0d)
- Uyuhhhh lemme just change that right back [`99b69d9`](https://github.com/Neutron-Creative/Singlelink/commit/99b69d98cf3f449bcb6b4ef86d733eec979e7c17)
- Make OG Image ref relative [`e3d97a2`](https://github.com/Neutron-Creative/Singlelink/commit/e3d97a2c8ae59b43144dc316dd588361778e17be)
- Change homepage copy [`a1eedcb`](https://github.com/Neutron-Creative/Singlelink/commit/a1eedcb9232e40aa02fc5f5dd932f3c553bc3d72)
- Fix avatar deletion on edit issue [`5e1746a`](https://github.com/Neutron-Creative/Singlelink/commit/5e1746a8da0d0b4c8c07e57f4b9d57d29ebb7972)
- Adjust dashboard setting panel margin [`09b539c`](https://github.com/Neutron-Creative/Singlelink/commit/09b539cd8658ec1b7da5fe78b01000f4dd2eaa93)
- Move config example into /server [`3dafa99`](https://github.com/Neutron-Creative/Singlelink/commit/3dafa99749fbca184e6ef188596de379e2d41bb1)

## [v1.5.1](https://github.com/Neutron-Creative/Singlelink/compare/v0.9.0...v1.5.1) - 2020-10-17

### Commits

- Add SSL support (needs testing on a live server) [`34b37cd`](https://github.com/Neutron-Creative/Singlelink/commit/34b37cda70e49abba5f5c128c02a806576d4e692)
- Update types [`da263fc`](https://github.com/Neutron-Creative/Singlelink/commit/da263fcb77b4a92fd3c9cd4a570a33c5c892ac6d)
- Added custom domain support (commented out SSL, it is REALLY complicated) [`e0d5276`](https://github.com/Neutron-Creative/Singlelink/commit/e0d52768b1b28378f9ac648f29ca8821da2fe6d9)
- Convert vars to consts/lets [`d8a8ca9`](https://github.com/Neutron-Creative/Singlelink/commit/d8a8ca9c9cf1e73290b05801e63162eb326f3868)
- Update redbird [`611b011`](https://github.com/Neutron-Creative/Singlelink/commit/611b01176e95923713bb64722bd824b1b71d850b)
- Password reset functionality [`9b8f4ba`](https://github.com/Neutron-Creative/Singlelink/commit/9b8f4ba633cb13be7091a71199abec04bba32cb5)
- Migrated client from static to SSR [`21cc2ec`](https://github.com/Neutron-Creative/Singlelink/commit/21cc2eca196295eef0b0eb8aa2d76d77ce2b6894)
- Server-side rendering [`6f671a2`](https://github.com/Neutron-Creative/Singlelink/commit/6f671a252baf98c820f0e1bd54bf6755af3e3d52)
- Add rudimentary deeplink support using nc-deeplink. Needs frontend + options, however [`bc9e9f1`](https://github.com/Neutron-Creative/Singlelink/commit/bc9e9f1f3b958a3c3c4f1232661602fe7f99ce4f)
- Patch issue with le-store-certbot [`fc33024`](https://github.com/Neutron-Creative/Singlelink/commit/fc330249ed2d1df198c0972c743d3354dce199ad)
- Add checks for environment [`c27b05a`](https://github.com/Neutron-Creative/Singlelink/commit/c27b05ab67e466004c2b65a6a8c5403054234232)
- Disable SSLs for custom domains on development environment [`5109d6d`](https://github.com/Neutron-Creative/Singlelink/commit/5109d6d985095191fcbc852753332bf0e3da3b13)
- Fix environment checking for proxy [`60cf87b`](https://github.com/Neutron-Creative/Singlelink/commit/60cf87bf83586b549bc909a197ec134507e3a94c)
- Add missing SSL options [`1da2c26`](https://github.com/Neutron-Creative/Singlelink/commit/1da2c26b0e2dff78978d87e88917077425fb2565)
- Added custom domain meta tags for facebook & twitter [`2ea73a3`](https://github.com/Neutron-Creative/Singlelink/commit/2ea73a37ae06ecd3bcc6700ac7947fb01be23535)
- Force unique custom domains & add headline as temporary title on custom domain render [`07af186`](https://github.com/Neutron-Creative/Singlelink/commit/07af1865fcf8fc991b471b780082ae1be634f6e8)
- Fix issue with mongodb event emitter + unnecessary proxy unregisters [`0484a61`](https://github.com/Neutron-Creative/Singlelink/commit/0484a615529ac2382fc8042a6aab0b5be1be3e07)
- Updated custom domains middleware template to fix SEO & scaling issues [`637464c`](https://github.com/Neutron-Creative/Singlelink/commit/637464c2cefd639130ccfa8589629631131a1c4d)
- Change redbird dependency to our own fork [`b241b1d`](https://github.com/Neutron-Creative/Singlelink/commit/b241b1dfc442a60ea37924e7db7921b8bbf72bad)
- Add message about which mode the server is starting in [`216c160`](https://github.com/Neutron-Creative/Singlelink/commit/216c16089d5ed94228b34bf3726ee7fc715192d2)
- Pre-emptively fixed custom_domain emptying bug on profile appearance update [`9a1c24d`](https://github.com/Neutron-Creative/Singlelink/commit/9a1c24d6c3a968c134696459529b19326dbb7a36)
- Fix AWS import [`43b1847`](https://github.com/Neutron-Creative/Singlelink/commit/43b18473ad8e08ab568e59f861921d1252ab5e34)
- HOTFIX: fixed typo in custom domains twitter meta description [`ba702ac`](https://github.com/Neutron-Creative/Singlelink/commit/ba702acce073f3768f1fcfa4282476e8fe35220e)
- Fix brandmark path in readme [`82f8b4c`](https://github.com/Neutron-Creative/Singlelink/commit/82f8b4c860aaa2ca794de05b5553ea774a9b2957)
- Update link model [`fd97399`](https://github.com/Neutron-Creative/Singlelink/commit/fd973995a5e2249f45ef217d61409e4c1f7a7e02)
- Change vars to consts/lets [`5ba59f2`](https://github.com/Neutron-Creative/Singlelink/commit/5ba59f278a58621104151ba48fccfa541a5a55a3)
- Rename *.vue to _.vue [`25b6c01`](https://github.com/Neutron-Creative/Singlelink/commit/25b6c01cd610d6d2d4046dfc893b97e15061c368)
- Rename *.vue to _.vue [`37ddce3`](https://github.com/Neutron-Creative/Singlelink/commit/37ddce3b6a001ff79b59cdb164f380e3729dd132)
- Rename *.vue to _.vue [`6a4332b`](https://github.com/Neutron-Creative/Singlelink/commit/6a4332b39667df0ad4226543010400613a8bb540)
- Rename *.vue to _.vue [`102e7b3`](https://github.com/Neutron-Creative/Singlelink/commit/102e7b3350a4de743b65a9578933df967ed7ccc7)

## v0.9.0 - 2020-09-26

### Merged

- Fixing twitter link [`#15`](https://github.com/Neutron-Creative/Singlelink/pull/15)
- Merge updated readme to master (feature/11-update-READMEmd) [`#14`](https://github.com/Neutron-Creative/Singlelink/pull/14)
- Merge alternative branches to master for production [`#12`](https://github.com/Neutron-Creative/Singlelink/pull/12)

### Commits

- Updated README.md [`47dc8a7`](https://github.com/Neutron-Creative/Singlelink/commit/47dc8a796cd39df296761e8e3581c76c1c4e8d6e)
- Draft commit to test functionality [`8588d63`](https://github.com/Neutron-Creative/Singlelink/commit/8588d63b8dd15e2b564e85ab60daeba7a8cf8efb)
- Lots of changes! [`56c641d`](https://github.com/Neutron-Creative/Singlelink/commit/56c641dd19098234c63a54acdcaec0ef1f51dfd6)
- Dashboard layout feeling good [`df8e403`](https://github.com/Neutron-Creative/Singlelink/commit/df8e403e4960f1e112a6676d115ad8cd96d34c37)
- Added themes and custom html [`1f9c9cc`](https://github.com/Neutron-Creative/Singlelink/commit/1f9c9cc61e78332665faf5b5d28a3e54185ba34d)
- Added sign up page [`f7755f2`](https://github.com/Neutron-Creative/Singlelink/commit/f7755f2336aeb1c6bc430c439889c857318ce881)
- static client almost done pls dont contribute like me my github practices are garbage [`467f868`](https://github.com/Neutron-Creative/Singlelink/commit/467f8684877c24fdcf7750a7689a9c297a4df176)
- I think? [`377ca32`](https://github.com/Neutron-Creative/Singlelink/commit/377ca326ddda712a410b391c6a39c4c114f94b40)
- Added modals! [`8c1ca43`](https://github.com/Neutron-Creative/Singlelink/commit/8c1ca43ed348ba2c63c21c4b38b1e76aad6602e4)
- ? [`e7c6bb1`](https://github.com/Neutron-Creative/Singlelink/commit/e7c6bb158fba306824a005bf55c5d7838fcf3744)
- Added multiple profile support [`6f19275`](https://github.com/Neutron-Creative/Singlelink/commit/6f192751052184e10b5a707b6ca1a25fbfb1c370)
- Pushing to master to switch branches for best practice [`5e38374`](https://github.com/Neutron-Creative/Singlelink/commit/5e38374f542039a51ad2b6f68f8491345825114f)
- Update readme.md [`4edea79`](https://github.com/Neutron-Creative/Singlelink/commit/4edea79256c973e8458e00e649110a52fc819195)
- Add public analytics panel [`9780264`](https://github.com/Neutron-Creative/Singlelink/commit/9780264dead4d72b6999ba2c131085702d1ef059)
- Looking good [`66104e8`](https://github.com/Neutron-Creative/Singlelink/commit/66104e877b4eba07f54d1d7e39c8f2c2894815bf)
- Destruction added, there was an attempt at versioning [`57d0cbd`](https://github.com/Neutron-Creative/Singlelink/commit/57d0cbdee6c6f579260fe5bb912ec9ee87691528)
- Oops forgot to branch [`0519a64`](https://github.com/Neutron-Creative/Singlelink/commit/0519a648b618e8926c83a99192eb2f210bb2116d)
- Added growth fields to analytics panel [`cc7a9c4`](https://github.com/Neutron-Creative/Singlelink/commit/cc7a9c4891f1b843f094ea3b1450a4e341c1d50e)
- Added subtitles and custom_css to links [`1dffa0c`](https://github.com/Neutron-Creative/Singlelink/commit/1dffa0c77353ca8a9921e922e182ad0ada8d44bf)
- More small changes [`b4a7284`](https://github.com/Neutron-Creative/Singlelink/commit/b4a7284182f09556e02995d2c95a76164bbce5d7)
- Updated readme [`a7fde79`](https://github.com/Neutron-Creative/Singlelink/commit/a7fde7905ca0a5ef20ba27bf3d3ff05d2eff8e3b)
- Added pseudo-dynamic meta content to profiles [`550c4c9`](https://github.com/Neutron-Creative/Singlelink/commit/550c4c9d500b2c708b5e19209f0dd68379da2d15)
- Adding instructions [`79701e2`](https://github.com/Neutron-Creative/Singlelink/commit/79701e203f56ace368220a79d2dea6099f112166)
- Updating readme [`872fab9`](https://github.com/Neutron-Creative/Singlelink/commit/872fab99fc5f774f1c6d991089bb01494d2f3b73)
- Added sensitive content warnings into production [`6524f57`](https://github.com/Neutron-Creative/Singlelink/commit/6524f57e8fc6fea129d1d0287c14c79e98365f4a)
- Trying designs 2 [`f9c96dd`](https://github.com/Neutron-Creative/Singlelink/commit/f9c96dddfa821efec2dc12913cd663de48695c61)
- Added handle support to signup [`6cb66bc`](https://github.com/Neutron-Creative/Singlelink/commit/6cb66bc84ff21d77f9208fe2449e4865bcd903ec)
- Better create modal errors [`800c468`](https://github.com/Neutron-Creative/Singlelink/commit/800c468bed3632ab7ee1cbb781e9b0b7fc434fdc)
- Added refresh to analytics panel [`53d48ba`](https://github.com/Neutron-Creative/Singlelink/commit/53d48bac2b767c16ada0b949675d631424bbc322)
- Updated readme [`67c9ea2`](https://github.com/Neutron-Creative/Singlelink/commit/67c9ea282f5c1903659a3684edb983f79af73d89)
- Updated links for shields [`eac26b1`](https://github.com/Neutron-Creative/Singlelink/commit/eac26b17ca2e0e2daf01ecf5443939150ac9c7c7)
- Another attempt [`3b32dc1`](https://github.com/Neutron-Creative/Singlelink/commit/3b32dc1a2bef25cbda87470037f158f8fd14379f)
- Added more modals [`6dbeb10`](https://github.com/Neutron-Creative/Singlelink/commit/6dbeb1004436ca7e61d7b4641f8f34c84a26677a)
- Added sections [`4799b16`](https://github.com/Neutron-Creative/Singlelink/commit/4799b163afe394ac849913becc43d4be225054b1)
- Add profile image URL update [`4f503c2`](https://github.com/Neutron-Creative/Singlelink/commit/4f503c2705f870f530123bc72dc1187d83d4e60a)
- Trying stuff [`1c97733`](https://github.com/Neutron-Creative/Singlelink/commit/1c9773317e27eeee32bbd00652e5e98d1efd2d9c)
- Move shields into h1 [`3f7411d`](https://github.com/Neutron-Creative/Singlelink/commit/3f7411d3be5f8b8d1b4dc620c87096998ed52c82)
- Maybe? 3 [`7d4b543`](https://github.com/Neutron-Creative/Singlelink/commit/7d4b5432536ffbcc8d8d0fca4f83404cd6e7fb5e)
- Make first changes to READMEmd [`494d9d4`](https://github.com/Neutron-Creative/Singlelink/commit/494d9d4aea3ad741604ca50d5ea47ebc7ae1223b)
- Added logout page [`9b6bc54`](https://github.com/Neutron-Creative/Singlelink/commit/9b6bc540cc134398071624ea0172bf03816e411e)
- Added some nice details [`13d6584`](https://github.com/Neutron-Creative/Singlelink/commit/13d65844f690dfa4f19a37a4aa89d193db670570)
- Added pretty logout link to profile switcher [`91c9462`](https://github.com/Neutron-Creative/Singlelink/commit/91c946279de7b1b6dc65576812bfbeb6e0533bf3)
- Make link subtitle branded via theme [`d493bdf`](https://github.com/Neutron-Creative/Singlelink/commit/d493bdfbbd6500a833a422974c425d2fccda9b47)
- Update OG image tag placement [`7f995cd`](https://github.com/Neutron-Creative/Singlelink/commit/7f995cdb97cd3aae740cec09c2df8d152de1f486)
- Add key features [`1110bfd`](https://github.com/Neutron-Creative/Singlelink/commit/1110bfd96208fc16fce388d4fc0bb1da6354da61)
- Added password reset link [`46a0ac9`](https://github.com/Neutron-Creative/Singlelink/commit/46a0ac9b3d8a45cbb4e10a171015aea089d6b5ae)
- Add whitespace? [`6008744`](https://github.com/Neutron-Creative/Singlelink/commit/600874472b26c2e5f73f55b2e5c91e368a9789cd)
- Remove hyphens from li [`0563ed1`](https://github.com/Neutron-Creative/Singlelink/commit/0563ed12768a2ca4a2df6f98e7d1883c9b80c839)
- Maybe? [`535fc27`](https://github.com/Neutron-Creative/Singlelink/commit/535fc27dc73d698c8ee521532200337380c7b082)
- Fixed malformed token error issue [`01b4eb5`](https://github.com/Neutron-Creative/Singlelink/commit/01b4eb5c8b82ce6ca7429aae6c0b006bc984f9d9)
- Trying designs [`63ee4d8`](https://github.com/Neutron-Creative/Singlelink/commit/63ee4d87d3931333cf67ef2d9f477f8fbe5c3205)
- Trying flexbox [`14645c6`](https://github.com/Neutron-Creative/Singlelink/commit/14645c6dbfb42154141ab5b636b98568ca40e218)
- Decrease link subtitle margin [`d9b222f`](https://github.com/Neutron-Creative/Singlelink/commit/d9b222f25a9a06aa9f83b158626514aff75166c7)
- Minor fixes [`e03957b`](https://github.com/Neutron-Creative/Singlelink/commit/e03957baae4ffa99b3fd3a9e73464e0acc723fbe)
- Add paragraph [`3380867`](https://github.com/Neutron-Creative/Singlelink/commit/33808678702fd93c92645bca0ec30b54901b4b77)
- Trying other solutions lol [`d2b3560`](https://github.com/Neutron-Creative/Singlelink/commit/d2b35605bcb10186422f83cadfb889a7e9b031b2)
- Trying other solutions [`829007e`](https://github.com/Neutron-Creative/Singlelink/commit/829007ece49754442ff49b9980b231a58b7d7c1b)
- Move br in h1 [`ccdd10e`](https://github.com/Neutron-Creative/Singlelink/commit/ccdd10ed2506c3f0df76aef6084ca75928bda2b0)
- Unintentional but that works [`245864d`](https://github.com/Neutron-Creative/Singlelink/commit/245864d3c9950eb7eb4500038ec4a0ad1224b146)
- Expirimental image [`d699e18`](https://github.com/Neutron-Creative/Singlelink/commit/d699e18413ba383edf141b9f9f5abc7cc3040582)
- Fix h1g [`0000190`](https://github.com/Neutron-Creative/Singlelink/commit/0000190a5bc293bc8ff5983ce16ef7c0018924fe)
- HOTFIX: v-html replacement on u/*.vue [`ebfbb54`](https://github.com/Neutron-Creative/Singlelink/commit/ebfbb54fc17224af57692623c3bd42ad1bcbb97b)
- Fixed sensitive content height [`82d362a`](https://github.com/Neutron-Creative/Singlelink/commit/82d362af90dab6133dc9280ece3246642f8d0647)
- Change CSS Class for Link subtitle [`964ffdb`](https://github.com/Neutron-Creative/Singlelink/commit/964ffdb2163986e5536affc4947f34df2af8d018)
- Lousy alerts on create modal [`4bd7adc`](https://github.com/Neutron-Creative/Singlelink/commit/4bd7adc8b2c407fb5d1d9be424f18058f9dfe747)
- More slight details [`3deaaed`](https://github.com/Neutron-Creative/Singlelink/commit/3deaaedb8b9a3a04d7a8c79a40132b2c47486ca6)
- Added whitespace [`c95c914`](https://github.com/Neutron-Creative/Singlelink/commit/c95c9145addd3e687502ba8e3abce8f7ead761aa)
- Begin basic link tracking [`0129750`](https://github.com/Neutron-Creative/Singlelink/commit/012975019f242c82729645a4ab8b1ffa33c20b5a)
- Temporary user count update [`71bd306`](https://github.com/Neutron-Creative/Singlelink/commit/71bd306831aa7dbfe95954c2a680dadda69ff9a1)
- Fill related tab [`d60cae3`](https://github.com/Neutron-Creative/Singlelink/commit/d60cae31d0c56fcdf5e14b8fdaf8a412bddab403)
- Attempt to fix whitespace [`f6d44dd`](https://github.com/Neutron-Creative/Singlelink/commit/f6d44dd387cdd7972fee2ab135777051bb776e81)
- Add whitespace [`177fcc6`](https://github.com/Neutron-Creative/Singlelink/commit/177fcc61af66fa25fd0dada6408c8732a978940c)
- Undo [`553ee03`](https://github.com/Neutron-Creative/Singlelink/commit/553ee0301427d4b60ab81fdd851d7c0e68b276f3)
- Reduce whitespace [`ac0a453`](https://github.com/Neutron-Creative/Singlelink/commit/ac0a45388716eece49936af56b4b2ce6af60a749)
- Make brandmark larger 4 [`9ec96b2`](https://github.com/Neutron-Creative/Singlelink/commit/9ec96b2852c159f6fd2ca108f78f6965e0dd878b)
- Make brandmark larger 3 [`e3f3e5a`](https://github.com/Neutron-Creative/Singlelink/commit/e3f3e5ad38b98201b82faf2186dccdfcbcc70e70)
- Make brandmark larger [`dd85df9`](https://github.com/Neutron-Creative/Singlelink/commit/dd85df990bd879d8def1c5311ded0e31cd3a11a2)
- Make brandmark larger [`8ab13ed`](https://github.com/Neutron-Creative/Singlelink/commit/8ab13ed44762415d1f1ef6d7e36ec370ba7f33e4)
- Unintentional but that works 2 [`eb72800`](https://github.com/Neutron-Creative/Singlelink/commit/eb72800b4861c5898e735381dd24909dca43c7b2)
- Maybe? 2 [`f37384e`](https://github.com/Neutron-Creative/Singlelink/commit/f37384e30190fc45203e6c3a29d7c8c60cfe257f)
- Update readme.md pt 2 [`f26fa04`](https://github.com/Neutron-Creative/Singlelink/commit/f26fa0481284ad9e23198ff6b45f02fa371e8c9e)
- Apply styles to draggable items [`549470a`](https://github.com/Neutron-Creative/Singlelink/commit/549470ac423658c9f9b941a60cc5668b3b6312f2)
- Update custom_css placeholder [`7095286`](https://github.com/Neutron-Creative/Singlelink/commit/7095286b70586f27e5f02679665e3e3eef873fee)
- Add custom link styles to public profile [`9139b43`](https://github.com/Neutron-Creative/Singlelink/commit/9139b434a35d85e144e941485c5f27fca892e149)
- Hotfix: Change analytics.users to analytics.themes [`9b42ba9`](https://github.com/Neutron-Creative/Singlelink/commit/9b42ba92768ecf2f817e170331a8dbf92cfb5a44)
- Center analytics timestamp [`7a4a478`](https://github.com/Neutron-Creative/Singlelink/commit/7a4a478ec24ab7c1538bdd0930a0cdaf1d7f0e86)
- Update image URL label [`6e13809`](https://github.com/Neutron-Creative/Singlelink/commit/6e13809cd565d4fb4bc6ff1813430c409df1d637)
- Push forgot password mailto! [`5de239f`](https://github.com/Neutron-Creative/Singlelink/commit/5de239fdafc4ef227747f93e2120479fd95f7fb7)
- It wont fucking work for some reason [`7663256`](https://github.com/Neutron-Creative/Singlelink/commit/7663256bc5855643f4794659d4ae8ba0d5118af9)
- Slight indentation CSS bug [`e10403c`](https://github.com/Neutron-Creative/Singlelink/commit/e10403cb8c26d4da71d71eb5c0d0169f7482f123)
- Hotfix: fixed custom css/html scramble bug [`948a18e`](https://github.com/Neutron-Creative/Singlelink/commit/948a18e81c33f29833e034b2dd0bc119ce92b759)
- Minor fixes pt2 [`b0ee40e`](https://github.com/Neutron-Creative/Singlelink/commit/b0ee40e4a230c2f1eeaa5c45de995404b821f18d)
- Fix iframe origin [`c401457`](https://github.com/Neutron-Creative/Singlelink/commit/c4014578f51c6221201945fde2940bdc60fd2737)
- Remove br from h1 [`6dcdbe3`](https://github.com/Neutron-Creative/Singlelink/commit/6dcdbe3ef0847a9e28971723e3e7905ab30a39e1)
